/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import com.google.common.io.CharStreams;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.nodemodel.impl.SerializableNodeModel;
import org.eclipse.xtext.nodemodel.serialization.DeserializationConversionContext;
import org.eclipse.xtext.parser.ParseResult;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@FinalFieldsConstructor
public class ResourceStorageLoadable {
    private static final Logger LOG = Logger.getLogger(ResourceStorageLoadable.class);
    private final InputStream in;
    private final boolean storeNodeModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIntoResource(StorageAwareResource resource) throws IOException {
        boolean _not;
        boolean _isLoadedFromStorage = resource.isLoadedFromStorage();
        boolean bl = _not = !_isLoadedFromStorage;
        if (_not) {
            throw new IllegalStateException("Please use StorageAwareResource#load(ResourceStorageLoadable).");
        }
        try (ZipInputStream zin = new ZipInputStream(this.in);){
            this.loadEntries(resource, zin);
        }
    }

    protected void loadEntries(StorageAwareResource resource, ZipInputStream zipIn) throws IOException {
        zipIn.getNextEntry();
        BufferedInputStream _bufferedInputStream = new BufferedInputStream(zipIn);
        this.readContents(resource, _bufferedInputStream);
        zipIn.getNextEntry();
        BufferedInputStream _bufferedInputStream_1 = new BufferedInputStream(zipIn);
        this.readResourceDescription(resource, _bufferedInputStream_1);
        if (this.storeNodeModel) {
            zipIn.getNextEntry();
            BufferedInputStream _bufferedInputStream_2 = new BufferedInputStream(zipIn);
            this.readNodeModel(resource, _bufferedInputStream_2);
        }
    }

    protected void readContents(StorageAwareResource resource, InputStream inputStream) throws IOException {
        Map _emptyMap = CollectionLiterals.emptyMap();
        BinaryResourceImpl.EObjectInputStream in = new BinaryResourceImpl.EObjectInputStream(inputStream, _emptyMap){

            public int readCompressedInt() throws IOException {
                int _xblockexpression = 0;
                this.resourceSet = null;
                _xblockexpression = super.readCompressedInt();
                return _xblockexpression;
            }

            public InternalEObject loadEObject() throws IOException {
                InternalEObject result = super.loadEObject();
                ResourceStorageLoadable.this.handleLoadEObject(result, this);
                return result;
            }
        };
        in.loadResource((Resource)resource);
    }

    protected Object handleLoadEObject(InternalEObject loaded, BinaryResourceImpl.EObjectInputStream input) throws IOException {
        return null;
    }

    protected void readResourceDescription(StorageAwareResource resource, InputStream inputStream) throws IOException {
        try {
            ObjectInputStream objectIn = new ObjectInputStream(inputStream);
            Object _readObject = objectIn.readObject();
            SerializableResourceDescription description = (SerializableResourceDescription)_readObject;
            description.updateResourceURI(resource.getURI());
            resource.setResourceDescription(description);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void readNodeModel(StorageAwareResource resource, InputStream inputStream) throws IOException {
        boolean _not;
        SerializableNodeModel serializableNodeModel = new SerializableNodeModel(resource);
        boolean _exists = resource.getResourceSet().getURIConverter().exists(resource.getURI(), resource.getResourceSet().getLoadOptions());
        boolean bl = _not = !_exists;
        if (_not) {
            URI _uRI = resource.getURI();
            String _plus = "Skipping loading node model for synthetic resource " + _uRI;
            LOG.info((Object)_plus);
            return;
        }
        InputStream stream = resource.getResourceSet().getURIConverter().createInputStream(resource.getURI());
        String _encoding = resource.getEncoding();
        InputStreamReader in = new InputStreamReader(stream, _encoding);
        String completeContent = CharStreams.toString((Readable)in);
        DeserializationConversionContext deserializationContext = new DeserializationConversionContext(resource, completeContent);
        DataInputStream dataIn = new DataInputStream(inputStream);
        serializableNodeModel.readObjectData(dataIn, deserializationContext);
        EObject _head = (EObject)IterableExtensions.head((Iterable)resource.getContents());
        boolean _hasErrors = deserializationContext.hasErrors();
        ParseResult _parseResult = new ParseResult(_head, serializableNodeModel.root, _hasErrors);
        resource.setParseResult(_parseResult);
    }

    public ResourceStorageLoadable(InputStream in, boolean storeNodeModel) {
        this.in = in;
        this.storeNodeModel = storeNodeModel;
    }
}

