/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.internal.framework.FilterImpl;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.util.Tokenizer;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public final class OSGiManifestBuilderFactory {
    private static final String ATTR_TYPE_STRING = "string";
    private static final String ATTR_TYPE_VERSION = "version";
    private static final String ATTR_TYPE_URI = "uri";
    private static final String ATTR_TYPE_LONG = "long";
    private static final String ATTR_TYPE_DOUBLE = "double";
    private static final String ATTR_TYPE_SET = "set";
    private static final String ATTR_TYPE_LIST = "List";
    private static final String ATTR_OLD_REPRIVIDE = "reprovide";
    private static final String HEADER_OLD_PROVIDE_PACKAGE = "Provide-Package";
    private static final String[] DEFINED_OSGI_VALIDATE_HEADERS = new String[]{"Import-Package", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Bundle-SymbolicName", "Require-Bundle"};
    private static final Collection<String> SYSTEM_CAPABILITIES = Collections.unmodifiableCollection(Arrays.asList("osgi.ee", "osgi.native"));
    private static final Collection<String> PROHIBITED_CAPABILITIES = Collections.unmodifiableCollection(Arrays.asList("osgi.identity"));

    public static ModuleRevisionBuilder createBuilder(Map<String, String> manifest) throws BundleException {
        return OSGiManifestBuilderFactory.createBuilder(manifest, null, null, null);
    }

    public static ModuleRevisionBuilder createBuilder(Map<String, String> manifest, String symbolicNameAlias, String extraExports, String extraCapabilities) throws BundleException {
        ModuleRevisionBuilder builder = new ModuleRevisionBuilder();
        int manifestVersion = OSGiManifestBuilderFactory.getManifestVersion(manifest);
        if (manifestVersion >= 2) {
            OSGiManifestBuilderFactory.validateHeaders(manifest);
        }
        Object symbolicName = OSGiManifestBuilderFactory.getSymbolicNameAndVersion(builder, manifest, symbolicNameAlias, manifestVersion);
        ArrayList<Map<String, Object>> exportedPackages = new ArrayList<Map<String, Object>>();
        OSGiManifestBuilderFactory.getPackageExports(builder, ManifestElement.parseHeader("Export-Package", manifest.get("Export-Package")), symbolicName, exportedPackages);
        OSGiManifestBuilderFactory.getPackageExports(builder, ManifestElement.parseHeader(HEADER_OLD_PROVIDE_PACKAGE, manifest.get(HEADER_OLD_PROVIDE_PACKAGE)), symbolicName, exportedPackages);
        if (extraExports != null && !extraExports.isEmpty()) {
            OSGiManifestBuilderFactory.getPackageExports(builder, ManifestElement.parseHeader("Export-Package", extraExports), symbolicName, exportedPackages);
        }
        OSGiManifestBuilderFactory.getPackageImports(builder, manifest, exportedPackages, manifestVersion);
        OSGiManifestBuilderFactory.getRequireBundle(builder, ManifestElement.parseHeader("Require-Bundle", manifest.get("Require-Bundle")));
        OSGiManifestBuilderFactory.getProvideCapabilities(builder, ManifestElement.parseHeader("Provide-Capability", manifest.get("Provide-Capability")), extraCapabilities == null);
        if (extraCapabilities != null && !extraCapabilities.isEmpty()) {
            OSGiManifestBuilderFactory.getProvideCapabilities(builder, ManifestElement.parseHeader("Provide-Capability", extraCapabilities), false);
        }
        OSGiManifestBuilderFactory.getRequireCapabilities(builder, ManifestElement.parseHeader("Require-Capability", manifest.get("Require-Capability")));
        OSGiManifestBuilderFactory.addRequireEclipsePlatform(builder, manifest);
        OSGiManifestBuilderFactory.getEquinoxDataCapability(builder, manifest);
        OSGiManifestBuilderFactory.getFragmentHost(builder, ManifestElement.parseHeader("Fragment-Host", manifest.get("Fragment-Host")));
        OSGiManifestBuilderFactory.convertBREEs(builder, manifest);
        OSGiManifestBuilderFactory.getNativeCode(builder, manifest);
        return builder;
    }

    private static void validateHeaders(Map<String, String> manifest) throws BundleException {
        String[] stringArray = DEFINED_OSGI_VALIDATE_HEADERS;
        int n = DEFINED_OSGI_VALIDATE_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            String definedOSGiValidateHeader = stringArray[n2];
            String header = manifest.get(definedOSGiValidateHeader);
            if (header != null) {
                ManifestElement[] elements = ManifestElement.parseHeader(definedOSGiValidateHeader, header);
                OSGiManifestBuilderFactory.checkForDuplicateDirectivesAttributes(definedOSGiValidateHeader, elements);
                if (definedOSGiValidateHeader == "Import-Package") {
                    OSGiManifestBuilderFactory.checkImportExportSyntax(definedOSGiValidateHeader, elements, false, false);
                }
                if (definedOSGiValidateHeader == "DynamicImport-Package") {
                    OSGiManifestBuilderFactory.checkImportExportSyntax(definedOSGiValidateHeader, elements, false, true);
                }
                if (definedOSGiValidateHeader == "Export-Package") {
                    OSGiManifestBuilderFactory.checkImportExportSyntax(definedOSGiValidateHeader, elements, true, false);
                }
                if (definedOSGiValidateHeader == "Fragment-Host") {
                    OSGiManifestBuilderFactory.checkExtensionBundle(definedOSGiValidateHeader, elements, manifest);
                }
            } else if (definedOSGiValidateHeader == "Bundle-SymbolicName") {
                throw new BundleException("Bundle-SymbolicName header is required.", 3);
            }
            ++n2;
        }
    }

    private static void checkImportExportSyntax(String headerKey, ManifestElement[] elements, boolean export, boolean dynamic) throws BundleException {
        if (elements == null) {
            return;
        }
        int length = elements.length;
        HashSet<String> packages = new HashSet<String>(length);
        int i = 0;
        while (i < length) {
            String specVersion;
            String[] packageNames;
            String[] stringArray = packageNames = elements[i].getValueComponents();
            int n = packageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                if (!export && !dynamic && packages.contains(packageName)) {
                    String message = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, headerKey, elements[i].toString());
                    throw new BundleException(String.valueOf(message) + " : " + NLS.bind(Msg.HEADER_PACKAGE_DUPLICATES, packageName), 3);
                }
                if (export && packageName.startsWith("java.")) {
                    String message = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, headerKey, elements[i].toString());
                    throw new BundleException(String.valueOf(message) + " : " + NLS.bind(Msg.HEADER_PACKAGE_JAVA, packageName), 3);
                }
                packages.add(packageName);
                ++n2;
            }
            String version = elements[i].getAttribute(ATTR_TYPE_VERSION);
            if (version != null && (specVersion = elements[i].getAttribute("specification-version")) != null && !specVersion.equals(version)) {
                throw new BundleException(NLS.bind(Msg.HEADER_VERSION_ERROR, ATTR_TYPE_VERSION, "specification-version"), 3);
            }
            if (export) {
                if (elements[i].getAttribute("bundle-symbolic-name") != null) {
                    String message = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, headerKey, elements[i].toString());
                    throw new BundleException(String.valueOf(message) + " : " + NLS.bind(Msg.HEADER_EXPORT_ATTR_ERROR, "bundle-symbolic-name", "Export-Package"), 3);
                }
                if (elements[i].getAttribute("bundle-version") != null) {
                    String message = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, headerKey, elements[i].toString());
                    throw new BundleException(NLS.bind(String.valueOf(message) + " : " + Msg.HEADER_EXPORT_ATTR_ERROR, "bundle-version", "Export-Package"), 3);
                }
            }
            ++i;
        }
    }

    private static void checkForDuplicateDirectivesAttributes(String headerKey, ManifestElement[] elements) throws BundleException {
        ManifestElement[] manifestElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Enumeration<String> attrKeys;
            ManifestElement element = manifestElementArray[n2];
            Enumeration<String> directiveKeys = element.getDirectiveKeys();
            if (directiveKeys != null) {
                while (directiveKeys.hasMoreElements()) {
                    String key = directiveKeys.nextElement();
                    String[] directives = element.getDirectives(key);
                    if (directives.length <= 1) continue;
                    String message = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, headerKey, element.toString());
                    throw new BundleException(NLS.bind(String.valueOf(message) + " : " + Msg.HEADER_DIRECTIVE_DUPLICATES, key), 3);
                }
            }
            if ((attrKeys = element.getKeys()) != null) {
                while (attrKeys.hasMoreElements()) {
                    String key = attrKeys.nextElement();
                    String[] attrs = element.getAttributes(key);
                    if (attrs.length <= 1) continue;
                    String message = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, headerKey, element.toString());
                    throw new BundleException(String.valueOf(message) + " : " + NLS.bind(Msg.HEADER_ATTRIBUTE_DUPLICATES, key), 3);
                }
            }
            ++n2;
        }
    }

    private static void checkExtensionBundle(String headerKey, ManifestElement[] elements, Map<String, String> manifest) throws BundleException {
        if (elements.length == 0) {
            return;
        }
        String hostName = elements[0].getValue();
        if (!hostName.equals("system.bundle") && !hostName.equals("org.eclipse.osgi")) {
            if (elements[0].getDirective("extension") != null) {
                String message = NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, headerKey, elements[0].toString());
                throw new BundleException(String.valueOf(message) + " : " + NLS.bind(Msg.HEADER_EXTENSION_ERROR, hostName), 3);
            }
        } else {
            if (manifest.get("Require-Bundle") != null) {
                throw new BundleException(Msg.OSGiManifestBuilderFactory_ExtensionReqBundleError, 3);
            }
            if (manifest.get("Bundle-NativeCode") != null) {
                throw new BundleException(Msg.OSGiManifestBuilderFactory_ExtensionNativeError, 3);
            }
        }
    }

    private static int getManifestVersion(Map<String, String> manifest) {
        String manifestVersionHeader = manifest.get("Bundle-ManifestVersion");
        return manifestVersionHeader == null ? 1 : Integer.parseInt(manifestVersionHeader);
    }

    private static Object getSymbolicNameAndVersion(ModuleRevisionBuilder builder, Map<String, String> manifest, String symbolicNameAlias, int manifestVersion) throws BundleException {
        ManifestElement[] symbolicNameElements;
        boolean isFragment;
        block8: {
            isFragment = manifest.get("Fragment-Host") != null;
            builder.setTypes(isFragment ? 1 : 0);
            String version = manifest.get("Bundle-Version");
            try {
                builder.setVersion(version != null ? Version.parseVersion(version) : Version.emptyVersion);
            }
            catch (IllegalArgumentException ex) {
                if (manifestVersion < 2) break block8;
                String message = NLS.bind(Msg.OSGiManifestBuilderFactory_InvalidManifestError, "Bundle-Version", version);
                throw new BundleException(message, 3, ex);
            }
        }
        Object symbolicName = null;
        String symbolicNameHeader = manifest.get("Bundle-SymbolicName");
        if (symbolicNameHeader != null && (symbolicNameElements = ManifestElement.parseHeader("Bundle-SymbolicName", symbolicNameHeader)).length > 0) {
            Object singletonAttr;
            ManifestElement bsnElement = symbolicNameElements[0];
            builder.setSymbolicName(bsnElement.getValue());
            if (symbolicNameAlias != null) {
                ArrayList<String> result = new ArrayList<String>();
                result.add(builder.getSymbolicName());
                result.add(symbolicNameAlias);
                symbolicName = result;
            } else {
                symbolicName = builder.getSymbolicName();
            }
            Map<String, String> directives = OSGiManifestBuilderFactory.getDirectives(bsnElement);
            directives.remove("uses");
            directives.remove("effective");
            Map<String, Object> attributes = OSGiManifestBuilderFactory.getAttributes(bsnElement);
            if (!directives.containsKey("singleton") && "true".equals(singletonAttr = attributes.get("singleton"))) {
                directives.put("singleton", (String)singletonAttr);
            }
            if (!isFragment) {
                HashMap<String, Object> bundleAttributes = new HashMap<String, Object>(attributes);
                bundleAttributes.put("osgi.wiring.bundle", symbolicName);
                bundleAttributes.put("bundle-version", builder.getVersion());
                builder.addCapability("osgi.wiring.bundle", directives, bundleAttributes);
                if (!"never".equals(directives.get("fragment-attachment"))) {
                    HashMap<String, Object> hostAttributes = new HashMap<String, Object>(attributes);
                    hostAttributes.put("osgi.wiring.host", symbolicName);
                    hostAttributes.put("bundle-version", builder.getVersion());
                    builder.addCapability("osgi.wiring.host", directives, hostAttributes);
                }
            }
            HashMap<String, Object> identityAttributes = new HashMap<String, Object>(attributes);
            identityAttributes.put("osgi.identity", builder.getSymbolicName());
            identityAttributes.put(ATTR_TYPE_VERSION, builder.getVersion());
            identityAttributes.put("type", isFragment ? "osgi.fragment" : "osgi.bundle");
            builder.addCapability("osgi.identity", directives, identityAttributes);
        }
        return symbolicName == null ? symbolicNameAlias : symbolicName;
    }

    private static void getPackageExports(ModuleRevisionBuilder builder, ManifestElement[] exportElements, Object symbolicName, Collection<Map<String, Object>> exportedPackages) throws BundleException {
        if (exportElements == null) {
            return;
        }
        ManifestElement[] manifestElementArray = exportElements;
        int n = exportElements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement exportElement = manifestElementArray[n2];
            String[] packageNames = exportElement.getValueComponents();
            Map<String, Object> attributes = OSGiManifestBuilderFactory.getAttributes(exportElement);
            Map<String, String> directives = OSGiManifestBuilderFactory.getDirectives(exportElement);
            directives.remove("effective");
            String versionAttr = (String)attributes.remove(ATTR_TYPE_VERSION);
            String specVersionAttr = (String)attributes.remove("specification-version");
            Version version = versionAttr == null ? (specVersionAttr == null ? Version.emptyVersion : Version.parseVersion(specVersionAttr)) : Version.parseVersion(versionAttr);
            attributes.put(ATTR_TYPE_VERSION, version);
            if (symbolicName != null) {
                attributes.put("bundle-symbolic-name", symbolicName);
            }
            attributes.put("bundle-version", builder.getVersion());
            String[] stringArray = packageNames;
            int n3 = packageNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String packageName = stringArray[n4];
                HashMap<String, Object> packageAttrs = new HashMap<String, Object>(attributes);
                packageAttrs.put("osgi.wiring.package", packageName);
                builder.addCapability("osgi.wiring.package", directives, packageAttrs);
                exportedPackages.add(packageAttrs);
                ++n4;
            }
            ++n2;
        }
    }

    private static void getPackageImports(ModuleRevisionBuilder builder, Map<String, String> manifest, Collection<Map<String, Object>> exportedPackages, int manifestVersion) throws BundleException {
        ArrayList<String> importPackageNames = new ArrayList<String>();
        ManifestElement[] importElements = ManifestElement.parseHeader("Import-Package", manifest.get("Import-Package"));
        ManifestElement[] dynamicImportElements = ManifestElement.parseHeader("DynamicImport-Package", manifest.get("DynamicImport-Package"));
        OSGiManifestBuilderFactory.addPackageImports(builder, importElements, importPackageNames, false);
        OSGiManifestBuilderFactory.addPackageImports(builder, dynamicImportElements, importPackageNames, true);
        if (manifestVersion < 2) {
            OSGiManifestBuilderFactory.addImplicitImports(builder, exportedPackages, importPackageNames);
        }
    }

    private static void addPackageImports(ModuleRevisionBuilder builder, ManifestElement[] importElements, Collection<String> importPackageNames, boolean dynamic) throws BundleException {
        if (importElements == null) {
            return;
        }
        ManifestElement[] manifestElementArray = importElements;
        int n = importElements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement importElement = manifestElementArray[n2];
            String[] packageNames = importElement.getValueComponents();
            Map<String, Object> attributes = OSGiManifestBuilderFactory.getAttributes(importElement);
            Map<String, String> directives = OSGiManifestBuilderFactory.getDirectives(importElement);
            directives.remove("effective");
            directives.remove("cardinality");
            if (dynamic) {
                directives.put("resolution", "dynamic");
            }
            String versionRangeAttr = (String)attributes.remove(ATTR_TYPE_VERSION);
            String specVersionRangeAttr = (String)attributes.remove("specification-version");
            VersionRange versionRange = versionRangeAttr == null ? (specVersionRangeAttr == null ? null : new VersionRange(specVersionRangeAttr)) : new VersionRange(versionRangeAttr);
            String bundleVersionRangeAttr = (String)attributes.remove("bundle-version");
            VersionRange bundleVersionRange = bundleVersionRangeAttr == null ? null : new VersionRange(bundleVersionRangeAttr);
            Object optionalAttr = attributes.remove("optional");
            String[] stringArray = packageNames;
            int n3 = packageNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String packageName = stringArray[n4];
                if (!dynamic) {
                    importPackageNames.add(packageName);
                }
                HashMap<String, String> packageDirectives = new HashMap<String, String>(directives);
                StringBuilder filter = new StringBuilder();
                filter.append('(').append("osgi.wiring.package").append('=').append(packageName).append(')');
                int size = filter.length();
                for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                    filter.append('(').append(attribute.getKey()).append('=').append(attribute.getValue()).append(')');
                }
                if (versionRange != null) {
                    filter.append(versionRange.toFilterString(ATTR_TYPE_VERSION));
                }
                if (bundleVersionRange != null) {
                    filter.append(bundleVersionRange.toFilterString("bundle-version"));
                }
                if (size != filter.length()) {
                    filter.insert(0, "(&").append(')');
                }
                packageDirectives.put("filter", filter.toString());
                if (dynamic && packageName.indexOf(42) >= 0) {
                    packageDirectives.put("cardinality", "multiple");
                }
                if ("true".equals(optionalAttr) && packageDirectives.get("resolution") == null) {
                    packageDirectives.put("resolution", "optional");
                }
                builder.addRequirement("osgi.wiring.package", packageDirectives, new HashMap<String, Object>(0));
                ++n4;
            }
            ++n2;
        }
    }

    private static void addImplicitImports(ModuleRevisionBuilder builder, Collection<Map<String, Object>> exportedPackages, Collection<String> importPackageNames) {
        for (Map<String, Object> exportAttributes : exportedPackages) {
            String packageName = (String)exportAttributes.get("osgi.wiring.package");
            if (importPackageNames.contains(packageName)) continue;
            importPackageNames.add(packageName);
            Version packageVersion = (Version)exportAttributes.get(ATTR_TYPE_VERSION);
            StringBuilder filter = new StringBuilder();
            filter.append("(&(").append("osgi.wiring.package").append('=').append(packageName).append(')');
            filter.append('(').append(ATTR_TYPE_VERSION).append(">=").append(packageVersion).append("))");
            HashMap<String, String> directives = new HashMap<String, String>(1);
            directives.put("filter", filter.toString());
            builder.addRequirement("osgi.wiring.package", directives, new HashMap<String, Object>(0));
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, String> getDirectives(ManifestElement element) {
        directives = new HashMap<String, String>();
        keys = element.getDirectiveKeys();
        if (keys != null) ** GOTO lbl8
        return directives;
lbl-1000:
        // 1 sources

        {
            key = keys.nextElement();
            directives.put(key, element.getDirective(key));
lbl8:
            // 2 sources

            ** while (keys.hasMoreElements())
        }
lbl9:
        // 1 sources

        return directives;
    }

    private static void getRequireBundle(ModuleRevisionBuilder builder, ManifestElement[] requireBundles) throws BundleException {
        if (requireBundles == null) {
            return;
        }
        ManifestElement[] manifestElementArray = requireBundles;
        int n = requireBundles.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement requireElement = manifestElementArray[n2];
            String[] bundleNames = requireElement.getValueComponents();
            Map<String, Object> attributes = OSGiManifestBuilderFactory.getAttributes(requireElement);
            Map<String, String> directives = OSGiManifestBuilderFactory.getDirectives(requireElement);
            directives.remove("cardinality");
            directives.remove("effective");
            String versionRangeAttr = (String)attributes.remove("bundle-version");
            VersionRange versionRange = versionRangeAttr == null ? null : new VersionRange(versionRangeAttr);
            Object optionalAttr = attributes.remove("optional");
            Object reprovideAttr = attributes.remove(ATTR_OLD_REPRIVIDE);
            String[] stringArray = bundleNames;
            int n3 = bundleNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String bundleName = stringArray[n4];
                if (!bundleName.equals(builder.getSymbolicName())) {
                    HashMap<String, String> bundleDirectives = new HashMap<String, String>(directives);
                    StringBuilder filter = new StringBuilder();
                    filter.append('(').append("osgi.wiring.bundle").append('=').append(bundleName).append(')');
                    int size = filter.length();
                    for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                        filter.append('(').append(attribute.getKey()).append('=').append(attribute.getValue()).append(')');
                    }
                    if (versionRange != null) {
                        filter.append(versionRange.toFilterString("bundle-version"));
                    }
                    if (size != filter.length()) {
                        filter.insert(0, "(&").append(')');
                    }
                    bundleDirectives.put("filter", filter.toString());
                    if ("true".equals(optionalAttr) && bundleDirectives.get("resolution") == null) {
                        bundleDirectives.put("resolution", "optional");
                    }
                    if ("true".equals(reprovideAttr) && bundleDirectives.get("visibility") == null) {
                        bundleDirectives.put("visibility", "reexport");
                    }
                    builder.addRequirement("osgi.wiring.bundle", bundleDirectives, new HashMap<String, Object>(0));
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void getFragmentHost(ModuleRevisionBuilder builder, ManifestElement[] fragmentHosts) throws BundleException {
        if (fragmentHosts == null || fragmentHosts.length == 0) {
            return;
        }
        ManifestElement fragmentHost = fragmentHosts[0];
        String hostName = fragmentHost.getValue();
        Map<String, Object> attributes = OSGiManifestBuilderFactory.getAttributes(fragmentHost);
        Map<String, String> directives = OSGiManifestBuilderFactory.getDirectives(fragmentHost);
        directives.remove("cardinality");
        directives.remove("effective");
        String versionRangeAttr = (String)attributes.remove("bundle-version");
        VersionRange versionRange = versionRangeAttr == null ? null : new VersionRange(versionRangeAttr);
        StringBuilder filter = new StringBuilder();
        filter.append('(').append("osgi.wiring.host").append('=').append(hostName).append(')');
        int size = filter.length();
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            filter.append('(').append(attribute.getKey()).append('=').append(attribute.getValue()).append(')');
        }
        if (versionRange != null) {
            filter.append(versionRange.toFilterString("bundle-version"));
        }
        if (size != filter.length()) {
            filter.insert(0, "(&").append(')');
        }
        directives.put("filter", filter.toString());
        builder.addRequirement("osgi.wiring.host", directives, new HashMap<String, Object>(0));
        directives = Collections.singletonMap("effective", "information");
        builder.addCapability("equinox.fragment", directives, Collections.singletonMap("equinox.fragment", hostName));
    }

    private static void getProvideCapabilities(ModuleRevisionBuilder builder, ManifestElement[] provideElements, boolean checkSystemCapabilities) throws BundleException {
        if (provideElements == null) {
            return;
        }
        ManifestElement[] manifestElementArray = provideElements;
        int n = provideElements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement provideElement = manifestElementArray[n2];
            String[] namespaces = provideElement.getValueComponents();
            Map<String, Object> attributes = OSGiManifestBuilderFactory.getAttributes(provideElement);
            Map<String, String> directives = OSGiManifestBuilderFactory.getDirectives(provideElement);
            String[] stringArray = namespaces;
            int n3 = namespaces.length;
            int n4 = 0;
            while (n4 < n3) {
                String namespace = stringArray[n4];
                if (PROHIBITED_CAPABILITIES.contains(namespace) || checkSystemCapabilities && SYSTEM_CAPABILITIES.contains(namespace)) {
                    throw new BundleException("A bundle is not allowed to define a capability in the " + namespace + " name space.", 3);
                }
                builder.addCapability(namespace, directives, attributes);
                ++n4;
            }
            ++n2;
        }
    }

    private static void getRequireCapabilities(ModuleRevisionBuilder builder, ManifestElement[] requireElements) throws BundleException {
        if (requireElements == null) {
            return;
        }
        ManifestElement[] manifestElementArray = requireElements;
        int n = requireElements.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement requireElement = manifestElementArray[n2];
            String[] namespaces = requireElement.getValueComponents();
            Map<String, Object> attributes = OSGiManifestBuilderFactory.getAttributes(requireElement);
            Map<String, String> directives = OSGiManifestBuilderFactory.getDirectives(requireElement);
            String[] stringArray = namespaces;
            int n3 = namespaces.length;
            int n4 = 0;
            while (n4 < n3) {
                String namespace = stringArray[n4];
                builder.addRequirement(namespace, directives, attributes);
                ++n4;
            }
            ++n2;
        }
    }

    private static void addRequireEclipsePlatform(ModuleRevisionBuilder builder, Map<String, String> manifest) {
        String platformFilter = manifest.get("Eclipse-PlatformFilter");
        if (platformFilter == null) {
            return;
        }
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.put("filter", platformFilter);
        builder.addRequirement("eclipse.platform", directives, Collections.emptyMap());
    }

    private static void getEquinoxDataCapability(ModuleRevisionBuilder builder, Map<String, String> manifest) throws BundleException {
        ManifestElement[] registeredBuddies;
        ManifestElement[] buddyPolicies;
        int n;
        ManifestElement[] classpathElements;
        String activator;
        ManifestElement policy;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        ManifestElement[] policyElements = ManifestElement.parseHeader("Bundle-ActivationPolicy", manifest.get("Bundle-ActivationPolicy"));
        if (policyElements != null) {
            policy = policyElements[0];
            String policyName = policy.getValue();
            if ("lazy".equals(policyName)) {
                String excludeSpec;
                attributes.put("activation.policy", policyName);
                String includeSpec = policy.getDirective("include");
                if (includeSpec != null) {
                    attributes.put("lazy.include", OSGiManifestBuilderFactory.convertValueWithNoWhitespace("List<String>", includeSpec));
                }
                if ((excludeSpec = policy.getDirective("exclude")) != null) {
                    attributes.put("lazy.exclude", OSGiManifestBuilderFactory.convertValueWithNoWhitespace("List<String>", excludeSpec));
                }
            }
        } else {
            policyElements = ManifestElement.parseHeader("Eclipse-LazyStart", manifest.get("Eclipse-LazyStart"));
            if (policyElements == null) {
                policyElements = ManifestElement.parseHeader("Eclipse-AutoStart", manifest.get("Eclipse-AutoStart"));
            }
            if (policyElements != null) {
                policy = policyElements[0];
                String excludeSpec = policy.getAttribute("exceptions");
                if ("true".equals(policy.getValue())) {
                    attributes.put("activation.policy", "lazy");
                    if (excludeSpec != null) {
                        attributes.put("lazy.exclude", OSGiManifestBuilderFactory.convertValueWithNoWhitespace("List<String>", excludeSpec));
                    }
                } else if (excludeSpec != null) {
                    attributes.put("activation.policy", "lazy");
                    attributes.put("lazy.include", OSGiManifestBuilderFactory.convertValueWithNoWhitespace("List<String>", excludeSpec));
                }
            }
        }
        if ((activator = manifest.get("Bundle-Activator")) == null && manifest.get("Fragment-Host") != null) {
            activator = manifest.get("ExtensionBundle-Activator");
        }
        if (activator != null) {
            attributes.put("activator", activator);
        }
        if ((classpathElements = ManifestElement.parseHeader("Bundle-ClassPath", manifest.get("Bundle-ClassPath"))) != null) {
            ArrayList classpath = new ArrayList();
            ManifestElement[] manifestElementArray = classpathElements;
            n = classpathElements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                String[] components = element.getValueComponents();
                Collections.addAll(classpath, components);
                ++n2;
            }
            attributes.put("classpath", classpath);
        }
        if ((buddyPolicies = ManifestElement.parseHeader("Eclipse-BuddyPolicy", manifest.get("Eclipse-BuddyPolicy"))) != null) {
            ArrayList policies = new ArrayList();
            ManifestElement[] manifestElementArray = buddyPolicies;
            int n3 = buddyPolicies.length;
            n = 0;
            while (n < n3) {
                ManifestElement element = manifestElementArray[n];
                Collections.addAll(policies, element.getValueComponents());
                ++n;
            }
            attributes.put("buddy.policy", policies);
        }
        if ((registeredBuddies = ManifestElement.parseHeader("Eclipse-RegisterBuddy", manifest.get("Eclipse-RegisterBuddy"))) != null) {
            ArrayList buddies = new ArrayList();
            ManifestElement[] manifestElementArray = registeredBuddies;
            int n4 = registeredBuddies.length;
            int n5 = 0;
            while (n5 < n4) {
                ManifestElement element = manifestElementArray[n5];
                Collections.addAll(buddies, element.getValueComponents());
                ++n5;
            }
            attributes.put("buddy.registered", buddies);
        }
        if (!attributes.isEmpty()) {
            Map<String, String> directives = Collections.singletonMap("effective", "information");
            builder.addCapability("equinox.module.data", directives, attributes);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, Object> getAttributes(ManifestElement element) throws BundleException {
        keys = element.getKeys();
        attributes = new HashMap<String, Object>();
        if (keys != null) ** GOTO lbl14
        return attributes;
lbl-1000:
        // 1 sources

        {
            key = keys.nextElement();
            value = element.getAttribute(key);
            colonIndex = key.indexOf(58);
            type = "string";
            if (colonIndex > 0) {
                type = key.substring(colonIndex + 1).trim();
                key = key.substring(0, colonIndex).trim();
            }
            attributes.put(key, OSGiManifestBuilderFactory.convertValue(type, value));
lbl14:
            // 2 sources

            ** while (keys.hasMoreElements())
        }
lbl15:
        // 1 sources

        return attributes;
    }

    private static Object convertValueWithNoWhitespace(String type, String value) throws BundleException {
        value = value.replaceAll("\\s", "");
        return OSGiManifestBuilderFactory.convertValue(type, value);
    }

    private static Object convertValue(String type, String value) throws BundleException {
        if (ATTR_TYPE_STRING.equalsIgnoreCase(type)) {
            return value;
        }
        String trimmed = value.trim();
        if (ATTR_TYPE_DOUBLE.equalsIgnoreCase(type)) {
            return new Double(trimmed);
        }
        if (ATTR_TYPE_LONG.equalsIgnoreCase(type)) {
            return new Long(trimmed);
        }
        if (ATTR_TYPE_URI.equalsIgnoreCase(type)) {
            return trimmed;
        }
        if (ATTR_TYPE_VERSION.equalsIgnoreCase(type)) {
            return new Version(trimmed);
        }
        if (ATTR_TYPE_SET.equalsIgnoreCase(type)) {
            return Collections.unmodifiableList(Arrays.asList(ManifestElement.getArrayFromList(trimmed, ",")));
        }
        Tokenizer listTokenizer = new Tokenizer(type);
        String listType = listTokenizer.getToken("<");
        if (!ATTR_TYPE_LIST.equalsIgnoreCase(listType)) {
            throw new BundleException("Unsupported type: " + type, 3);
        }
        char c = listTokenizer.getChar();
        String componentType = ATTR_TYPE_STRING;
        if (c == '<') {
            componentType = listTokenizer.getToken(">");
            if (listTokenizer.getChar() != '>') {
                throw new BundleException("Invalid type, missing ending '>' : " + type, 3);
            }
        }
        List<String> tokens = new Tokenizer(value).getEscapedTokens(",");
        ArrayList<Object> components = new ArrayList<Object>();
        for (String component : tokens) {
            components.add(OSGiManifestBuilderFactory.convertValue(componentType, component));
        }
        return Collections.unmodifiableList(components);
    }

    private static void convertBREEs(ModuleRevisionBuilder builder, Map<String, String> manifest) throws BundleException {
        String filterSpec;
        String[] brees = ManifestElement.getArrayFromList(manifest.get("Bundle-RequiredExecutionEnvironment"));
        if (brees == null || brees.length == 0) {
            return;
        }
        ArrayList<String> breeFilters = new ArrayList<String>();
        String[] stringArray = brees;
        int n = brees.length;
        int n2 = 0;
        while (n2 < n) {
            String bree = stringArray[n2];
            breeFilters.add(OSGiManifestBuilderFactory.createOSGiEERequirementFilter(bree));
            ++n2;
        }
        if (breeFilters.size() == 1) {
            filterSpec = (String)breeFilters.get(0);
        } else {
            StringBuilder filterBuf = new StringBuilder("(|");
            for (String breeFilter : breeFilters) {
                filterBuf.append(breeFilter);
            }
            filterSpec = filterBuf.append(")").toString();
        }
        HashMap<String, String> directives = new HashMap<String, String>(1);
        directives.put("filter", filterSpec);
        builder.addRequirement("osgi.ee", directives, new HashMap<String, Object>(0));
    }

    static String escapeFilterInput(String value) {
        boolean escaped = false;
        int inlen = value.length();
        int outlen = inlen << 1;
        char[] output = new char[outlen];
        value.getChars(0, inlen, output, inlen);
        int cursor = 0;
        int i = inlen;
        while (i < outlen) {
            char c = output[i];
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    output[cursor] = 92;
                    ++cursor;
                    escaped = true;
                }
            }
            output[cursor] = c;
            ++cursor;
            ++i;
        }
        return escaped ? new String(output, 0, cursor) : value;
    }

    private static String createOSGiEERequirementFilter(String bree) throws BundleException {
        String[] nameVersion = OSGiManifestBuilderFactory.getOSGiEENameVersion(bree);
        String eeName = nameVersion[0];
        String v = nameVersion[1];
        String filterSpec = v == null ? "(osgi.ee=" + eeName + ")" : "(&(osgi.ee=" + eeName + ")(version=" + v + "))";
        try {
            FilterImpl.newInstance(filterSpec);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            filterSpec = "(osgi.ee=" + bree + ")";
            try {
                FilterImpl.newInstance(filterSpec);
            }
            catch (InvalidSyntaxException e1) {
                throw new BundleException("Error converting required execution environment.", 3, e1);
            }
        }
        return filterSpec;
    }

    private static String[] getOSGiEENameVersion(String bree) {
        int v2idx;
        String ee1 = null;
        String ee2 = null;
        String v1 = null;
        String v2 = null;
        int separator = bree.indexOf(47);
        if (separator <= 0 || separator == bree.length() - 1) {
            ee1 = bree;
        } else {
            ee1 = bree.substring(0, separator);
            ee2 = bree.substring(separator + 1);
        }
        int v1idx = ee1.indexOf(45);
        if (v1idx > 0 && v1idx < ee1.length() - 1) {
            try {
                v1 = ee1.substring(v1idx + 1);
                Version.parseVersion(v1);
                ee1 = ee1.substring(0, v1idx);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                v1 = null;
            }
        }
        int n = v2idx = ee2 == null ? -1 : ee2.indexOf(45);
        if (v2idx > 0 && v2idx < ee2.length() - 1) {
            try {
                v2 = ee2.substring(v2idx + 1);
                Version.parseVersion(v2);
                ee2 = ee2.substring(0, v2idx);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                v2 = null;
            }
        }
        if (v1 == null) {
            v1 = v2;
        }
        if (v1 != null && v2 != null && !v1.equals(v2)) {
            ee1 = bree;
            ee2 = null;
            v1 = null;
            v2 = null;
        }
        if ("J2SE".equals(ee1)) {
            ee1 = "JavaSE";
        }
        if ("J2SE".equals(ee2)) {
            ee2 = "JavaSE";
        }
        String eeName = String.valueOf(ee1) + (ee2 == null ? "" : String.valueOf('/') + ee2);
        return new String[]{OSGiManifestBuilderFactory.escapeFilterInput(eeName), v1};
    }

    private static void getNativeCode(ModuleRevisionBuilder builder, Map<String, String> manifest) throws BundleException {
        ManifestElement[] elements = ManifestElement.parseHeader("Bundle-NativeCode", manifest.get("Bundle-NativeCode"));
        if (elements == null) {
            return;
        }
        boolean optional = false;
        ArrayList<NativeClause> nativeClauses = new ArrayList<NativeClause>();
        int i = 0;
        while (i < elements.length) {
            if (i == elements.length - 1) {
                optional = elements[i].getValue().equals("*");
            }
            if (!optional) {
                nativeClauses.add(new NativeClause(i, elements[i]));
            }
            ++i;
        }
        Collections.sort(nativeClauses);
        int numNativePaths = nativeClauses.size();
        if (numNativePaths == 0) {
            String msg = "No native code clauses found in the value of Bundle-NativeCode: " + manifest.get("Bundle-NativeCode");
            throw new BundleException(msg, 3);
        }
        StringBuilder allNativeFilters = new StringBuilder();
        if (numNativePaths > 1) {
            allNativeFilters.append("(|");
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>(2);
        int i2 = 0;
        while (i2 < numNativePaths) {
            NativeClause nativeClause = (NativeClause)nativeClauses.get(i2);
            if (numNativePaths == 1) {
                attributes.put("native.paths", nativeClause.nativePaths);
            } else {
                attributes.put("native.paths." + i2, nativeClause.nativePaths);
            }
            allNativeFilters.append(((NativeClause)nativeClauses.get((int)i2)).filter);
            ++i2;
        }
        if (numNativePaths > 1) {
            allNativeFilters.append(')');
        }
        HashMap<String, String> directives = new HashMap<String, String>(2);
        directives.put("filter", allNativeFilters.toString());
        if (optional) {
            directives.put("resolution", "optional");
        }
        builder.addRequirement("osgi.native", directives, attributes);
    }

    static class NativeClause
    implements Comparable<NativeClause> {
        private final int manifestIndex;
        final List<String> nativePaths;
        final String filter;
        private final Version highestFloor;
        private final boolean hasLanguage;

        NativeClause(int manifestIndex, ManifestElement clause) throws BundleException {
            this.manifestIndex = manifestIndex;
            this.nativePaths = new ArrayList<String>(Arrays.asList(clause.getValueComponents()));
            StringBuilder sb = new StringBuilder();
            sb.append("(&");
            NativeClause.addToNativeCodeFilter(sb, clause, "osname");
            NativeClause.addToNativeCodeFilter(sb, clause, "processor");
            this.highestFloor = (Version)NativeClause.addToNativeCodeFilter(sb, clause, "osversion");
            this.hasLanguage = (Boolean)NativeClause.addToNativeCodeFilter(sb, clause, "language");
            String selectionFilter = clause.getAttribute("selection-filter");
            if (selectionFilter != null) {
                try {
                    FrameworkUtil.createFilter(selectionFilter);
                }
                catch (InvalidSyntaxException e) {
                    throw new BundleException("Bad native code selection-filter.", 3, e);
                }
                sb.append(selectionFilter);
            }
            sb.append(')');
            String filterResult = sb.toString();
            if (filterResult.equals("(&)")) {
                filterResult = "(osgi.native.osname=*)";
            }
            this.filter = filterResult;
        }

        private static Object addToNativeCodeFilter(StringBuilder filter, ManifestElement nativeCode, String attribute) {
            Boolean hasLanguage = Boolean.FALSE;
            Version highestFloor = null;
            String[] attrValues = nativeCode.getAttributes(attribute);
            if (attrValues != null) {
                String filterAttribute = attribute;
                if ("osname".equals(attribute)) {
                    filterAttribute = "osgi.native.osname";
                } else if ("processor".equals(attribute)) {
                    filterAttribute = "osgi.native.processor";
                } else if ("language".equals(attribute)) {
                    filterAttribute = "osgi.native.language";
                    hasLanguage = attrValues.length > 0;
                } else if ("osversion".equals(attribute)) {
                    filterAttribute = "osgi.native.osversion";
                }
                if (attrValues.length > 1) {
                    filter.append("(|");
                }
                String[] stringArray = attrValues;
                int n = attrValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String attrAlias = stringArray[n2];
                    if ("osgi.native.osversion".equals(filterAttribute)) {
                        VersionRange range = new VersionRange(attrAlias);
                        if (highestFloor == null || highestFloor.compareTo(range.getLeft()) < 0) {
                            highestFloor = range.getLeft();
                        }
                        filter.append(range.toFilterString(filterAttribute));
                    } else {
                        filter.append('(').append(filterAttribute).append("~=").append(OSGiManifestBuilderFactory.escapeFilterInput(attrAlias)).append(')');
                    }
                    ++n2;
                }
                if (attrValues.length > 1) {
                    filter.append(')');
                }
            }
            return "language".equals(attribute) ? hasLanguage : highestFloor;
        }

        @Override
        public int compareTo(NativeClause other) {
            if (this.highestFloor != null) {
                if (other == null) {
                    return -1;
                }
                if (other.highestFloor == null) {
                    return -1;
                }
                int compareVersions = this.highestFloor.compareTo(other.highestFloor);
                if (compareVersions != 0) {
                    return -compareVersions;
                }
            } else if (other.highestFloor != null) {
                return 1;
            }
            if (this.hasLanguage) {
                return other.hasLanguage ? this.manifestIndex - other.manifestIndex : 1;
            }
            return other.hasLanguage ? -1 : this.manifestIndex - other.manifestIndex;
        }
    }
}

