/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.ui.ValidationContext;
import org.eclipse.net4j.util.ui.ValidationParticipant;
import org.eclipse.net4j.util.ui.security.InteractiveCredentialsProvider;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class UIUtil {
    public static final String ERROR_LOG_ID = "org.eclipse.pde.runtime.LogView";

    private UIUtil() {
    }

    public static void copyToClipboard(Display display, String text) {
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(display);
            clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    public static void dispose(Font font) {
        if (font != null) {
            font.dispose();
        }
    }

    public static void dispose(Color color) {
        if (color != null) {
            color.dispose();
        }
    }

    public static void dispose(Widget widget) {
        if (widget != null) {
            widget.dispose();
        }
    }

    public static Font getItalicFont(Control control) {
        FontData[] datas = (FontData[])control.getFont().getFontData().clone();
        datas[0].setStyle(2);
        Display display = control.getShell().getDisplay();
        Font font = new Font((Device)display, datas);
        return font;
    }

    public static Font getBoldFont(Control control) {
        FontData[] datas = (FontData[])control.getFont().getFontData().clone();
        datas[0].setStyle(1);
        Display display = control.getShell().getDisplay();
        Font font = new Font((Device)display, datas);
        return font;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            try {
                display = PlatformUI.getWorkbench().getDisplay();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (display == null) {
            display = new Display();
        }
        return display;
    }

    public static Shell getShell() {
        final Shell[] shell = new Shell[1];
        final Display display = UIUtil.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell[] shells;
                shell[0] = display.getActiveShell();
                if (shell[0] == null) {
                    try {
                        IWorkbenchWindow[] windows;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length != 0) {
                            window = windows[0];
                        }
                        if (window != null) {
                            shell[0] = window.getShell();
                        }
                    }
                    catch (Throwable window) {
                        // empty catch block
                    }
                }
                if (shell[0] == null && (shells = display.getShells()).length > 0) {
                    shell[0] = shells[0];
                }
            }
        });
        return shell[0];
    }

    public static IWorkbench getWorkbench() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            throw new IllegalStateException("No workbench available");
        }
        return workbench;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow[] windows;
        IWorkbench workbench = UIUtil.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null && (windows = workbench.getWorkbenchWindows()).length != 0) {
            window = windows[0];
        }
        if (window == null) {
            throw new IllegalStateException("No active window available");
        }
        return window;
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchPage[] pages;
        IWorkbenchWindow window = UIUtil.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null && (pages = window.getPages()).length != 0) {
            page = pages[0];
        }
        if (page == null) {
            throw new IllegalStateException("No active page available");
        }
        return page;
    }

    public static IWorkbenchPart getActiveWorkbenchPart() {
        IWorkbenchPart part = UIUtil.getActiveWorkbenchPage().getActivePart();
        if (part == null) {
            throw new IllegalStateException("No active part available");
        }
        return part;
    }

    public static Object getElementIfOne(ISelection selection) {
        IStructuredSelection ssel;
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1) {
            return ssel.getFirstElement();
        }
        return null;
    }

    public static Object getElement(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            return ssel.getFirstElement();
        }
        return null;
    }

    public static <T> T getElement(ISelection selection, Class<T> type) {
        Object element = UIUtil.getElement(selection);
        if (element != null && type.isInstance(element)) {
            Object result = element;
            return (T)result;
        }
        return null;
    }

    public static List<Object> getElements(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            List result = ssel.toList();
            return result;
        }
        return null;
    }

    public static <T> List<T> getElements(ISelection selection, Class<T> type) {
        List<Object> elements = UIUtil.getElements(selection);
        if (elements != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object element : elements) {
                if (!type.isInstance(element)) continue;
                Object match = element;
                result.add(match);
            }
            return result;
        }
        return null;
    }

    public static <T> T adaptElement(ISelection selection, Class<T> type) {
        Object element = UIUtil.getElement(selection);
        return (T)AdapterUtil.adapt((Object)element, type);
    }

    public static <T> List<T> adaptElements(ISelection selection, Class<T> type) {
        List<Object> elements = UIUtil.getElements(selection);
        if (elements != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object element : elements) {
                Object match = AdapterUtil.adapt((Object)element, type);
                if (match == null) continue;
                result.add(match);
            }
            return result;
        }
        return null;
    }

    public static int setValidationContext(Control control, ValidationContext context) {
        ValidationParticipant participant;
        int count = 0;
        if (control instanceof ValidationParticipant && (participant = (ValidationParticipant)control).getValidationContext() == null) {
            participant.setValidationContext(context);
            ++count;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                count += UIUtil.setValidationContext(child, context);
                ++n2;
            }
        }
        return count;
    }

    public static IPasswordCredentialsProvider createInteractiveCredentialsProvider() {
        return new InteractiveCredentialsProvider();
    }

    public static Composite createGridComposite(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)UIUtil.createGridLayout(columns));
        return composite;
    }

    public static GridLayout createGridLayout(int columns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = columns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        return layout;
    }

    public static GridData createGridData() {
        return UIUtil.createGridData(true, true);
    }

    public static GridData createGridData(boolean grabHorizontal, boolean grabVertical) {
        return new GridData(4, 4, grabHorizontal, grabVertical);
    }

    public static GridData createGridData(int horizontalSpan, int verticalSpan) {
        GridData result = new GridData();
        result.horizontalSpan = horizontalSpan;
        result.verticalSpan = verticalSpan;
        return result;
    }

    public static GridData createEmptyGridData() {
        GridData data = new GridData();
        data.heightHint = 0;
        data.widthHint = 0;
        data.horizontalSpan = 0;
        data.horizontalAlignment = 0;
        data.horizontalIndent = 0;
        data.verticalAlignment = 0;
        data.verticalIndent = 0;
        data.verticalSpan = 0;
        data.minimumHeight = 0;
        data.minimumWidth = 0;
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        return data;
    }

    public static void addDecorationMargin(Control control) {
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            GridData gd = (GridData)data;
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            FieldDecoration dec = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
            gd.horizontalIndent = dec.getImage().getBounds().width;
        }
    }

    public static void setIndentation(Control control, int horizontalIndent, int verticalIndent) {
        if (control == null) {
            throw new IllegalArgumentException("control == null");
        }
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            GridData gd = (GridData)data;
            if (verticalIndent >= 0) {
                gd.verticalIndent = verticalIndent;
            }
            if (horizontalIndent >= 0) {
                gd.horizontalIndent = horizontalIndent;
            }
        }
    }

    public static void syncExec(Runnable runnable) {
        Display display = UIUtil.getDisplay();
        if (Display.getCurrent() == display || display == null) {
            runnable.run();
        } else {
            UIUtil.syncExec(display, runnable);
        }
    }

    public static void syncExec(final Display display, final Runnable runnable) {
        block3: {
            try {
                if (display.isDisposed()) {
                    return;
                }
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        block3: {
                            if (display.isDisposed()) {
                                return;
                            }
                            try {
                                runnable.run();
                            }
                            catch (SWTException ex) {
                                if (ex.code == 24) break block3;
                                throw ex;
                            }
                        }
                    }
                });
            }
            catch (SWTException ex) {
                if (ex.code == 24) break block3;
                throw ex;
            }
        }
    }

    public static void runWithProgress(final IRunnableWithProgress runnable) {
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ModalContext.run((IRunnableWithProgress)runnable, (boolean)true, (IProgressMonitor)monitor, (Display)PlatformUI.getWorkbench().getDisplay());
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(false, true, op);
        }
        catch (InvocationTargetException ex) {
            OM.LOG.error(ex.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void preserveViewerState(final Viewer viewer, final Runnable runnable) {
        try {
            viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISelection selection = viewer.getSelection();
                    try {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException runtimeException) {
                            viewer.setSelection(selection);
                        }
                    }
                    finally {
                        viewer.setSelection(selection);
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void refreshViewer(final Viewer viewer) {
        UIUtil.preserveViewerState(viewer, new Runnable(){

            @Override
            public void run() {
                viewer.refresh();
            }
        });
    }

    public static void refreshElement(final StructuredViewer viewer, final Object element, final boolean updateLabels) {
        UIUtil.preserveViewerState((Viewer)viewer, new Runnable(){

            @Override
            public void run() {
                try {
                    this.doRefresh(viewer, element, updateLabels);
                }
                catch (RuntimeException ex) {
                    this.doRefresh(viewer, null, updateLabels);
                }
            }

            private void doRefresh(StructuredViewer viewer2, Object element2, boolean updateLabels2) {
                if (element2 != null && element2 != viewer2.getInput()) {
                    viewer2.refresh(element2, updateLabels2);
                } else {
                    viewer2.refresh(updateLabels2);
                }
            }
        });
    }

    public static void updateElements(final StructuredViewer viewer, final Object element) {
        try {
            Control control = viewer.getControl();
            if (!control.isDisposed()) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (element instanceof Object[]) {
                                Object[] elements = (Object[])element;
                                viewer.update(elements, null);
                            } else {
                                viewer.update(element, null);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setStatusBarMessage(final String message, final Image image) {
        UIUtil.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IViewSite site = (IViewSite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                    if (image == null) {
                        site.getActionBars().getStatusLineManager().setMessage(message);
                    } else {
                        site.getActionBars().getStatusLineManager().setMessage(image, message);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        });
    }

    public static void addDragSupport(final StructuredViewer viewer) {
        viewer.addDragSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){
            private long lastDragTime;

            public void dragStart(DragSourceEvent event) {
                this.lastDragTime = System.currentTimeMillis();
                LocalSelectionTransfer.getTransfer().setSelection(viewer.getSelection());
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(this.lastDragTime);
            }

            public void dragFinished(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().getSelectionSetTime() == this.lastDragTime) {
                    LocalSelectionTransfer.getTransfer().setSelection(null);
                }
            }
        });
    }
}

