/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.internal.tasks.ui.ITaskListNotificationProvider;
import org.eclipse.mylyn.internal.tasks.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotificationPopup;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotifier;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TaskListNotificationManager
implements IPropertyChangeListener {
    private static final long DELAY_OPEN = 5000L;
    private static final boolean runSystem = true;
    private TaskListNotificationPopup popup;
    private final Set<AbstractUiNotification> notifications = new HashSet<AbstractUiNotification>();
    private final Set<AbstractUiNotification> currentlyNotifying = Collections.synchronizedSet(this.notifications);
    private final List<ITaskListNotificationProvider> notificationProviders = new ArrayList<ITaskListNotificationProvider>();
    private final WeakHashMap<Object, Object> cancelledTokens = new WeakHashMap();
    private final Job openJob = new Job(Messages.TaskListNotificationManager_Open_Notification_Job){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            TaskListNotificationManager.this.collectNotifications();
                            if (TaskListNotificationManager.this.popup != null && TaskListNotificationManager.this.popup.getReturnCode() == 1) {
                                List<AbstractUiNotification> notifications = TaskListNotificationManager.this.popup.getNotifications();
                                for (AbstractUiNotification notification : notifications) {
                                    if (notification.getToken() == null) continue;
                                    TaskListNotificationManager.this.cancelledTokens.put(notification.getToken(), null);
                                }
                            }
                            Iterator it = TaskListNotificationManager.this.currentlyNotifying.iterator();
                            while (it.hasNext()) {
                                AbstractUiNotification notification;
                                notification = (AbstractUiNotification)it.next();
                                if (notification.getToken() == null || !TaskListNotificationManager.this.cancelledTokens.containsKey(notification.getToken())) continue;
                                it.remove();
                            }
                            Class<TaskListNotificationManager> clazz = TaskListNotificationManager.class;
                            synchronized (TaskListNotificationManager.class) {
                                if (TaskListNotificationManager.this.currentlyNotifying.size() > 0) {
                                    TaskListNotificationManager.this.showPopup();
                                }
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                        }
                    });
                }
            }
            finally {
                if (TaskListNotificationManager.this.popup != null) {
                    this.schedule(TaskListNotificationManager.this.popup.getDelayClose() / 2L);
                } else {
                    this.schedule(5000L);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };

    public void showPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.popup = new TaskListNotificationPopup(shell);
        this.popup.setFadingEnabled(TasksUiInternal.isAnimationsEnabled());
        ArrayList<AbstractUiNotification> toDisplay = new ArrayList<AbstractUiNotification>(this.currentlyNotifying);
        Collections.sort(toDisplay);
        this.popup.setContents(toDisplay);
        this.cleanNotified();
        this.popup.setBlockOnOpen(false);
        this.popup.open();
    }

    private void cleanNotified() {
        this.currentlyNotifying.clear();
    }

    public void collectNotifications() {
        for (ITaskListNotificationProvider provider : this.notificationProviders) {
            this.currentlyNotifying.addAll(provider.getNotifications());
        }
    }

    public void startNotification(long initialStartupTime) {
        if (TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.notifications.enabled")) {
            if (!this.openJob.cancel()) {
                try {
                    this.openJob.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.openJob.setSystem(true);
            this.openJob.schedule(initialStartupTime);
            for (ITaskListNotificationProvider provider : this.notificationProviders) {
                if (!(provider instanceof TaskListNotifier)) continue;
                ((TaskListNotifier)provider).setEnabled(true);
            }
        }
    }

    public void stopNotification() {
        for (ITaskListNotificationProvider provider : this.notificationProviders) {
            if (!(provider instanceof TaskListNotifier)) continue;
            ((TaskListNotifier)provider).setEnabled(false);
        }
        this.openJob.cancel();
    }

    public void addNotificationProvider(ITaskListNotificationProvider notification_provider) {
        this.notificationProviders.add(notification_provider);
    }

    public void removeNotificationProvider(ITaskListNotificationProvider notification_provider) {
        this.notificationProviders.remove(notification_provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractUiNotification> getNotifications() {
        Class<TaskListNotificationManager> clazz = TaskListNotificationManager.class;
        synchronized (TaskListNotificationManager.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentlyNotifying;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.notifications.enabled")) {
            Object newValue = event.getNewValue();
            if (!(newValue instanceof Boolean)) {
                this.startNotification(0L);
            } else if (((Boolean)newValue).booleanValue()) {
                this.startNotification(0L);
            } else {
                this.stopNotification();
            }
        }
    }
}

