/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.ICSSInfo;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSSInfo
extends ProductObject
implements ICSSInfo {
    private static final long serialVersionUID = 1L;
    private String fFilePath;

    public CSSInfo(IProductModel model) {
        super(model);
    }

    @Override
    public void setFilePath(String text) {
        String old = this.fFilePath;
        this.fFilePath = text;
        if (this.isEditable()) {
            this.firePropertyChanged("cssfilepath", old, this.fFilePath);
        }
    }

    @Override
    public String getFilePath() {
        return this.fFilePath;
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "<cssInfo>");
        if (this.fFilePath != null && this.fFilePath.length() > 0) {
            writer.println(String.valueOf(indent) + "   <file path=\"" + this.getWritableString(this.fFilePath.trim()) + "\"/>");
        }
        writer.println(String.valueOf(indent) + "</cssInfo>");
    }

    @Override
    public void parse(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("file")) {
                this.fFilePath = ((Element)child).getAttribute("path");
            }
            ++i;
        }
    }
}

