/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.dialogs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.core.modelsetquery.ModelSetQuery;
import org.eclipse.papyrus.infra.ui.util.EditorUtils;
import org.eclipse.papyrus.uml.diagram.activity.part.CustomMessages;
import org.eclipse.papyrus.uml.diagram.activity.part.Messages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.actions.LabelHelper;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateAttributeDialog
extends FormDialog {
    private Text creationNameText;
    private Text creationTypeText;
    private Button creationTypeButton;
    private Property createdProperty = null;
    private EObject selectedType = null;
    private NamedElement attributeOwner;
    private String selectedName = null;
    private EClass selectedEClass = null;
    private ComboViewer eClassComboViewer = null;
    private Combo creationEClassCombo = null;
    private ILabelProvider labelProvider;

    public CreateAttributeDialog(Shell shell, NamedElement owner) {
        super(shell);
        this.attributeOwner = owner;
        this.labelProvider = this.getCustomLabelProvider();
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText(this.getTitle());
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createAttributeSection(scrolledForm.getBody(), toolkit);
        this.hookListeners();
        this.setInvokedName(null);
        scrolledForm.reflow(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refreshOkButton();
    }

    protected void createAttributeSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = this.getCreationTitle();
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        pToolkit.createLabel(lBody, this.getEClassLabel(), 0);
        this.creationEClassCombo = new Combo(lBody, 12);
        this.eClassComboViewer = new ComboViewer(this.creationEClassCombo);
        pToolkit.adapt((Composite)this.creationEClassCombo);
        this.creationEClassCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.eClassComboViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.eClassComboViewer.add((Object[])this.getPossibleAttributes());
        if (this.getPossibleAttributes().length > 1) {
            this.eClassComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.getPossibleAttributes()[0]));
            this.selectedEClass = this.getPossibleAttributes()[0];
        }
        pToolkit.createLabel(lBody, this.getNameLabel(), 0);
        this.creationNameText = pToolkit.createText(lBody, "", 2048);
        this.creationNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.creationNameText.setFocus();
        pToolkit.createLabel(lBody, this.getTypeLabel(), 0);
        this.creationTypeText = pToolkit.createText(lBody, this.labelProvider.getText((Object)this.selectedType), 2056);
        this.creationTypeText.setLayoutData((Object)new GridData(768));
        this.creationTypeButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = this.getTypeImage();
        this.creationTypeButton.setImage(image);
        this.creationTypeButton.setLayoutData((Object)new GridData(0));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        this.createdProperty = (Property)UMLFactory.eINSTANCE.create(this.selectedEClass);
        this.createdProperty.setName(this.selectedName);
        this.createdProperty.setType((Type)this.selectedType);
        this.addAttribute(this.createdProperty);
        super.okPressed();
    }

    public Property getCreatedAttribute() {
        return this.createdProperty;
    }

    private void hookListeners() {
        if (this.creationEClassCombo != null && this.eClassComboViewer != null) {
            ModifyListener lTypeListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ISelection sel = CreateAttributeDialog.this.eClassComboViewer.getSelection();
                    if (sel instanceof StructuredSelection) {
                        Object type = ((StructuredSelection)sel).getFirstElement();
                        if (type instanceof EClass) {
                            CreateAttributeDialog.this.selectedEClass = (EClass)type;
                        } else {
                            CreateAttributeDialog.this.selectedEClass = null;
                        }
                        CreateAttributeDialog.this.setInvokedName(null);
                        CreateAttributeDialog.this.refreshOkButton();
                    }
                }
            };
            this.creationEClassCombo.addModifyListener(lTypeListener);
        }
        ModifyListener lNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateAttributeDialog.this.setInvokedName(CreateAttributeDialog.this.creationNameText.getText());
            }
        };
        this.creationNameText.addModifyListener(lNameListener);
        SelectionAdapter selectParentBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateAttributeDialog.this.handleChooseType();
                if (CreateAttributeDialog.this.selectedName == null) {
                    CreateAttributeDialog.this.setInvokedName(null);
                }
                CreateAttributeDialog.this.refreshOkButton();
            }
        };
        this.creationTypeButton.addSelectionListener((SelectionListener)selectParentBtnListener);
    }

    private void setInvokedName(String text) {
        String name = text;
        if (text == null && this.selectedEClass != null) {
            name = LabelHelper.INSTANCE.findName((EObject)this.attributeOwner, this.selectedEClass);
            this.creationNameText.setText(name);
        } else if (name != null && !"".equals(name.trim())) {
            this.selectedName = name.trim();
            Color black = this.creationNameText.getDisplay().getSystemColor(2);
            this.creationNameText.setForeground(black);
            this.refreshOkButton();
        } else {
            this.selectedName = null;
            Color red = this.creationNameText.getDisplay().getSystemColor(3);
            this.creationNameText.setForeground(red);
            this.refreshOkButton();
        }
    }

    private void handleChooseType() {
        Set<Object> types = this.getPossibleTypes();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), this.labelProvider);
        dialog.setMessage(Messages.UMLModelingAssistantProviderMessage);
        dialog.setTitle(Messages.UMLModelingAssistantProviderTitle);
        dialog.setMultipleSelection(false);
        dialog.setElements(types.toArray());
        if (dialog.open() == 0) {
            Object firstResult = dialog.getFirstResult();
            if (firstResult instanceof EObject) {
                this.setType((EObject)dialog.getFirstResult());
            } else {
                this.setType(null);
            }
        }
    }

    private void setType(EObject type) {
        this.selectedType = type;
        if (this.selectedType instanceof NamedElement) {
            this.creationTypeText.setText(this.labelProvider.getText((Object)this.selectedType));
        } else {
            this.creationTypeText.setText("");
        }
    }

    private void refreshOkButton() {
        if (this.getButton(0) != null && !this.getButton(0).isDisposed()) {
            this.getButton(0).setEnabled(this.selectedEClass != null && this.selectedName != null);
        }
    }

    protected void addAttribute(Property createdAttribute) {
        TransactionalEditingDomain editingdomain = EditorUtils.getTransactionalEditingDomain();
        Command addCmd = AddCommand.create((EditingDomain)editingdomain, (Object)this.attributeOwner, null, Collections.singleton(createdAttribute));
        addCmd.execute();
    }

    private Set<Object> getPossibleTypes() {
        Collection types = ModelSetQuery.getObjectsOfType((EObject)this.attributeOwner, (EClassifier)UMLPackage.eINSTANCE.getTypedElement_Type().getEType());
        HashSet<Object> result = new HashSet<Object>();
        result.add("");
        result.addAll(types);
        return result;
    }

    private ILabelProvider getCustomLabelProvider() {
        AdapterFactoryLabelProvider adapterFactory = new AdapterFactoryLabelProvider(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()){

            public String getText(Object object) {
                String text = super.getText(object);
                if (object instanceof EClass) {
                    return text.substring(0, text.indexOf("[") - 1);
                }
                return text;
            }
        };
        return adapterFactory;
    }

    protected EClass[] getPossibleAttributes() {
        return new EClass[]{UMLPackage.eINSTANCE.getProperty(), UMLPackage.eINSTANCE.getExtensionEnd(), UMLPackage.eINSTANCE.getPort()};
    }

    private Image getTypeImage() {
        return UMLElementTypes.getImage((ENamedElement)UMLPackage.eINSTANCE.getPackage_PackagedElement());
    }

    private String getTitle() {
        return CustomMessages.CreateAttributeDialog_DialogTitle;
    }

    private String getCreationTitle() {
        return CustomMessages.CreateAttributeDialog_CreationTitle;
    }

    private String getNameLabel() {
        return CustomMessages.CreateAttributeDialog_NameLabel;
    }

    private String getEClassLabel() {
        return CustomMessages.CreateAttributeDialog_EClassLabel;
    }

    private String getTypeLabel() {
        return CustomMessages.CreateAttributeDialog_TypeLabel;
    }
}

