/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.CommentEditPartCN;

public class CompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Object getConstraintFor(Request request, GraphicalEditPart child, Rectangle rect) {
        if (this.isReflowable(child) && request instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest reqImpl = (ChangeBoundsRequest)request;
            Dimension sizeDelta = reqImpl.getSizeDelta();
            if (sizeDelta.width != 0 || sizeDelta.height != 0) {
                Dimension correctedMinSize = this.getMinimumSizeForHint(child, rect.getSize());
                rect.setSize(Dimension.max((Dimension)correctedMinSize, (Dimension)rect.getSize()));
            }
        }
        return super.getConstraintFor(request, child, rect);
    }

    protected Dimension getMinimumSizeForHint(GraphicalEditPart child, Dimension hint) {
        IFigure figure = child.getFigure();
        if (figure == null) {
            return super.getMinimumSizeFor(child);
        }
        return figure.getMinimumSize(hint.width, -1);
    }

    protected boolean isReflowable(GraphicalEditPart editPart) {
        return editPart instanceof CommentEditPartCN;
    }

    protected Dimension getMinimumSizeFor(GraphicalEditPart child) {
        if (this.isReflowable(child)) {
            return new Dimension(5, 5);
        }
        if (child.getFigure() != null) {
            return child.getFigure().getMinimumSize();
        }
        return super.getMinimumSizeFor(child);
    }
}

