/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.cairo.cairo_rectangle_int_t;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;
    boolean blink;
    boolean drawFlag;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, Canvas.checkStyle(style));
    }

    public void drawBackground(GC gc, int x, int y, int width, int height) {
        this.drawBackground(gc, x, y, width, height, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    @Override
    Point getIMCaretPos() {
        if (this.caret == null) {
            return super.getIMCaretPos();
        }
        return new Point(this.caret.x, this.caret.y);
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_button_press_event(widget, event)) != 0L) {
            return result;
        }
        return super.gtk_button_press_event(widget, event);
    }

    @Override
    long gtk_commit(long imcontext, long text) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_commit(imcontext, text)) != 0L) {
            return result;
        }
        return super.gtk_commit(imcontext, text);
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        long result;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (GTK.GTK_VERSION < OS.VERSION(3, 22, 0)) {
            boolean isFocus;
            boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
            if (isFocus) {
                this.caret.killFocus();
            }
            result = super.gtk_draw(widget, cairo);
            if (isFocus) {
                this.caret.setFocus();
            }
        } else {
            result = super.gtk_draw(widget, cairo);
            if (this.caret != null && this.blink && this.caret.isFocusCaret()) {
                this.drawCaret(widget, cairo);
                this.blink = false;
            }
        }
        return result;
    }

    private void drawCaret(long widget, long cairo) {
        if (this.isDisposed()) {
            return;
        }
        if (cairo == 0L) {
            this.error(2);
        }
        if (this.drawFlag) {
            Cairo.cairo_save(cairo);
            if (this.caret.image != null && !this.caret.image.isDisposed() && this.caret.image.mask == 0L) {
                Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
                Cairo.cairo_set_operator(cairo, 23);
                long surface = Cairo.cairo_get_target(cairo);
                int nWidth = 0;
                switch (Cairo.cairo_surface_get_type(surface)) {
                    case 0: {
                        nWidth = Cairo.cairo_image_surface_get_width(surface);
                        break;
                    }
                    case 3: {
                        nWidth = Cairo.cairo_xlib_surface_get_width(surface);
                    }
                }
                int nX = this.caret.x;
                if ((this.style & 0x8000000) != 0) {
                    nX = this.getClientWidth() - nWidth - nX;
                }
                Cairo.cairo_translate(cairo, nX, this.caret.y);
                Cairo.cairo_set_source_surface(cairo, this.caret.image.surface, 0.0, 0.0);
                Cairo.cairo_paint(cairo);
            } else {
                Cairo.cairo_set_source_rgb(cairo, 1.0, 1.0, 1.0);
                Cairo.cairo_set_operator(cairo, 23);
                int nWidth = this.caret.width;
                int nHeight = this.caret.height;
                if (nWidth <= 0) {
                    nWidth = 1;
                }
                int nX = this.caret.x;
                if ((this.style & 0x8000000) != 0) {
                    nX = this.getClientWidth() - nWidth - nX;
                }
                Cairo.cairo_rectangle(cairo, nX, this.caret.y, nWidth, nHeight);
            }
            Cairo.cairo_fill(cairo);
            Cairo.cairo_restore(cairo);
            this.drawFlag = false;
        } else {
            this.drawFlag = true;
        }
    }

    @Override
    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        long result = super.gtk_focus_out_event(widget, event);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }

    @Override
    long gtk_preedit_changed(long imcontext) {
        long result;
        if (this.ime != null && (result = this.ime.gtk_preedit_changed(imcontext)) != 0L) {
            return result;
        }
        return super.gtk_preedit_changed(imcontext);
    }

    @Override
    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean all, boolean trim) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(x, y, width, height, redrawAll, all, trim);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.caret != null) {
            this.caret.reskin(flags);
        }
        if (this.ime != null) {
            this.ime.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (GTK.GTK4) {
            return;
        }
        Point destination = DPIUtil.autoScaleUp(new Point(destX, destY));
        Rectangle srcRect = DPIUtil.autoScaleUp(new Rectangle(x, y, width, height));
        this.scrollInPixels(destination.x, destination.y, srcRect.x, srcRect.y, srcRect.width, srcRect.height, all);
    }

    void scrollInPixels(int destX, int destY, int x, int y, int width, int height, boolean all) {
        Control control;
        boolean isFocus;
        if ((this.style & 0x8000000) != 0) {
            int clientWidth = this.getClientWidth();
            x = clientWidth - width - x;
            destX = clientWidth - width - destX;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        long window = this.paintWindow();
        long visibleRegion = GDK.gdk_window_get_visible_region(window);
        cairo_rectangle_int_t srcRect = new cairo_rectangle_int_t();
        srcRect.x = x;
        srcRect.y = y;
        if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            long hBarHandle = 0L;
            long vBarHandle = 0L;
            if (GTK.GTK_IS_SCROLLED_WINDOW(this.scrolledHandle)) {
                hBarHandle = GTK.gtk_scrolled_window_get_hscrollbar(this.scrolledHandle);
                vBarHandle = GTK.gtk_scrolled_window_get_vscrollbar(this.scrolledHandle);
            }
            GtkRequisition requisition = new GtkRequisition();
            if (hBarHandle != 0L) {
                this.gtk_widget_get_preferred_size(hBarHandle, requisition);
                if (requisition.height > 0) {
                    srcRect.y = y - requisition.height;
                }
            }
            if (vBarHandle != 0L) {
                this.gtk_widget_get_preferred_size(vBarHandle, requisition);
                if (requisition.width > 0) {
                    srcRect.x = x - requisition.width;
                }
            }
        }
        srcRect.width = width;
        srcRect.height = height;
        long copyRegion = Cairo.cairo_region_create_rectangle(srcRect);
        Cairo.cairo_region_intersect(copyRegion, visibleRegion);
        long invalidateRegion = Cairo.cairo_region_create_rectangle(srcRect);
        Cairo.cairo_region_subtract(invalidateRegion, visibleRegion);
        Cairo.cairo_region_translate(invalidateRegion, deltaX, deltaY);
        cairo_rectangle_int_t copyRect = new cairo_rectangle_int_t();
        Cairo.cairo_region_get_extents(copyRegion, copyRect);
        if (copyRect.width != 0 && copyRect.height != 0) {
            this.update();
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(x, y, width, height, false, false, false);
            this.redrawWidget(destX, destY, width, height, false, false, false);
        } else {
            cairo_rectangle_int_t rect;
            boolean disjoint;
            long cairo = GDK.gdk_cairo_create(window);
            if (Cairo.cairo_version() < Cairo.CAIRO_VERSION_ENCODE(1, 12, 0)) {
                GDK.gdk_cairo_set_source_window(cairo, window, 0, 0);
            } else {
                Cairo.cairo_push_group(cairo);
                GDK.gdk_cairo_set_source_window(cairo, window, 0, 0);
                Cairo.cairo_paint(cairo);
                Cairo.cairo_pop_group_to_source(cairo);
            }
            double[] matrix = new double[]{1.0, 0.0, 0.0, 1.0, -deltaX, -deltaY};
            Cairo.cairo_pattern_set_matrix(Cairo.cairo_get_source(cairo), matrix);
            Cairo.cairo_rectangle(cairo, copyRect.x + deltaX, copyRect.y + deltaY, copyRect.width, copyRect.height);
            Cairo.cairo_clip(cairo);
            Cairo.cairo_paint(cairo);
            Cairo.cairo_destroy(cairo);
            boolean bl2 = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
            if (disjoint) {
                rect = new cairo_rectangle_int_t();
                rect.x = x;
                rect.y = y;
                rect.width = width;
                rect.height = height;
                Cairo.cairo_region_union_rectangle(invalidateRegion, rect);
            } else {
                rect = new cairo_rectangle_int_t();
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    rect.x = newX;
                    rect.y = y;
                    rect.width = Math.abs(deltaX);
                    rect.height = height;
                    Cairo.cairo_region_union_rectangle(invalidateRegion, rect);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    rect.x = x;
                    rect.y = newY;
                    rect.width = width;
                    rect.height = Math.abs(deltaY);
                    Cairo.cairo_region_union_rectangle(invalidateRegion, rect);
                }
            }
            GDK.gdk_window_invalidate_region(window, invalidateRegion, all);
        }
        Cairo.cairo_region_destroy(visibleRegion);
        Cairo.cairo_region_destroy(copyRegion);
        Cairo.cairo_region_destroy(invalidateRegion);
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect = child.getBoundsInPixels();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocationInPixels(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
        if (GTK.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            this.redraw(false);
        }
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.setBounds(x, y, width, height, move, resize);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    @Override
    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME ime) {
        this.checkWidget();
        if (ime != null && ime.isDisposed()) {
            this.error(5);
        }
        this.ime = ime;
    }

    void updateCaret() {
        long imHandle = this.imHandle();
        if (imHandle == 0L) {
            return;
        }
        GdkRectangle rect = new GdkRectangle();
        rect.x = this.caret.x;
        rect.y = this.caret.y;
        rect.width = this.caret.width;
        rect.height = this.caret.height;
        GTK.gtk_im_context_set_cursor_location(imHandle, rect);
    }
}

