/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buffer;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.IErrorHandler;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class BufferOutputStream
extends OutputStream {
    public static final boolean DEFAULT_PROPAGATE_CLOSE = false;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER_STREAM, BufferOutputStream.class);
    private final boolean tracerEnabled;
    private IBufferProvider bufferProvider;
    private IBufferHandler bufferHandler;
    private IBuffer currentBuffer;
    private short channelID;
    private Throwable error;
    @ReflectUtil.ExcludeFromDump
    private transient IErrorHandler errorHandler = new IErrorHandler(){

        public void handleError(Throwable t) {
            BufferOutputStream.this.setError(t);
        }
    };

    public BufferOutputStream(IBufferHandler bufferHandler, IBufferProvider bufferProvider, short channelID) {
        if (bufferHandler == null) {
            throw new IllegalArgumentException("bufferHandler == null");
        }
        if (bufferProvider == null) {
            throw new IllegalArgumentException("bufferProvider == null");
        }
        this.bufferHandler = bufferHandler;
        this.bufferProvider = bufferProvider;
        this.channelID = channelID;
        this.tracerEnabled = TRACER.isEnabled();
    }

    public BufferOutputStream(IBufferHandler bufferHandler, short channelID) {
        this(bufferHandler, BufferOutputStream.extractBufferProvider(bufferHandler), channelID);
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    @Override
    public void write(int b) throws IOException {
        this.throwExceptionOnError();
        this.flushIfFilled();
        this.ensureBufferPrivate();
        b &= 0xFF;
        if (this.tracerEnabled) {
            TRACER.trace("--> " + HexUtil.formatByte((int)b) + (b >= 32 ? " " + Character.toString((char)b) : ""));
        }
        this.currentBuffer.put((byte)b);
    }

    @Override
    public void flush() throws IOException {
        this.flushPrivate();
    }

    private void flushIfFilled() throws IOException {
        if (this.currentBuffer != null && !this.currentBuffer.hasRemaining()) {
            this.flushPrivate();
        }
    }

    private void flushPrivate() {
        if (this.currentBuffer != null) {
            this.bufferHandler.handleBuffer(this.currentBuffer);
            this.currentBuffer = null;
        }
    }

    public void flushWithEOS() throws IOException {
        this.flushWithEOS(false);
    }

    public void flushWithEOS(boolean ccam) throws IOException {
        this.throwExceptionOnError();
        this.ensureBufferPrivate();
        this.currentBuffer.setEOS(true);
        this.currentBuffer.setCCAM(ccam);
        this.flushPrivate();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.isPropagateClose()) {
                LifecycleUtil.deactivate((Object)this.bufferHandler);
            }
        }
        finally {
            this.bufferHandler = null;
            this.bufferProvider = null;
            this.currentBuffer = null;
            super.close();
        }
    }

    public String toString() {
        return "BufferOutputStream";
    }

    protected void ensureBuffer() throws IOException {
        this.ensureBufferPrivate();
    }

    private void ensureBufferPrivate() {
        if (this.currentBuffer == null) {
            this.currentBuffer = this.bufferProvider.provideBuffer();
            this.currentBuffer.setErrorHandler(this.errorHandler);
            this.currentBuffer.startPutting(this.channelID);
        }
    }

    private void throwExceptionOnError() throws IOException {
        if (this.error != null) {
            if (this.error instanceof IOException) {
                throw (IOException)this.error;
            }
            if (this.error instanceof RuntimeException) {
                throw (RuntimeException)this.error;
            }
            throw new IORuntimeException(this.error);
        }
    }

    protected boolean isPropagateClose() {
        return false;
    }

    private static IBufferProvider extractBufferProvider(IBufferHandler bufferHandler) {
        if (bufferHandler instanceof IBufferProvider) {
            return (IBufferProvider)((Object)bufferHandler);
        }
        throw new IllegalArgumentException("Buffer handler unable to provide buffers");
    }
}

