/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.security.AuthenticatingSignalProtocol;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.DiffieHellman;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;

public class AuthenticationIndication
extends IndicationWithMonitoring {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, AuthenticationIndication.class);
    private DiffieHellman.Server.Challenge challenge;

    public AuthenticationIndication(AuthenticatingSignalProtocol<?> protocol, short id, String name) {
        super(protocol, id, name);
    }

    public AuthenticationIndication(AuthenticatingSignalProtocol<?> protocol, short signalID) {
        super(protocol, signalID);
    }

    public AuthenticationIndication(AuthenticatingSignalProtocol<?> protocol, Enum<?> literal) {
        super(protocol, literal);
    }

    public AuthenticatingSignalProtocol<?> getProtocol() {
        return (AuthenticatingSignalProtocol)super.getProtocol();
    }

    @Override
    protected int getIndicatingWorkPercent() {
        return 1;
    }

    @Override
    protected void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
        this.challenge = new DiffieHellman.Server.Challenge((ExtendedDataInput)in);
    }

    protected final DiffieHellman.Server.Challenge getChallenge() {
        return this.challenge;
    }

    @Override
    protected void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            try {
                IPasswordCredentialsProvider credentialsProvider = this.getCredentialsProvider();
                if (credentialsProvider == null) {
                    throw new IllegalStateException("No credentials provider configured");
                }
                IPasswordCredentials credentials = credentialsProvider.getCredentials();
                if (credentials == null) {
                    throw new IllegalStateException("No credentials provided");
                }
                String userID = credentials.getUserID();
                if (StringUtil.isEmpty((String)userID)) {
                    throw new IllegalStateException("No userID provided");
                }
                String password = new String(credentials.getPassword());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ExtendedDataOutputStream stream = new ExtendedDataOutputStream((OutputStream)baos);
                stream.writeString(userID);
                stream.writeString(password);
                stream.flush();
                byte[] clearText = baos.toByteArray();
                DiffieHellman.Client client = new DiffieHellman.Client();
                DiffieHellman.Client.Response response = client.handleChallenge(this.challenge, clearText);
                out.writeBoolean(true);
                response.write((ExtendedDataOutput)out);
            }
            catch (Throwable ex) {
                out.writeBoolean(false);
                if (TRACER.isEnabled()) {
                    TRACER.trace(ex);
                }
                async.stop();
                monitor.done();
            }
        }
        finally {
            async.stop();
            monitor.done();
        }
    }

    protected IPasswordCredentialsProvider getCredentialsProvider() {
        SignalProtocol protocol = this.getProtocol();
        return ((AuthenticatingSignalProtocol)protocol).getCredentialsProvider();
    }
}

