/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.ui.actions.AbstractViewAction;
import org.eclipse.emf.cdo.internal.ui.dialogs.AbstractBranchPointDialog;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.transaction.CDOMerger;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.spi.cdo.DefaultCDOMerger;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class MergeBranchPointAction
extends AbstractViewAction {
    public static final String ID = "merge";
    private static final String TITLE = Messages.getString("MergeBranchPointAction.0");
    private static final String TOOL_TIP = Messages.getString("MergeBranchPointAction.1");
    private CDOBranchPoint source;

    public MergeBranchPointAction(IWorkbenchPage page, CDOView view) {
        super(page, String.valueOf(TITLE) + INTERACTIVE, TOOL_TIP, null, view);
        this.setId(ID);
    }

    protected void preRun() throws Exception {
        Shell shell = this.getShell();
        CDOTransaction target = (CDOTransaction)this.getView();
        this.source = AbstractBranchPointDialog.select(shell, true, (CDOBranchPoint)target);
        if (this.source == null) {
            this.cancel();
            return;
        }
        super.preRun();
    }

    protected void doRun(IProgressMonitor progressMonitor) throws Exception {
        DefaultCDOMerger.PerFeature.ManyValued merger = new DefaultCDOMerger.PerFeature.ManyValued();
        CDOTransaction target = (CDOTransaction)this.getView();
        target.merge(this.source, (CDOMerger)merger);
    }
}

