/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Tree;

public class CDOTreeExpansionAgent {
    private final Listener listener = new Listener();
    private final Set<CDOID> expandedIDs = new HashSet<CDOID>();
    private final Set<CDOID> expandedWrappers = new HashSet<CDOID>();
    private final CDOView view;
    private final TreeViewer viewer;

    public CDOTreeExpansionAgent(final CDOView view, final TreeViewer viewer) {
        CheckUtil.checkArg((Object)view, (String)"view");
        CheckUtil.checkArg((Object)viewer, (String)"viewer");
        this.view = view;
        this.viewer = viewer;
        Tree tree = viewer.getTree();
        if (!tree.isDisposed()) {
            tree.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = viewer.getExpandedElements();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        CDOTreeExpansionAgent.this.addExpandedElement(element);
                        ++n2;
                    }
                    view.addListener((IListener)CDOTreeExpansionAgent.this.listener);
                    viewer.addTreeListener((ITreeViewerListener)CDOTreeExpansionAgent.this.listener);
                    viewer.getTree().addDisposeListener((DisposeListener)CDOTreeExpansionAgent.this.listener);
                }
            });
        }
    }

    public final CDOView getView() {
        return this.view;
    }

    public final TreeViewer getViewer() {
        return this.viewer;
    }

    public void setExpandedStates() {
        CDOObject object2;
        for (CDOID id : this.expandedIDs) {
            try {
                object2 = this.view.getObject(id);
                if (object2 == null) continue;
                EObject eObject = CDOUtil.getEObject((EObject)object2);
                this.viewer.setExpandedState((Object)eObject, true);
            }
            catch (Exception object2) {
                // empty catch block
            }
        }
        for (CDOID id : this.expandedWrappers) {
            try {
                CDOElement wrapper;
                object2 = this.view.getObject(id);
                if (object2 == null || (wrapper = CDOElement.getFor((Object)object2)) == null) continue;
                this.viewer.setExpandedState((Object)wrapper, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        try {
            final Tree tree = this.viewer.getTree();
            if (!tree.isDisposed()) {
                tree.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        tree.removeDisposeListener((DisposeListener)CDOTreeExpansionAgent.this.listener);
                    }
                });
            }
            this.viewer.removeTreeListener((ITreeViewerListener)this.listener);
            this.view.removeListener((IListener)this.listener);
            this.expandedIDs.clear();
            this.expandedWrappers.clear();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    private CDOID getID(Object element) {
        CDOObject object;
        if (element instanceof EObject && (object = CDOUtil.getCDOObject((EObject)((EObject)element), (boolean)false)) != null && object.cdoView() == this.view) {
            return object.cdoID();
        }
        return null;
    }

    private void addExpandedElement(Object element) {
        if (element instanceof CDOElement) {
            CDOElement wrapper = (CDOElement)element;
            CDOID id = this.getID(wrapper.getDelegate());
            if (id != null) {
                this.expandedWrappers.add(id);
            }
        } else {
            CDOID id = this.getID(element);
            if (id != null) {
                this.expandedIDs.add(id);
            }
        }
    }

    private void removeExpandedElement(Object element) {
        if (element instanceof CDOElement) {
            CDOElement wrapper = (CDOElement)element;
            CDOID id = this.getID(wrapper.getDelegate());
            if (id != null) {
                this.expandedWrappers.remove(id);
            }
        } else {
            CDOID id = this.getID(element);
            if (id != null) {
                this.expandedIDs.remove(id);
            }
        }
    }

    private final class Listener
    implements IListener,
    ITreeViewerListener,
    DisposeListener {
        private Listener() {
        }

        public void notifyEvent(IEvent event) {
            ILifecycleEvent e;
            if (event instanceof CDOViewTargetChangedEvent) {
                final Tree tree = CDOTreeExpansionAgent.this.viewer.getTree();
                if (!tree.isDisposed()) {
                    tree.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!tree.isDisposed() && !CDOTreeExpansionAgent.this.view.isClosed()) {
                                CDOTreeExpansionAgent.this.setExpandedStates();
                            }
                        }
                    });
                }
            } else if (event instanceof ILifecycleEvent && (e = (ILifecycleEvent)event).getKind() == ILifecycleEvent.Kind.ABOUT_TO_DEACTIVATE) {
                CDOTreeExpansionAgent.this.dispose();
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Object element = event.getElement();
            CDOTreeExpansionAgent.this.addExpandedElement(element);
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            Object element = event.getElement();
            CDOTreeExpansionAgent.this.removeExpandedElement(element);
        }

        public void widgetDisposed(DisposeEvent e) {
            CDOTreeExpansionAgent.this.dispose();
        }
    }
}

