/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.paletteconfiguration.provider;

import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.Image;

public class ElementTypeLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private String typesEditBundle = "org.eclipse.papyrus.infra.types.edit";
    private String SpecializationTypeConfigurationIconPath = "/icons/full/obj16/SpecializationTypeConfiguration.gif";
    private String ElementTypeSetConfigurationIconPath = "/icons/full/obj16/ElementTypeSetConfiguration.gif";
    private String MetamodelTypeConfigurationIconPath = "/icons/full/obj16/SpecializationTypeConfiguration.gif";

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof ElementTypeSetConfiguration) {
            image = Activator.getDefault().getImage(this.typesEditBundle, this.ElementTypeSetConfigurationIconPath);
        } else if (element instanceof MetamodelTypeConfiguration) {
            image = Activator.getDefault().getImage(this.typesEditBundle, this.MetamodelTypeConfigurationIconPath);
        } else if (element instanceof SpecializationTypeConfiguration) {
            image = Activator.getDefault().getImage(this.typesEditBundle, this.SpecializationTypeConfigurationIconPath);
        }
        return image;
    }

    public StyledString getStyledText(Object element) {
        StyledString text = new StyledString();
        if (element instanceof ElementTypeSetConfiguration && ((ElementTypeSetConfiguration)element).getName() != null) {
            text.append(((ElementTypeSetConfiguration)element).getName());
            text.append(" - " + ((ElementTypeSetConfiguration)element).getIdentifier(), StyledString.QUALIFIER_STYLER);
        } else if (element instanceof ElementTypeConfiguration && ((ElementTypeConfiguration)element).getName() != null) {
            text.append(((ElementTypeConfiguration)element).getName());
            text.append(" - " + ((ElementTypeConfiguration)element).getIdentifier(), StyledString.QUALIFIER_STYLER);
        } else {
            text.append(super.getText(element));
        }
        return text;
    }
}

