/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.ISelectionBackgroundCustomizationElement;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSValue;

public class CSSPropertySelectionBackgroundHandler
implements ICSSPropertyHandler {
    private static final String SWT_SELECTION_FOREGROUND_COLOR = "swt-selection-foreground-color";
    private static final String SWT_SELECTION_BACKGROUND_COLOR = "swt-selection-background-color";
    private static final String SWT_SELECTION_BORDER_COLOR = "swt-selection-border-color";
    private static final String SWT_HOT_BACKGROUND_COLOR = "swt-hot-background-color";
    private static final String SWT_HOT_BORDER_COLOR = "swt-hot-border-color";

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(element instanceof ISelectionBackgroundCustomizationElement && element instanceof ElementAdapter && ((ElementAdapter)element).getNativeWidget() instanceof Widget && property != null && value.getCssValueType() == 1)) {
            return false;
        }
        Widget widget = (Widget)((ElementAdapter)element).getNativeWidget();
        ISelectionBackgroundCustomizationElement treeElement = (ISelectionBackgroundCustomizationElement)element;
        Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
        switch (property) {
            case "swt-selection-foreground-color": {
                treeElement.setSelectionForegroundColor(newColor);
                break;
            }
            case "swt-selection-background-color": {
                treeElement.setSelectionBackgroundColor(newColor);
                break;
            }
            case "swt-selection-border-color": {
                treeElement.setSelectionBorderColor(newColor);
                break;
            }
            case "swt-hot-background-color": {
                treeElement.setHotBackgroundColor(newColor);
                break;
            }
            case "swt-hot-border-color": {
                treeElement.setHotBorderColor(newColor);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

