/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.net4j.util.StringUtil;

public abstract class CDOTask
extends Task {
    public static final String FALSE = Boolean.FALSE.toString();
    public static final String TRUE = Boolean.TRUE.toString();
    public static final String NL = System.getProperty("line.separator");
    public static final int EOF = -1;
    protected final IWorkspace workspace = ResourcesPlugin.getWorkspace();
    protected final IWorkspaceRoot root = this.workspace.getRoot();
    protected boolean verbose = true;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public final void execute() throws BuildException {
        this.checkAttributes();
        try {
            this.doExecute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException((Throwable)ex);
        }
    }

    protected void checkAttributes() throws BuildException {
    }

    protected abstract void doExecute() throws Exception;

    protected final void verbose(Object object) {
        if (this.verbose) {
            this.log(String.valueOf(object));
        }
    }

    protected final IProgressMonitor getProgressMonitor() {
        try {
            IProgressMonitor progressMonitor;
            if (this.getProject() != null && (progressMonitor = (IProgressMonitor)this.getProject().getReferences().get("eclipse.progress.monitor")) != null) {
                return progressMonitor;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new NullProgressMonitor();
    }

    public static boolean isSet(String str) {
        return !StringUtil.isEmpty((String)str);
    }

    public static void assertTrue(String message, boolean expression) throws BuildException {
        if (!expression) {
            throw new BuildException(message);
        }
    }

    public static String readTextFile(File file) throws IOException {
        FileReader input = new FileReader(file);
        try {
            CharArrayWriter output = new CharArrayWriter();
            CDOTask.copyCharacter(input, output);
            String string = output.toString();
            return string;
        }
        finally {
            CDOTask.closeSilent(input);
        }
    }

    public static void writeTextFile(File file, String content) throws IOException {
        FileWriter output = new FileWriter(file);
        try {
            CharArrayReader input = new CharArrayReader(content.toCharArray());
            CDOTask.copyCharacter(input, output);
        }
        finally {
            CDOTask.closeSilent(output);
        }
    }

    private static Exception closeSilent(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return null;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    private static long copyCharacter(Reader reader, Writer writer) throws IOException {
        int c;
        if (!(reader instanceof BufferedReader) && !(reader instanceof CharArrayReader)) {
            reader = new BufferedReader(reader);
        }
        if (!(writer instanceof BufferedWriter) && !(writer instanceof CharArrayWriter)) {
            writer = new BufferedWriter(writer);
        }
        long size = 0L;
        while ((c = reader.read()) != -1) {
            writer.write(c);
            ++size;
        }
        writer.flush();
        return size;
    }
}

