/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.request;

import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdi.internal.FieldImpl;
import org.eclipse.jdi.internal.LocationImpl;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ObjectReferenceImpl;
import org.eclipse.jdi.internal.ReferenceTypeImpl;
import org.eclipse.jdi.internal.ThreadReferenceImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.event.EventImpl;
import org.eclipse.jdi.internal.jdwp.JdwpReplyPacket;
import org.eclipse.jdi.internal.request.RequestID;
import org.eclipse.jdi.internal.request.RequestMessages;

public abstract class EventRequestImpl
extends MirrorImpl
implements EventRequest {
    public static final byte STEP_SIZE_MIN_JDWP = 0;
    public static final byte STEP_SIZE_LINE_JDWP = 1;
    public static final byte STEP_DEPTH_INTO_JDWP = 0;
    public static final byte STEP_DEPTH_OVER_JDWP = 1;
    public static final byte STEP_DEPTH_OUT_JDWP = 2;
    public static final byte STEP_DEPTH_REENTER_JDWP_HCR = 3;
    public static final byte SUSPENDPOL_NONE_JDWP = 0;
    public static final byte SUSPENDPOL_EVENT_THREAD_JDWP = 1;
    public static final byte SUSPENDPOL_ALL_JDWP = 2;
    public static final byte MODIF_KIND_COUNT = 1;
    public static final byte MODIF_KIND_CONDITIONAL = 2;
    public static final byte MODIF_KIND_THREADONLY = 3;
    public static final byte MODIF_KIND_CLASSONLY = 4;
    public static final byte MODIF_KIND_CLASSMATCH = 5;
    public static final byte MODIF_KIND_CLASSEXCLUDE = 6;
    public static final byte MODIF_KIND_LOCATIONONLY = 7;
    public static final byte MODIF_KIND_EXCEPTIONONLY = 8;
    public static final byte MODIF_KIND_FIELDONLY = 9;
    public static final byte MODIF_KIND_STEP = 10;
    public static final byte MODIF_KIND_INSTANCE = 11;
    public static final byte MODIF_KIND_SOURCE_NAME_FILTER = 12;
    private static HashMap<Integer, String> fStepSizeMap = null;
    private static HashMap<Integer, String> fStepDepthMap = null;
    private static HashMap<Integer, String> fSuspendPolicyMap = null;
    private static HashMap<Integer, String> fModifierKindMap = null;
    private boolean fGeneratedInside = false;
    private HashMap<Object, Object> fPropertyMap;
    protected RequestID fRequestID = null;
    private byte fSuspendPolicy = (byte)2;
    protected ArrayList<Integer> fCountFilters;
    protected ArrayList<ThreadReference> fThreadFilters = null;
    protected ArrayList<String> fClassFilters = null;
    protected ArrayList<ReferenceType> fClassFilterRefs = null;
    protected ArrayList<String> fClassExclusionFilters = null;
    protected ArrayList<LocationImpl> fLocationFilters = null;
    protected ArrayList<ExceptionFilter> fExceptionFilters = null;
    protected ArrayList<FieldImpl> fFieldFilters = null;
    protected ArrayList<ThreadStepFilter> fThreadStepFilters = null;
    protected ArrayList<ObjectReference> fInstanceFilters = null;
    protected ArrayList<String> fSourceNameFilters = null;

    protected EventRequestImpl(String description, VirtualMachineImpl vmImpl) {
        super(description, vmImpl);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + (this.fRequestID == null ? RequestMessages.EventRequestImpl___not_enabled__1 : String.valueOf(RequestMessages.EventRequestImpl____2) + this.fRequestID);
    }

    @Override
    public Object getProperty(Object key) {
        if (this.fPropertyMap == null) {
            return null;
        }
        return this.fPropertyMap.get(key);
    }

    @Override
    public void putProperty(Object key, Object value) {
        if (this.fPropertyMap == null) {
            this.fPropertyMap = new HashMap();
        }
        if (value == null) {
            this.fPropertyMap.remove(key);
        } else {
            this.fPropertyMap.put(key, value);
        }
    }

    public void setGeneratedInside() {
        this.fGeneratedInside = true;
    }

    public final boolean isGeneratedInside() {
        return this.fGeneratedInside;
    }

    @Override
    public synchronized void disable() {
        if (!this.isEnabled()) {
            return;
        }
        this.initJdwpRequest();
        try {
            try {
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                DataOutputStream outData = new DataOutputStream(outBytes);
                this.writeByte(this.eventKind(), "event kind", EventImpl.eventKindMap(), outData);
                this.fRequestID.write(this, outData);
                JdwpReplyPacket replyPacket = this.requestVM(3842, outBytes);
                switch (replyPacket.errorCode()) {
                    case 41: {
                        throw new InvalidRequestStateException();
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                this.virtualMachineImpl().eventRequestManagerImpl().removeRequestIDMapping(this);
                this.fRequestID = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                this.handledJdwpRequest();
            }
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    @Override
    public synchronized void enable() {
        if (this.isEnabled()) {
            return;
        }
        this.initJdwpRequest();
        try {
            try {
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                DataOutputStream outData = new DataOutputStream(outBytes);
                this.writeByte(this.eventKind(), "event kind", EventImpl.eventKindMap(), outData);
                this.writeByte(this.suspendPolicyJDWP(), "suspend policy", EventRequestImpl.suspendPolicyMap(), outData);
                this.writeInt(this.modifierCount(), "modifiers", outData);
                this.writeModifiers(outData);
                JdwpReplyPacket replyPacket = this.requestVM(3841, outBytes);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                this.fRequestID = RequestID.read(this, replyData);
                this.virtualMachineImpl().eventRequestManagerImpl().addRequestIDMapping(this);
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                this.handledJdwpRequest();
            }
        }
        finally {
            this.handledJdwpRequest();
        }
    }

    public static void clearAllBreakpoints(MirrorImpl mirror) {
        mirror.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = mirror.requestVM(3843);
            mirror.defaultReplyErrorHandler(replyPacket.errorCode());
        }
        finally {
            mirror.handledJdwpRequest();
        }
    }

    @Override
    public final synchronized boolean isEnabled() {
        return this.fRequestID != null;
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void checkDisabled() throws InvalidRequestStateException {
        if (this.isEnabled()) {
            throw new InvalidRequestStateException();
        }
    }

    @Override
    public void setSuspendPolicy(int suspendPolicy) {
        this.fSuspendPolicy = (byte)suspendPolicy;
        if (this.isEnabled()) {
            this.disable();
            this.enable();
        }
    }

    @Override
    public int suspendPolicy() {
        return this.fSuspendPolicy;
    }

    public final RequestID requestID() {
        return this.fRequestID;
    }

    @Override
    public void addCountFilter(int count) throws InvalidRequestStateException {
        this.checkDisabled();
        if (this.fCountFilters == null) {
            this.fCountFilters = new ArrayList();
        }
        this.fCountFilters.add(new Integer(count));
    }

    public void addThreadFilter(ThreadReference threadFilter) throws ObjectCollectedException, VMMismatchException, InvalidRequestStateException {
        this.checkVM(threadFilter);
        this.checkDisabled();
        if (threadFilter.isCollected()) {
            throw new ObjectCollectedException();
        }
        if (this.fThreadFilters == null) {
            this.fThreadFilters = new ArrayList();
        }
        this.fThreadFilters.add(threadFilter);
    }

    public void addClassFilter(ReferenceType filter) throws VMMismatchException, InvalidRequestStateException {
        this.checkVM(filter);
        this.checkDisabled();
        if (this.fClassFilterRefs == null) {
            this.fClassFilterRefs = new ArrayList();
        }
        this.fClassFilterRefs.add(filter);
    }

    public void addClassFilter(String filter) throws InvalidRequestStateException {
        this.checkDisabled();
        if (this.fClassFilters == null) {
            this.fClassFilters = new ArrayList();
        }
        this.fClassFilters.add(filter);
    }

    public void addClassExclusionFilter(String filter) throws InvalidRequestStateException {
        this.checkDisabled();
        if (this.fClassExclusionFilters == null) {
            this.fClassExclusionFilters = new ArrayList();
        }
        this.fClassExclusionFilters.add(filter);
    }

    public void addLocationFilter(LocationImpl location) throws VMMismatchException {
        this.checkDisabled();
        this.checkVM(location);
        if (this.fLocationFilters == null) {
            this.fLocationFilters = new ArrayList();
        }
        this.fLocationFilters.add(location);
    }

    public void addExceptionFilter(ReferenceTypeImpl refType, boolean notifyCaught, boolean notifyUncaught) throws VMMismatchException {
        this.checkDisabled();
        if (refType != null) {
            this.checkVM(refType);
        }
        if (this.fExceptionFilters == null) {
            this.fExceptionFilters = new ArrayList();
        }
        ExceptionFilter filter = new ExceptionFilter();
        filter.fException = refType;
        filter.fNotifyCaught = notifyCaught;
        filter.fNotifyUncaught = notifyUncaught;
        this.fExceptionFilters.add(filter);
    }

    public void addFieldFilter(FieldImpl field) throws VMMismatchException {
        this.checkDisabled();
        this.checkVM(field);
        if (this.fFieldFilters == null) {
            this.fFieldFilters = new ArrayList();
        }
        this.fFieldFilters.add(field);
    }

    public void addStepFilter(ThreadReferenceImpl thread, int size, int depth) throws VMMismatchException {
        this.checkDisabled();
        this.checkVM(thread);
        if (this.fThreadStepFilters == null) {
            this.fThreadStepFilters = new ArrayList();
        }
        ThreadStepFilter filter = new ThreadStepFilter();
        filter.fThread = thread;
        filter.fThreadStepSize = size;
        filter.fThreadStepDepth = depth;
        this.fThreadStepFilters.add(filter);
    }

    public void addInstanceFilter(ObjectReference instance) {
        this.checkDisabled();
        this.checkVM(instance);
        if (this.fInstanceFilters == null) {
            this.fInstanceFilters = new ArrayList();
        }
        this.fInstanceFilters.add(instance);
    }

    public void addSourceNameFilter(String pattern) {
        this.checkDisabled();
        if (this.fSourceNameFilters == null) {
            this.fSourceNameFilters = new ArrayList();
        }
        this.fSourceNameFilters.add(pattern);
    }

    public byte suspendPolicyJDWP() {
        switch (this.fSuspendPolicy) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new InternalException(String.valueOf(RequestMessages.EventRequestImpl_Invalid_suspend_policy_encountered___3) + this.fSuspendPolicy);
    }

    public int threadStepSizeJDWP(int threadStepSize) {
        switch (threadStepSize) {
            case -1: {
                return 0;
            }
            case -2: {
                return 1;
            }
        }
        throw new InternalException(String.valueOf(RequestMessages.EventRequestImpl_Invalid_step_size_encountered___4) + threadStepSize);
    }

    public int threadStepDepthJDWP(int threadStepDepth) {
        switch (threadStepDepth) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        throw new InternalException(String.valueOf(RequestMessages.EventRequestImpl_Invalid_step_depth_encountered___5) + threadStepDepth);
    }

    protected abstract byte eventKind();

    protected int modifierCount() {
        int count = 0;
        if (this.fCountFilters != null) {
            count += this.fCountFilters.size();
        }
        if (this.fThreadFilters != null) {
            count += this.fThreadFilters.size();
        }
        if (this.fClassFilterRefs != null) {
            count += this.fClassFilterRefs.size();
        }
        if (this.fClassFilters != null) {
            count += this.fClassFilters.size();
        }
        if (this.fClassExclusionFilters != null) {
            count += this.fClassExclusionFilters.size();
        }
        if (this.fLocationFilters != null) {
            count += this.fLocationFilters.size();
        }
        if (this.fExceptionFilters != null) {
            count += this.fExceptionFilters.size();
        }
        if (this.fFieldFilters != null) {
            count += this.fFieldFilters.size();
        }
        if (this.fThreadStepFilters != null) {
            count += this.fThreadStepFilters.size();
        }
        if (this.fInstanceFilters != null) {
            count += this.fInstanceFilters.size();
        }
        if (this.fSourceNameFilters != null && this.supportsSourceNameFilters()) {
            count += this.fSourceNameFilters.size();
        }
        return count;
    }

    protected void writeModifiers(DataOutputStream outData) throws IOException {
        if (this.fThreadStepFilters != null) {
            for (ThreadStepFilter threadStepFilter : this.fThreadStepFilters) {
                this.writeByte((byte)10, "modifier", EventRequestImpl.modifierKindMap(), outData);
                threadStepFilter.fThread.write(this, outData);
                this.writeInt(this.threadStepSizeJDWP(threadStepFilter.fThreadStepSize), "step size", outData);
                this.writeInt(this.threadStepDepthJDWP(threadStepFilter.fThreadStepDepth), "step depth", outData);
            }
        }
        if (this.fFieldFilters != null) {
            for (FieldImpl fieldImpl : this.fFieldFilters) {
                this.writeByte((byte)9, "modifier", EventRequestImpl.modifierKindMap(), outData);
                fieldImpl.writeWithReferenceType(this, outData);
            }
        }
        if (this.fExceptionFilters != null) {
            for (ExceptionFilter exceptionFilter : this.fExceptionFilters) {
                this.writeByte((byte)8, "modifier", EventRequestImpl.modifierKindMap(), outData);
                if (exceptionFilter.fException != null) {
                    exceptionFilter.fException.write(this, outData);
                } else {
                    ReferenceTypeImpl.writeNull(this, outData);
                }
                this.writeBoolean(exceptionFilter.fNotifyCaught, "notify caught", outData);
                this.writeBoolean(exceptionFilter.fNotifyUncaught, "notify uncaught", outData);
            }
        }
        if (this.fLocationFilters != null) {
            for (LocationImpl locationImpl : this.fLocationFilters) {
                this.writeByte((byte)7, "modifier", EventRequestImpl.modifierKindMap(), outData);
                locationImpl.write(this, outData);
            }
        }
        if (this.fClassExclusionFilters != null) {
            for (String string : this.fClassExclusionFilters) {
                this.writeByte((byte)6, "modifier", EventRequestImpl.modifierKindMap(), outData);
                this.writeString(string, "class excl. filter", outData);
            }
        }
        if (this.fClassFilters != null) {
            for (String string : this.fClassFilters) {
                this.writeByte((byte)5, "modifier", EventRequestImpl.modifierKindMap(), outData);
                this.writeString(string, "class filter", outData);
            }
        }
        if (this.fClassFilterRefs != null) {
            for (ReferenceType referenceType : this.fClassFilterRefs) {
                this.writeByte((byte)4, "modifier", EventRequestImpl.modifierKindMap(), outData);
                ((ReferenceTypeImpl)referenceType).write(this, outData);
            }
        }
        if (this.fThreadFilters != null) {
            for (ThreadReference threadReference : this.fThreadFilters) {
                this.writeByte((byte)3, "modifier", EventRequestImpl.modifierKindMap(), outData);
                ((ThreadReferenceImpl)threadReference).write(this, outData);
            }
        }
        if (this.fCountFilters != null) {
            for (Integer n : this.fCountFilters) {
                this.writeByte((byte)1, "modifier", EventRequestImpl.modifierKindMap(), outData);
                this.writeInt(n, "count filter", outData);
            }
        }
        if (this.fInstanceFilters != null) {
            for (ObjectReference objectReference : this.fInstanceFilters) {
                this.writeByte((byte)11, "modifier", EventRequestImpl.modifierKindMap(), outData);
                ((ObjectReferenceImpl)objectReference).write(this, outData);
            }
        }
        if (this.fSourceNameFilters != null && this.supportsSourceNameFilters()) {
            for (String string : this.fSourceNameFilters) {
                this.writeByte((byte)12, "modifier", EventRequestImpl.modifierKindMap(), outData);
                this.writeString(string, "modifier", outData);
            }
        }
    }

    private boolean supportsSourceNameFilters() {
        return ((VirtualMachineImpl)this.virtualMachine()).isJdwpVersionGreaterOrEqual(1, 6);
    }

    public static void getConstantMaps() {
        if (fStepSizeMap != null) {
            return;
        }
        fStepSizeMap = new HashMap();
        fStepDepthMap = new HashMap();
        fSuspendPolicyMap = new HashMap();
        fModifierKindMap = new HashMap();
        Field[] fieldArray = EventRequestImpl.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 1) != 0 && (field.getModifiers() & 8) != 0 && (field.getModifiers() & 0x10) != 0) {
                try {
                    String name = field.getName();
                    Integer intValue = new Integer(field.getInt(null));
                    if (name.startsWith("STEP_SIZE_")) {
                        name = name.substring(10);
                        fStepSizeMap.put(intValue, name);
                    } else if (name.startsWith("STEP_DEPTH_")) {
                        name = name.substring(11);
                        fStepDepthMap.put(intValue, name);
                    } else if (name.startsWith("SUSPENDPOL_")) {
                        name = name.substring(11);
                        fSuspendPolicyMap.put(intValue, name);
                    } else if (name.startsWith("MODIF_KIND_")) {
                        name = name.substring(11);
                        fModifierKindMap.put(intValue, name);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++n2;
        }
    }

    public static Map<Integer, String> stepSizeMap() {
        EventRequestImpl.getConstantMaps();
        return fStepSizeMap;
    }

    public static Map<Integer, String> stepDepthMap() {
        EventRequestImpl.getConstantMaps();
        return fStepDepthMap;
    }

    public static Map<Integer, String> suspendPolicyMap() {
        EventRequestImpl.getConstantMaps();
        return fSuspendPolicyMap;
    }

    public static Map<Integer, String> modifierKindMap() {
        EventRequestImpl.getConstantMaps();
        return fModifierKindMap;
    }

    class ExceptionFilter {
        ReferenceTypeImpl fException = null;
        boolean fNotifyCaught = false;
        boolean fNotifyUncaught = false;

        ExceptionFilter() {
        }
    }

    class ThreadStepFilter {
        protected ThreadReferenceImpl fThread = null;
        protected int fThreadStepSize;
        protected int fThreadStepDepth;

        ThreadStepFilter() {
        }
    }
}

