/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.properties.providers;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.cell.IGenericMatrixRelationshipCellManager;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.nattable.properties.providers.GenericRelationshipMatrixElementTypeLabelProvider;
import org.eclipse.swt.widgets.Composite;

public final class GenericRelationshipMatrixElementTypeContentProvider
implements IStaticContentProvider,
IGraphicalContentProvider,
IHierarchicContentProvider,
ITreeContentProvider,
IContentProvider {
    private MergedArchitectureContext architextureContext;
    private Collection<EClass> managedRelationships;
    private Collection<String> elementTypeSetConfigurationToIgnore;
    private Map<ElementTypeSetConfiguration, Collection<ElementTypeConfiguration>> typeConfigurationAndTheirChildren;
    private Comparator<ElementTypeConfiguration> comparator = new ElementTypeConfigurationComparator();
    private static final String UML_METAMODEL_URI = "http://www.eclipse.org/uml2/5.0.0/UML";
    private EObject contextForAF;

    public GenericRelationshipMatrixElementTypeContentProvider(EObject context) {
        this.contextForAF = context;
        this.architextureContext = this.createArchitectureContext();
        this.initFields();
    }

    private MergedArchitectureContext createArchitectureContext() {
        if (this.contextForAF != null && this.contextForAF.eResource() != null && this.contextForAF.eResource().getResourceSet() != null) {
            return new ArchitectureDescriptionUtils((ModelSet)this.contextForAF.eResource().getResourceSet()).getArchitectureContext();
        }
        return null;
    }

    private void initFields() {
        this.managedRelationships = this.initManagedRelationships();
        this.elementTypeSetConfigurationToIgnore = this.initElementTypeSetConfigurationsToIgnore();
        this.typeConfigurationAndTheirChildren = this.initMapContents();
    }

    private Map<ElementTypeSetConfiguration, Collection<ElementTypeConfiguration>> initMapContents() {
        HashMap<ElementTypeSetConfiguration, Collection<ElementTypeConfiguration>> mapByMetamodel = new HashMap<ElementTypeSetConfiguration, Collection<ElementTypeConfiguration>>();
        if (this.architextureContext == null) {
            return mapByMetamodel;
        }
        for (ElementTypeSetConfiguration typeSet : this.architextureContext.getElementTypes()) {
            if (!UML_METAMODEL_URI.equals(typeSet.getMetamodelNsURI()) || this.elementTypeSetConfigurationToIgnore.contains(typeSet.getIdentifier())) continue;
            TreeSet<ElementTypeConfiguration> children = new TreeSet<ElementTypeConfiguration>(this.comparator);
            for (ElementTypeConfiguration configuration : typeSet.getElementTypeConfigurations()) {
                if (!this.isValidValue(configuration)) continue;
                children.add(configuration);
            }
            if (children.size() <= 0) continue;
            mapByMetamodel.put(typeSet, children);
        }
        return mapByMetamodel;
    }

    private Collection<EClass> initManagedRelationships() {
        HashSet<EClass> managedRelationships = new HashSet<EClass>();
        for (IGenericMatrixRelationshipCellManager current : CellManagerFactory.INSTANCE.getRegisteredGenericMatrixRelationshipCellManager()) {
            managedRelationships.add(current.getManagedRelationship());
        }
        return managedRelationships;
    }

    private Collection<String> initElementTypeSetConfigurationsToIgnore() {
        HashSet<String> ignoredStypeSets = new HashSet<String>();
        ignoredStypeSets.add("org.eclipse.papyrus.umldi.service.types.UMLDIElementTypeSet");
        ignoredStypeSets.add("org.eclipse.papyrus.sysml14di.elementTypeSet.class.extension");
        return ignoredStypeSets;
    }

    private boolean isManagedElementTypeConfiguration(ElementTypeConfiguration configuration) {
        SpecializationTypeConfiguration a;
        String name;
        IElementType elementType = configuration instanceof MetamodelTypeConfiguration ? ElementTypeRegistry.getInstance().getType(((MetamodelTypeConfiguration)configuration).getIdentifier()) : (configuration instanceof SpecializationTypeConfiguration ? ElementTypeRegistry.getInstance().getType(((SpecializationTypeConfiguration)configuration).getIdentifier()) : null);
        if (elementType == null) {
            return false;
        }
        String string = name = configuration.getName() == null ? "" : configuration.getName();
        if (name.split("::").length == 3) {
            return false;
        }
        if (elementType.getEClass() == null) {
            return false;
        }
        if (configuration instanceof MetamodelTypeConfiguration) {
            return this.managedRelationships.contains(((MetamodelTypeConfiguration)configuration).getEClass());
        }
        if (configuration instanceof SpecializationTypeConfiguration && (a = (SpecializationTypeConfiguration)configuration).getSpecializedTypes().size() == 1) {
            return this.isManagedElementTypeConfiguration((ElementTypeConfiguration)a.getSpecializedTypes().get(0));
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getElements() {
        MergedArchitectureContext af = this.createArchitectureContext();
        if (this.architextureContext != null && !this.architextureContext.equals((Object)af)) {
            this.architextureContext = af;
            this.initFields();
        }
        if (this.typeConfigurationAndTheirChildren != null) {
            return this.typeConfigurationAndTheirChildren.keySet().toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (this.typeConfigurationAndTheirChildren.containsKey(parentElement)) {
            return this.typeConfigurationAndTheirChildren.get(parentElement).toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.typeConfigurationAndTheirChildren.containsKey(element)) {
            return this.typeConfigurationAndTheirChildren.get(element).size() > 0;
        }
        return false;
    }

    public boolean isValidValue(Object element) {
        if (element instanceof ElementTypeConfiguration) {
            return this.isManagedElementTypeConfiguration((ElementTypeConfiguration)element);
        }
        return false;
    }

    public void createBefore(Composite parent) {
    }

    public void createAfter(Composite parent) {
    }

    private class ElementTypeConfigurationComparator
    implements Comparator<ElementTypeConfiguration> {
        private ILabelProvider provider = new GenericRelationshipMatrixElementTypeLabelProvider();

        private ElementTypeConfigurationComparator() {
        }

        @Override
        public int compare(ElementTypeConfiguration arg0, ElementTypeConfiguration arg1) {
            return this.provider.getText((Object)arg0).compareToIgnoreCase(this.provider.getText((Object)arg1));
        }
    }
}

