/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.JobFamilies;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.ConfigurationChecker;
import org.eclipse.egit.ui.internal.KnownHosts;
import org.eclipse.egit.ui.internal.RepositoryCacheRule;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.egit.ui.internal.variables.GitTemplateVariableResolver;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.ITheme;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements DebugOptionsListener {
    private static Activator plugin;
    private static List<IPropertyChangeListener> propertyChangeListeners;
    public static final String DECORATORS_CHANGED = "org.eclipse.egit.ui.DECORATORS_CHANGED";
    private ResourceManager resourceManager;
    private RepositoryChangeScanner rcs;
    private ResourceRefreshJob refreshJob;
    private DebugOptions debugOptions;
    private volatile boolean uiIsActive;
    private IWindowListener focusListener;

    static {
        propertyChangeListeners = new ArrayList<IPropertyChangeListener>(5);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    private static IStatus toStatus(int severity, String message, Throwable throwable) {
        Throwable exc = throwable;
        while (exc instanceof InvocationTargetException) {
            Throwable cause;
            String msg = exc.getLocalizedMessage();
            if (msg != null && !msg.isEmpty() || (cause = exc.getCause()) == null) break;
            exc = cause;
        }
        if (exc != null && (message == null || message.isEmpty())) {
            message = exc.getLocalizedMessage();
        }
        return new Status(severity, Activator.getPluginId(), message, exc);
    }

    public static void handleError(String message, Throwable throwable, boolean show) {
        Activator.handleIssue(4, message, throwable, show);
    }

    public static void handleIssue(int severity, String message, Throwable throwable, boolean show) {
        IStatus status = Activator.toStatus(severity, message, throwable);
        Activator.handleStatus(status, show);
    }

    public static void handleStatus(IStatus status, boolean show) {
        int style = 1;
        if (show) {
            style |= 2;
        }
        StatusManager.getManager().handle(status, style);
    }

    public static void showError(String message, Throwable throwable) {
        IStatus status = Activator.toStatus(4, message, throwable);
        StatusManager.getManager().handle(status, 2);
    }

    public static void showErrorStatus(String message, IStatus status) {
        StatusManager.getManager().handle(status, 2);
    }

    public static void logError(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static void logWarning(String message, Throwable thr) {
        Activator.handleIssue(2, message, thr, false);
    }

    public static void error(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return Activator.toStatus(4, message, throwable);
    }

    public static IStatus createErrorStatus(String message) {
        return Activator.toStatus(4, message, null);
    }

    public static ITheme getTheme() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
    }

    public static Font getFont(String id) {
        return Activator.getTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return Activator.getTheme().getFontRegistry().getBold(id);
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", context.getBundle().getSymbolicName());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        SelectionRepositoryStateCache.INSTANCE.initialize();
        this.setupRepoChangeScanner();
        this.setupFocusHandling();
        this.setupCredentialsProvider();
        ConfigurationChecker.checkConfiguration();
        this.registerTemplateVariableResolvers();
    }

    private void setupCredentialsProvider() {
        CredentialsProvider.setDefault((CredentialsProvider)new EGitCredentialsProvider());
    }

    private void registerTemplateVariableResolvers() {
        if (!Activator.hasJavaPlugin()) {
            return;
        }
        WorkbenchJob job = new WorkbenchJob(UIText.Activator_setupJdtTemplateResolver){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    ContextTypeRegistry codeTemplateContextRegistry = JavaPlugin.getDefault().getCodeTemplateContextRegistry();
                    Iterator ctIter = codeTemplateContextRegistry.contextTypes();
                    while (ctIter.hasNext()) {
                        TemplateContextType contextType = (TemplateContextType)ctIter.next();
                        contextType.addResolver((TemplateVariableResolver)new GitTemplateVariableResolver("git_config", UIText.GitTemplateVariableResolver_GitConfigDescription));
                    }
                }
                catch (Throwable e) {
                    Activator.logError("Cannot register git support for Java templates", e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    static boolean isActive() {
        return Activator.getDefault().uiIsActive;
    }

    private void setupFocusHandling() {
        this.focusListener = new IWindowListener(){

            private void updateUiState() {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean wasActive = Activator.this.uiIsActive;
                        Activator.this.uiIsActive = Display.getCurrent().getActiveShell() != null;
                        if (Activator.this.uiIsActive != wasActive && GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                            this.traceUiIsActive();
                        }
                    }

                    private void traceUiIsActive() {
                        StringBuilder message = new StringBuilder("workbench is ");
                        message.append(Activator.this.uiIsActive ? "active" : "inactive");
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), message.toString());
                    }
                });
            }

            public void windowOpened(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowDeactivated(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowClosed(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowActivated(IWorkbenchWindow window) {
                this.updateUiState();
                Activator.this.rcs.schedule(500L);
            }
        };
        Job job = new Job(UIText.Activator_setupFocusListener){

            protected IStatus run(IProgressMonitor monitor) {
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().addWindowListener(Activator.this.focusListener);
                    this.registerCoreJobFamilyIcons();
                } else {
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }

            private void registerCoreJobFamilyIcons() {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    service.registerIconForFamily(UIIcons.PULL, JobFamilies.PULL);
                    service.registerIconForFamily(UIIcons.REPOSITORY, JobFamilies.AUTO_IGNORE);
                    service.registerIconForFamily(UIIcons.REPOSITORY, JobFamilies.AUTO_SHARE);
                    service.registerIconForFamily(UIIcons.REPOSITORY, JobFamilies.INDEX_DIFF_CACHE_UPDATE);
                    service.registerIconForFamily(UIIcons.REPOSITORY, JobFamilies.REPOSITORY_CHANGED);
                });
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    public void optionsChanged(DebugOptions options) {
        this.debugOptions = options;
        GitTraceLocation.initializeFromOptions(options, this.isDebugging());
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public static synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static synchronized void broadcastPropertyChange(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private void setupRepoChangeScanner() {
        this.refreshJob = new ResourceRefreshJob();
        this.rcs = new RepositoryChangeScanner(this.refreshJob);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.rcs);
    }

    public void stop(BundleContext context) throws Exception {
        SelectionRepositoryStateCache.INSTANCE.dispose();
        if (this.focusListener != null) {
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().removeWindowListener(this.focusListener);
            }
            this.focusListener = null;
        }
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Trying to cancel " + this.rcs.getName() + " job");
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.rcs);
        this.rcs.setReschedule(false);
        this.rcs.cancel();
        this.refreshJob.cancel();
        this.rcs.join();
        this.refreshJob.join();
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Jobs terminated");
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.stop(context);
        plugin = null;
    }

    protected void saveDialogSettings() {
        KnownHosts.store();
        super.saveDialogSettings();
    }

    public RepositoryUtil getRepositoryUtil() {
        return org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil();
    }

    public synchronized ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display == null) {
                throw new IllegalStateException();
            }
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        }
        return this.resourceManager;
    }

    public static final boolean hasJavaPlugin() {
        return Platform.getBundle((String)"org.eclipse.jdt.ui") != null;
    }

    private static class RepositoryChangeScanner
    extends Job
    implements IPropertyChangeListener {
        private volatile boolean doReschedule;
        private int interval;
        private final ResourceRefreshJob refresher;
        private final RepositoryCache repositoryCache;
        private Collection<WorkingTreeModifiedEvent> events;
        private final IndexChangedListener listener = event -> {
            if (event.isInternal()) {
                return;
            }
            Repository repository = event.getRepository();
            if (repository.isBare()) {
                return;
            }
            ArrayList<String> directories = new ArrayList<String>();
            IProject[] iProjectArray = RuleUtil.getProjects((Repository)repository);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                String repoRelativePath;
                RepositoryMapping mapping;
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (mapping = RepositoryMapping.getMapping((IProject)project)) != null && repository == mapping.getRepository() && (repoRelativePath = mapping.getRepoRelativePath((IResource)project)) != null) {
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanning project " + project.getName());
                    }
                    try {
                        Throwable throwable = null;
                        Object var11_13 = null;
                        try (TreeWalk w = new TreeWalk(repository);){
                            w.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
                            if (!repoRelativePath.isEmpty()) {
                                w.setFilter(PathFilterGroup.createFromStrings((String[])new String[]{repoRelativePath}));
                            } else {
                                directories.add("/");
                            }
                            w.setRecursive(false);
                            while (w.next()) {
                                FileTreeIterator iter;
                                if (!w.isSubtree() || (iter = (FileTreeIterator)w.getTree(0, FileTreeIterator.class)) == null || iter.isEntryIgnored()) continue;
                                directories.add(String.valueOf(w.getPathString()) + '/');
                                w.enterSubtree();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanned project " + project.getName());
                    }
                }
                ++n2;
            }
            if (directories.isEmpty()) {
                return;
            }
            WorkingTreeModifiedEvent evt = new WorkingTreeModifiedEvent(directories, null);
            evt.setRepository(repository);
            this.events.add(evt);
        };

        public RepositoryChangeScanner(ResourceRefreshJob refresher) {
            super(UIText.Activator_repoScanJobName);
            this.refresher = refresher;
            this.setRule(new RepositoryCacheRule());
            this.setSystem(true);
            this.setUser(false);
            this.repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
            this.updateRefreshInterval();
        }

        public boolean shouldSchedule() {
            return this.doReschedule;
        }

        public boolean shouldRun() {
            return this.doReschedule;
        }

        public void setReschedule(boolean reschedule) {
            this.doReschedule = reschedule;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (Activator.getDefault().getPreferenceStore().getBoolean("refesh_only_when_active") && !Activator.isActive()) {
                monitor.done();
                return Status.OK_STATUS;
            }
            Repository[] repos = this.repositoryCache.getAllRepositories();
            if (repos.length == 0) {
                return Status.OK_STATUS;
            }
            monitor.beginTask(UIText.Activator_scanningRepositories, repos.length);
            try {
                try {
                    this.events = new ArrayList<WorkingTreeModifiedEvent>();
                    Repository[] repositoryArray = repos;
                    int n = repos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Repository repo = repositoryArray[n2];
                        if (monitor.isCanceled()) break;
                        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanning " + repo + " for changes");
                        }
                        if (!repo.isBare()) {
                            ListenerHandle handle = null;
                            try {
                                handle = repo.getListenerList().addIndexChangedListener(this.listener);
                                repo.scanForRepoChanges();
                            }
                            finally {
                                if (handle != null) {
                                    handle.remove();
                                }
                            }
                        }
                        monitor.worked(1);
                        ++n2;
                    }
                    if (!monitor.isCanceled()) {
                        this.refresher.trigger(this.events);
                    }
                    this.events.clear();
                }
                catch (IOException e) {
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Stopped rescheduling " + this.getName() + " job");
                    }
                    IStatus iStatus = Activator.createErrorStatus(UIText.Activator_scanError, e);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Rescheduling " + this.getName() + " job");
            }
            this.schedule(this.interval);
            return Status.OK_STATUS;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!"refesh_index_interval".equals(event.getProperty())) {
                return;
            }
            this.updateRefreshInterval();
        }

        private void updateRefreshInterval() {
            this.interval = RepositoryChangeScanner.getRefreshIndexInterval();
            this.setReschedule(this.interval > 0);
            this.cancel();
            this.schedule(this.interval);
        }

        private static int getRefreshIndexInterval() {
            return 1000 * Activator.getDefault().getPreferenceStore().getInt("refesh_index_interval");
        }
    }

    private static class ResourceRefreshJob
    extends Job {
        private Map<File, WorkingTreeChanges> repositoriesChanged = new LinkedHashMap<File, WorkingTreeChanges>();

        public ResourceRefreshJob() {
            super(UIText.Activator_refreshJobName);
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * Exception decompiling
         */
        public IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 18[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trigger(Collection<WorkingTreeModifiedEvent> events) {
            boolean haveChanges = false;
            for (WorkingTreeModifiedEvent event : events) {
                Repository repo;
                if (event.isEmpty() || (repo = event.getRepository()) == null || repo.isBare()) continue;
                File gitDir = repo.getDirectory();
                Map<File, WorkingTreeChanges> map = this.repositoriesChanged;
                synchronized (map) {
                    WorkingTreeChanges changes = this.repositoriesChanged.get(gitDir);
                    if (changes == null) {
                        this.repositoriesChanged.put(gitDir, new WorkingTreeChanges(event));
                    } else {
                        changes.merge(event);
                        if (changes.isEmpty()) {
                            this.repositoriesChanged.remove(gitDir);
                        }
                    }
                }
                haveChanges = true;
            }
            if (haveChanges) {
                this.schedule();
            }
        }

        private static class WorkingTreeChanges {
            private final File workTree;
            private final Set<String> modified;
            private final Set<String> deleted;

            public WorkingTreeChanges(WorkingTreeModifiedEvent event) {
                this.workTree = event.getRepository().getWorkTree().getAbsoluteFile();
                this.modified = new HashSet<String>(event.getModified());
                this.deleted = new HashSet<String>(event.getDeleted());
            }

            public File getWorkTree() {
                return this.workTree;
            }

            public Set<String> getModified() {
                return this.modified;
            }

            public Set<String> getDeleted() {
                return this.deleted;
            }

            public boolean isEmpty() {
                return this.modified.isEmpty() && this.deleted.isEmpty();
            }

            public WorkingTreeChanges merge(WorkingTreeModifiedEvent event) {
                this.modified.removeAll(event.getDeleted());
                this.deleted.removeAll(event.getModified());
                this.modified.addAll(event.getModified());
                this.deleted.addAll(event.getDeleted());
                return this;
            }
        }
    }
}

