/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.CancelableFuture;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;

public abstract class AsynchronousListOperation<T>
extends CancelableFuture<Collection<T>> {
    private final Repository repository;
    private final String uriText;
    private ListRemoteOperation listOp;

    public AsynchronousListOperation(Repository repository, String uriText) {
        this.repository = repository;
        this.uriText = uriText;
    }

    @Override
    protected String getJobTitle() {
        return MessageFormat.format(UIText.AsynchronousRefProposalProvider_FetchingRemoteRefsMessage, this.uriText);
    }

    @Override
    protected void prepareRun() throws InvocationTargetException {
        try {
            this.listOp = new ListRemoteOperation(this.repository, new URIish(this.uriText), Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"));
        }
        catch (URISyntaxException e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    protected void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        this.listOp.run(monitor);
        this.set(this.convert(this.listOp.getRemoteRefs()));
    }

    protected abstract Collection<T> convert(Collection<Ref> var1);

    @Override
    protected void done() {
        this.listOp = null;
    }
}

