/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import org.eclipse.core.runtime.Adapters;
import org.eclipse.egit.ui.internal.repository.BranchPropertySource;
import org.eclipse.egit.ui.internal.repository.RepositoryPropertySource;
import org.eclipse.egit.ui.internal.repository.RepositoryRemotePropertySource;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jgit.events.ConfigChangedEvent;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoryPropertySourceProvider
implements IPropertySourceProvider {
    private final PropertySheetPage myPage;
    private Object lastObject;
    private IPropertySource lastRepositorySource;
    private SourceType lastSourceType = SourceType.UNDEFINED;
    private ListenerHandle listenerHandle;
    private DisposeListener disposeListener;

    public RepositoryPropertySourceProvider(PropertySheetPage page) {
        this.myPage = page;
    }

    private void registerDisposal() {
        if (this.disposeListener != null) {
            return;
        }
        Control control = this.myPage.getControl();
        if (control == null) {
            return;
        }
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RepositoryPropertySourceProvider.this.removeListener();
            }
        };
        control.addDisposeListener(this.disposeListener);
    }

    private void removeListener() {
        ListenerHandle handle = this.listenerHandle;
        if (handle != null) {
            handle.remove();
        }
    }

    public IPropertySource getPropertySource(Object object) {
        if (object == this.lastObject) {
            return this.lastRepositorySource;
        }
        if (!(object instanceof RepositoryTreeNode)) {
            return null;
        }
        if (((RepositoryTreeNode)object).getRepository() == null) {
            return null;
        }
        this.registerDisposal();
        this.removeListener();
        RepositoryTreeNode node = (RepositoryTreeNode)object;
        this.listenerHandle = node.getRepository().getListenerList().addConfigChangedListener(new ConfigChangedListener(){

            public void onConfigChanged(ConfigChangedEvent event) {
                RepositoryPropertySourceProvider.this.lastObject = null;
                RepositoryPropertySourceProvider.this.myPage.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryPropertySourceProvider.this.myPage.setPropertySourceProvider((IPropertySourceProvider)RepositoryPropertySourceProvider.this);
                    }
                });
            }
        });
        if (node.getType() == RepositoryTreeNodeType.REPO) {
            this.lastObject = object;
            this.checkChangeType(SourceType.REPOSITORY);
            this.lastRepositorySource = new RepositoryPropertySource((Repository)node.getObject(), this.myPage);
            return this.lastRepositorySource;
        }
        if (node.getType() == RepositoryTreeNodeType.REMOTE) {
            this.lastObject = object;
            this.checkChangeType(SourceType.REMOTE);
            this.lastRepositorySource = new RepositoryRemotePropertySource(node.getRepository().getConfig(), (String)node.getObject(), this.myPage);
            return this.lastRepositorySource;
        }
        if (node.getType() == RepositoryTreeNodeType.FETCH || node.getType() == RepositoryTreeNodeType.PUSH) {
            return this.getPropertySource(node.getParent());
        }
        if (node.getType() == RepositoryTreeNodeType.REF) {
            this.lastObject = object;
            Ref ref = (Ref)node.getObject();
            if (ref.getName().startsWith("refs/heads/") || ref.getName().startsWith("refs/remotes/")) {
                this.checkChangeType(SourceType.BRANCH);
                Repository repository = (Repository)Adapters.adapt((Object)node, Repository.class);
                this.lastRepositorySource = new BranchPropertySource(repository, ref.getName(), this.myPage);
                return this.lastRepositorySource;
            }
            return null;
        }
        return null;
    }

    private void checkChangeType(SourceType type) {
        if (this.lastSourceType != type) {
            IToolBarManager mgr = this.myPage.getSite().getActionBars().getToolBarManager();
            boolean update = false;
            update |= mgr.remove("ChangeMode") != null;
            update |= mgr.remove("SingleValueToggle") != null;
            update |= mgr.remove("Edit") != null;
            if (update |= mgr.remove("EditBranch") != null) {
                mgr.update(false);
            }
        }
        this.lastSourceType = type;
    }

    private static enum SourceType {
        UNDEFINED,
        REPOSITORY,
        REMOTE,
        BRANCH;

    }
}

