/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.util.List;
import org.eclipse.emf.cdo.common.CDOCommonView;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.spi.common.AbstractQueryResult;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.concurrent.ConcurrentValue;

public abstract class AbstractQueryIterator<T>
extends AbstractQueryResult<T> {
    private static final int UNDEFINED_QUERY_ID = -1;
    private ConcurrentValue<Boolean> queryIDSet = new ConcurrentValue((Object)false);

    public AbstractQueryIterator(CDOView view, CDOQueryInfo queryInfo) {
        super((CDOCommonView)view, queryInfo, -1);
    }

    public void setQueryID(int queryID) {
        super.setQueryID(queryID);
        this.queryIDSet.set((Object)true);
    }

    public void waitForInitialization() throws InterruptedException {
        this.queryIDSet.acquire(new Object(){

            public int hashCode() {
                return 1;
            }

            public boolean equals(Object obj) {
                return Boolean.TRUE.equals(obj) || AbstractQueryIterator.this.isClosed();
            }
        });
    }

    public CDOView getView() {
        return (CDOView)super.getView();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (!this.isClosed()) {
            super.close();
            this.queryIDSet.reevaluate();
            InternalCDOSession session = (InternalCDOSession)this.getView().getSession();
            session.getSessionProtocol().cancelQuery(this.getQueryID());
        }
    }

    public abstract List<T> asList();

    public abstract T asValue();
}

