/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ValueSpecification;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.NamedElementImpl;
import org.eclipse.ocl.pivot.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.UnlimitedValue;

public abstract class TypedElementImpl
extends NamedElementImpl
implements TypedElement {
    public static final int TYPED_ELEMENT_FEATURE_COUNT = 8;
    public static final int TYPED_ELEMENT_OPERATION_COUNT = 3;
    protected static final boolean IS_MANY_EDEFAULT = false;
    protected static final boolean IS_REQUIRED_EDEFAULT = true;
    protected static final int IS_REQUIRED_EFLAG = 256;
    protected Type type;

    protected TypedElementImpl() {
        this.eFlags |= 0x100;
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.TYPED_ELEMENT;
    }

    @Override
    public boolean isIsRequired() {
        return (this.eFlags & 0x100) != 0;
    }

    @Override
    public Type getType() {
        if (this.type != null && this.type.eIsProxy()) {
            InternalEObject oldType = (InternalEObject)this.type;
            this.type = (Type)this.eResolveProxy(oldType);
            if (this.type != oldType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldType, (Object)this.type));
            }
        }
        return this.type;
    }

    public Type basicGetType() {
        return this.type;
    }

    @Override
    public void setType(Type newType) {
        Type oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public boolean CompatibleBody(ValueSpecification bodySpecification) {
        Boolean safe_conformsTo_source;
        @NonNull Executor executor = PivotUtil.getExecutor(this);
        @Nullable Type type = bodySpecification.getType();
        @NonNull Boolean conformsTo = type == null;
        if (conformsTo == Boolean.TRUE) {
            safe_conformsTo_source = null;
        } else {
            if (type == null) {
                throw new InvalidValueException("Null ''Type'' rather than ''OclVoid'' value required", new Object[0]);
            }
            @Nullable Type type_0 = this.getType();
            boolean conformsTo_0 = OclTypeConformsToOperation.INSTANCE.evaluate(executor, (Object)type, (Object)type_0);
            safe_conformsTo_source = conformsTo_0;
        }
        if (safe_conformsTo_source == null) {
            throw new InvalidValueException("Null body for 'pivot::TypedElement::CompatibleBody(ValueSpecification[1]) : Boolean[1]'", new Object[0]);
        }
        return safe_conformsTo_source;
    }

    @Override
    public void setIsRequired(boolean newIsRequired) {
        boolean oldIsRequired;
        boolean bl = oldIsRequired = (this.eFlags & 0x100) != 0;
        this.eFlags = newIsRequired ? (this.eFlags |= 0x100) : (this.eFlags &= 0xFFFFFEFF);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldIsRequired, newIsRequired));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return this.isIsRequired();
            }
            case 7: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setType((Type)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setType(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return (this.eFlags & 0x100) == 0;
            }
            case 7: {
                return this.type != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.CompatibleBody((ValueSpecification)arguments.get(0));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitTypedElement(this);
    }

    @Override
    public @NonNull TypeId getTypeId() {
        Type type2 = this.getType();
        return type2 != null ? type2.getTypeId() : TypeId.OCL_INVALID;
    }

    @Override
    public boolean isIsMany() {
        Type type = this.getType();
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            UnlimitedNaturalValue upperValue = collectionType.getUpperValue();
            return upperValue instanceof UnlimitedValue || upperValue.intValue() > 1;
        }
        return false;
    }
}

