/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MBindings;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class BindingProcessingAddon {
    private static final String[] DEFAULT_SCHEMES = new String[]{"org.eclipse.ui.defaultAcceleratorConfiguration"};
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    @Inject
    private ContextManager contextManager;
    @Inject
    private BindingTableManager bindingTables;
    @Inject
    @Optional
    private BindingManager bindingManager;
    @Inject
    private ECommandService commandService;
    @Inject
    private EBindingService bindingService;
    private EventHandler additionHandler;
    private EventHandler contextHandler;

    @PostConstruct
    public void init() {
        Scheme activeScheme;
        String[] schemes = DEFAULT_SCHEMES;
        if (this.bindingManager != null && (activeScheme = this.bindingManager.getActiveScheme()) != null) {
            schemes = this.getSchemeIds(activeScheme.getId());
        }
        this.bindingTables.setActiveSchemes(schemes);
        this.defineBindingTables();
        this.activateContexts(this.application);
        this.registerModelListeners();
    }

    private final String[] getSchemeIds(String schemeId) {
        ArrayList<String> strings = new ArrayList<String>();
        while (schemeId != null) {
            strings.add(schemeId);
            try {
                schemeId = this.getScheme(schemeId).getParentId();
            }
            catch (NotDefinedException notDefinedException) {
                return new String[0];
            }
        }
        return strings.toArray(new String[strings.size()]);
    }

    private final Scheme getScheme(String schemeId) {
        return this.bindingManager.getScheme(schemeId);
    }

    private void activateContexts(Object me) {
        if (me instanceof MBindings) {
            MContext contextModel = (MContext)me;
            MBindings container = (MBindings)me;
            List bindingContexts = container.getBindingContexts();
            IEclipseContext context = contextModel.getContext();
            if (context != null && !bindingContexts.isEmpty()) {
                EContextService cs = (EContextService)context.get(EContextService.class);
                for (MBindingContext element : bindingContexts) {
                    cs.activateContext(element.getElementId());
                }
            }
        }
        if (me instanceof MElementContainer) {
            List children = ((MElementContainer)me).getChildren();
            for (MUIElement e : children) {
                this.activateContexts(e);
            }
        }
    }

    private void defineBindingTables() {
        if (Policy.DEBUG_CMDS) {
            WorkbenchSWTActivator.trace("/trace/commands", "Initialize binding tables from model", null);
        }
        for (MBindingTable bindingTable : this.application.getBindingTables()) {
            this.defineBindingTable(bindingTable);
        }
    }

    private void defineBindingTable(MBindingTable bindingTable) {
        Assert.isNotNull((Object)bindingTable.getBindingContext(), (String)("Binding context referred to by the binding table \"" + bindingTable.getElementId() + "\""));
        Assert.isNotNull((Object)bindingTable.getBindingContext().getElementId(), (String)("Element ID of binding table \"" + bindingTable.getElementId() + "\"."));
        Context bindingContext = this.contextManager.getContext(bindingTable.getBindingContext().getElementId());
        BindingTable table = this.bindingTables.getTable(bindingTable.getBindingContext().getElementId());
        if (table == null) {
            table = new BindingTable(bindingContext);
            this.bindingTables.addTable(table);
        }
        for (MKeyBinding binding : bindingTable.getBindings()) {
            this.defineBinding(table, bindingContext, binding);
        }
    }

    private void defineBinding(BindingTable bindingTable, Context bindingContext, MKeyBinding binding) {
        Binding keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
        if (keyBinding != null && !binding.getTags().contains("deleted")) {
            bindingTable.addBinding(keyBinding);
        }
    }

    private Binding createBinding(Context bindingContext, MCommand cmdModel, List<MParameter> modelParms, String keySequence, MKeyBinding binding) {
        Binding keyBinding = null;
        if (binding.getTransientData().get("binding") != null) {
            try {
                return (Binding)binding.getTransientData().get("binding");
            }
            catch (ClassCastException classCastException) {
                System.err.println("Invalid type stored in transient data with the key binding");
                return null;
            }
        }
        if (cmdModel == null) {
            Activator.log((int)1, (String)("binding with no command: " + binding));
            return null;
        }
        HashMap<String, String> parameters = null;
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = this.commandService.createCommand(cmdModel.getElementId(), parameters);
        TriggerSequence sequence = null;
        sequence = this.bindingService.createSequence(keySequence);
        if (cmd == null) {
            System.err.println("Failed to find command for binding: " + binding);
        } else if (sequence == null) {
            System.err.println("Failed to map binding: " + binding);
        } else {
            try {
                String schemeId = null;
                String locale = null;
                String platform = null;
                HashMap<String, String> attrs = new HashMap<String, String>();
                List tags = binding.getTags();
                for (String tag : tags) {
                    if (tag.startsWith("schemeId")) {
                        schemeId = tag.substring(9);
                        attrs.put("schemeId", schemeId);
                        continue;
                    }
                    if (tag.startsWith("locale")) {
                        locale = tag.substring(7);
                        attrs.put("locale", locale);
                        continue;
                    }
                    if (tag.startsWith("platform")) {
                        platform = tag.substring(9);
                        attrs.put("platform", platform);
                        continue;
                    }
                    if (!tag.startsWith("type")) continue;
                    attrs.put("type", "user");
                }
                keyBinding = this.bindingService.createBinding(sequence, cmd, bindingContext.getId(), attrs);
                binding.getTransientData().put("binding", keyBinding);
            }
            catch (IllegalArgumentException e) {
                if (Policy.DEBUG_MENUS) {
                    WorkbenchSWTActivator.trace("/trace/menus", "failed to create: " + binding, e);
                }
                return null;
            }
        }
        return keyBinding;
    }

    private void updateBinding(MKeyBinding binding, boolean add, Object eObj) {
        Object parentObj = ((EObject)binding).eContainer();
        if (!(parentObj instanceof MBindingTable) && eObj instanceof MBindingTable) {
            parentObj = eObj;
        }
        if (parentObj == null) {
            return;
        }
        MBindingTable bt = (MBindingTable)parentObj;
        Context bindingContext = this.contextManager.getContext(bt.getBindingContext().getElementId());
        BindingTable table = this.bindingTables.getTable(bindingContext.getId());
        if (table == null) {
            Activator.log((int)1, (String)("Trying to create '" + binding + "' without binding table " + bindingContext.getId()));
            return;
        }
        Binding keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
        if (keyBinding != null) {
            if (add) {
                table.addBinding(keyBinding);
            } else {
                table.removeBinding(keyBinding);
            }
        }
    }

    @PreDestroy
    public void dispose() {
        this.unregisterModelListeners();
    }

    private void registerModelListeners() {
        this.additionHandler = event -> {
            Object elementObj = event.getProperty("ChangedElement");
            if (elementObj instanceof MApplication) {
                if (UIEvents.isADD((Event)event)) {
                    for (Object newObj1 : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                        if (!(newObj1 instanceof MBindingTable)) continue;
                        MBindingTable bt = (MBindingTable)newObj1;
                        Context bindingContext = this.contextManager.getContext(bt.getBindingContext().getElementId());
                        BindingTable table = new BindingTable(bindingContext);
                        this.bindingTables.addTable(table);
                        List bindings = bt.getBindings();
                        for (MKeyBinding binding1 : bindings) {
                            Binding keyBinding = this.createBinding(bindingContext, binding1.getCommand(), binding1.getParameters(), binding1.getKeySequence(), binding1);
                            if (keyBinding == null) continue;
                            table.addBinding(keyBinding);
                        }
                    }
                }
            } else if (elementObj instanceof MBindingTable) {
                if (UIEvents.isADD((Event)event)) {
                    for (Object newObj2 : UIEvents.asIterable((Event)event, (String)"NewValue")) {
                        if (!(newObj2 instanceof MKeyBinding)) continue;
                        MKeyBinding binding2 = (MKeyBinding)newObj2;
                        this.updateBinding(binding2, true, elementObj);
                    }
                } else if (UIEvents.isREMOVE((Event)event)) {
                    for (Object oldObj1 : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                        if (!(oldObj1 instanceof MKeyBinding)) continue;
                        MKeyBinding binding3 = (MKeyBinding)oldObj1;
                        this.updateBinding(binding3, false, elementObj);
                    }
                }
            } else if (elementObj instanceof MKeyBinding) {
                MKeyBinding binding4 = (MKeyBinding)elementObj;
                String attrName = (String)event.getProperty("AttName");
                if (UIEvents.isSET((Event)event)) {
                    Object oldObj2 = event.getProperty("OldValue");
                    if ("command".equals(attrName)) {
                        MKeyBinding oldBinding1 = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding4));
                        oldBinding1.setCommand((MCommand)oldObj2);
                        this.updateBinding(oldBinding1, false, ((EObject)binding4).eContainer());
                        this.updateBinding(binding4, true, null);
                    } else if ("keySequence".equals(attrName)) {
                        MKeyBinding oldBinding2 = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding4));
                        oldBinding2.setKeySequence((String)oldObj2);
                        this.updateBinding(oldBinding2, false, ((EObject)binding4).eContainer());
                        this.updateBinding(binding4, true, null);
                    }
                } else if ("parameters".equals(attrName)) {
                    if (UIEvents.isADD((Event)event)) {
                        Object newObj3 = event.getProperty("NewValue");
                        MKeyBinding oldBinding3 = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding4));
                        if ("ADD_MANY".equals(event.getProperty("EventType"))) {
                            oldBinding3.getParameters().removeAll((Collection)newObj3);
                        } else {
                            oldBinding3.getParameters().remove(newObj3);
                        }
                        this.updateBinding(oldBinding3, false, ((EObject)binding4).eContainer());
                        this.updateBinding(binding4, true, null);
                    } else if (UIEvents.isREMOVE((Event)event)) {
                        Object oldObj3 = event.getProperty("OldValue");
                        MKeyBinding oldBinding4 = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding4));
                        if ("REMOVE_MANY".equals(event.getProperty("EventType"))) {
                            Collection parms = (Collection)oldObj3;
                            oldBinding4.getParameters().addAll(parms);
                        } else {
                            oldBinding4.getParameters().add((MParameter)oldObj3);
                        }
                        this.updateBinding(oldBinding4, false, ((EObject)binding4).eContainer());
                        this.updateBinding(binding4, true, null);
                    }
                } else if ("tags".equals(attrName)) {
                    List tags = binding4.getTags();
                    if (tags.contains("deleted")) {
                        this.updateBinding(binding4, false, elementObj);
                    } else {
                        this.updateBinding(binding4, true, elementObj);
                    }
                }
            }
        };
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/BindingTableContainer/bindingTables/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/BindingTable/bindings/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/KeyBinding/command/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/KeyBinding/parameters/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/commands/KeySequence/keySequence/*", this.additionHandler);
        this.broker.subscribe("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*", this.additionHandler);
        this.contextHandler = event -> {
            Object elementObj = event.getProperty("ChangedElement");
            Object newObj = event.getProperty("NewValue");
            if ("SET".equals(event.getProperty("EventType")) && newObj instanceof IEclipseContext) {
                this.activateContexts(elementObj);
            }
        };
        this.broker.subscribe("org/eclipse/e4/ui/model/ui/Context/context/*", this.contextHandler);
    }

    private void unregisterModelListeners() {
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.contextHandler);
    }
}

