/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dnd;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.swt.dnd.Transfer;

public class TemplateTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    public TemplateTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)TemplateTransfer.getInstance());
    }

    protected Request createTargetRequest() {
        CreateRequest request = new CreateRequest();
        request.setFactory(this.getFactory(TemplateTransfer.getInstance().getTemplate()));
        return request;
    }

    protected final CreateRequest getCreateRequest() {
        return (CreateRequest)this.getTargetRequest();
    }

    protected CreationFactory getFactory(Object template) {
        if (template instanceof CreationFactory) {
            return (CreationFactory)template;
        }
        if (template instanceof Class) {
            return new SimpleFactory((Class)template);
        }
        return null;
    }

    protected void handleDragOperationChanged() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOperationChanged();
    }

    protected void handleDragOver() {
        this.getCurrentEvent().detail = 1;
        this.getCurrentEvent().feedback = 24;
        super.handleDragOver();
    }

    protected void handleDrop() {
        super.handleDrop();
        this.selectAddedObject();
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getNewObject();
        if (model == null) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().forceFocus();
        Object editpart = viewer.getEditPartRegistry().get(model);
        if (editpart instanceof EditPart) {
            this.getViewer().flush();
            viewer.select((EditPart)editpart);
        }
    }

    protected void updateTargetRequest() {
        CreateRequest request = this.getCreateRequest();
        request.setLocation(this.getDropLocation());
    }
}

