/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.customize.DefaultEntryPage;
import org.eclipse.gef.ui.palette.customize.DrawerEntryPage;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.eclipse.gef.ui.palette.customize.PaletteDrawerFactory;
import org.eclipse.gef.ui.palette.customize.PaletteEntryFactory;
import org.eclipse.gef.ui.palette.customize.PaletteSeparatorFactory;
import org.eclipse.gef.ui.palette.customize.PaletteStackFactory;

public abstract class PaletteCustomizer {
    protected boolean canAdd(PaletteContainer container, PaletteEntry entry) {
        return container.getUserModificationPermission() == 15 && container.acceptsType(entry.getType());
    }

    public boolean canDelete(PaletteEntry entry) {
        return entry.getUserModificationPermission() == 15;
    }

    public boolean canMoveDown(PaletteEntry entry) {
        PaletteContainer parent = entry.getParent();
        int parentPermission = parent.getUserModificationPermission();
        if (parentPermission < 7) {
            return false;
        }
        if (parent.getChildren().indexOf(entry) + 1 != parent.getChildren().size()) {
            return true;
        }
        if (parentPermission != 15 || parent.getParent() == null) {
            return false;
        }
        if (this.canAdd(parent.getParent(), entry)) {
            return true;
        }
        List children = parent.getParent().getChildren();
        int parentIndex = children.indexOf(parent);
        PaletteEntry parentSibling = null;
        int i = parentIndex + 1;
        while (i < children.size()) {
            parentSibling = (PaletteEntry)children.get(i);
            if (parentSibling instanceof PaletteContainer && this.canAdd((PaletteContainer)parentSibling, entry)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canMoveUp(PaletteEntry entry) {
        PaletteContainer parent = entry.getParent();
        int parentPermission = parent.getUserModificationPermission();
        if (parentPermission < 7) {
            return false;
        }
        if (parent.getChildren().indexOf(entry) != 0) {
            return true;
        }
        if (parentPermission != 15 || parent.getParent() == null) {
            return false;
        }
        if (this.canAdd(parent.getParent(), entry)) {
            return true;
        }
        List children = parent.getParent().getChildren();
        int parentIndex = children.indexOf(parent);
        PaletteEntry parentSibling = null;
        int i = parentIndex - 1;
        while (i >= 0) {
            parentSibling = (PaletteEntry)children.get(i);
            if (parentSibling instanceof PaletteContainer && this.canAdd((PaletteContainer)parentSibling, entry)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public List getNewEntryFactories() {
        ArrayList<PaletteEntryFactory> list = new ArrayList<PaletteEntryFactory>(4);
        list.add(new PaletteSeparatorFactory());
        list.add(new PaletteStackFactory());
        list.add(new PaletteDrawerFactory());
        return list;
    }

    public EntryPage getPropertiesPage(PaletteEntry entry) {
        if (entry instanceof PaletteDrawer) {
            return new DrawerEntryPage();
        }
        return new DefaultEntryPage();
    }

    public void performDelete(PaletteEntry entry) {
        entry.getParent().remove(entry);
    }

    public void performMoveDown(PaletteEntry entry) {
        PaletteContainer parent = entry.getParent();
        if (!parent.moveDown(entry)) {
            PaletteEntry parentSibling = null;
            PaletteContainer newParent = parent.getParent();
            int insertionIndex = 0;
            if (this.canAdd(newParent, entry)) {
                insertionIndex = newParent.getChildren().indexOf(parent) + 1;
            } else {
                List parents = newParent.getChildren();
                int i = parents.indexOf(parent) + 1;
                while (i < parents.size()) {
                    parentSibling = (PaletteEntry)parents.get(i);
                    if (parentSibling instanceof PaletteContainer && this.canAdd(newParent = (PaletteContainer)parentSibling, entry)) break;
                    ++i;
                }
            }
            parent.remove(entry);
            newParent.add(insertionIndex, entry);
        }
    }

    public void performMoveUp(PaletteEntry entry) {
        PaletteContainer parent = entry.getParent();
        if (!parent.moveUp(entry)) {
            PaletteEntry parentSibling = null;
            PaletteContainer newParent = parent.getParent();
            int insertionIndex = 0;
            if (this.canAdd(newParent, entry)) {
                insertionIndex = newParent.getChildren().indexOf(parent);
            } else {
                List parents = newParent.getChildren();
                int i = parents.indexOf(parent) - 1;
                while (i >= 0) {
                    parentSibling = (PaletteEntry)parents.get(i);
                    if (parentSibling instanceof PaletteContainer && this.canAdd(newParent = (PaletteContainer)parentSibling, entry)) {
                        insertionIndex = newParent.getChildren().size();
                        break;
                    }
                    --i;
                }
            }
            parent.remove(entry);
            newParent.add(insertionIndex, entry);
        }
    }

    public abstract void revertToSaved();

    public abstract void save();
}

