/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.modelelement;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.creation.StyleSheetFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.DiagramStyleSheetObservableList;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.ModelStyleSheetObservableList;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.provider.CSSStyleSheetContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.provider.CSSStyleSheetLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.CSSClassContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.ModelStyleSheets;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsPackage;
import org.eclipse.papyrus.infra.gmfdiag.properties.modelelement.CustomStyleModelElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.creation.StringEditionFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;

public class CSSModelElement
extends CustomStyleModelElement {
    public CSSModelElement(View source, DataContextElement context) {
        super(source, context);
    }

    public CSSModelElement(View source, EditingDomain domain, DataContextElement element) {
        super(source, domain, element);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        if ("css_stylesheets".equals(propertyPath)) {
            return new StyleSheetFactory((View)this.source);
        }
        if ("modelStyleSheets".equals(propertyPath)) {
            return new StyleSheetFactory((View)this.source);
        }
        if ("cssClass".equals(propertyPath)) {
            StringEditionFactory factory = new StringEditionFactory();
            factory.setContentProvider(this.getContentProvider(propertyPath));
            return factory;
        }
        return super.getValueFactory(propertyPath);
    }

    public IObservable doGetObservable(String propertyPath) {
        if ("css_stylesheets".equals(propertyPath) && this.source instanceof View) {
            return new DiagramStyleSheetObservableList((View)this.source, this.domain, propertyPath);
        }
        if ("modelStyleSheets".equals(propertyPath)) {
            Resource notationResource = this.source.eResource();
            if (notationResource == null) {
                return null;
            }
            Object modelStyleSheetObject = EcoreUtil.getObjectByType((Collection)notationResource.getContents(), (EClassifier)StylesheetsPackage.Literals.MODEL_STYLE_SHEETS);
            ModelStyleSheets modelStyleSheetsSource = modelStyleSheetObject instanceof ModelStyleSheets ? (ModelStyleSheets)modelStyleSheetObject : StylesheetsFactory.eINSTANCE.createModelStyleSheets();
            return new ModelStyleSheetObservableList(notationResource, (List<?>)modelStyleSheetsSource.getStylesheets(), (TransactionalEditingDomain)this.domain, (EObject)modelStyleSheetsSource, (EStructuralFeature)StylesheetsPackage.Literals.MODEL_STYLE_SHEETS__STYLESHEETS);
        }
        return super.doGetObservable(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if ("css_stylesheets".equals(propertyPath)) {
            return new CSSStyleSheetLabelProvider();
        }
        if ("modelStyleSheets".equals(propertyPath)) {
            return new CSSStyleSheetLabelProvider();
        }
        return super.getLabelProvider(propertyPath);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals("css_stylesheets")) {
            return new CSSStyleSheetContentProvider(this.source);
        }
        if (propertyPath.equals("modelStyleSheets")) {
            return new CSSStyleSheetContentProvider(this.source);
        }
        if (propertyPath.equals("cssClass")) {
            EObject semanticElement;
            Diagram diagram = ((View)this.source).getDiagram();
            if (diagram instanceof CSSDiagram && (semanticElement = ((View)this.source).getElement()) != null) {
                String elementName = this.source instanceof Diagram ? "*" : semanticElement.eClass().getName();
                return new CSSClassContentProvider(elementName, ((CSSDiagram)diagram).getEngine());
            }
            return null;
        }
        return null;
    }

    public boolean isUnique(String propertyPath) {
        if ("css_stylesheets".equals(propertyPath)) {
            return true;
        }
        if ("modelStyleSheets".equals(propertyPath)) {
            return true;
        }
        return super.isUnique(propertyPath);
    }
}

