/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class AutoResizeHelper {
    protected final ILayer layer;
    protected final IConfigRegistry configRegistry;
    protected Rectangle totalArea;
    protected Rectangle prevArea = null;
    protected IClientAreaProvider originalClientAreaProvider;
    protected volatile boolean resizedOnPrinting = true;
    protected ILayerListener resizeListener = new ILayerListener(){

        @Override
        public void handleLayerEvent(ILayerEvent event) {
            if (!AutoResizeHelper.this.resizedOnPrinting && (event instanceof RowResizeEvent || event instanceof ColumnResizeEvent)) {
                AutoResizeHelper.this.resizedOnPrinting = true;
            }
        }
    };
    protected IClientAreaProvider clientAreaProvider = new IClientAreaProvider(){

        @Override
        public Rectangle getClientArea() {
            return AutoResizeHelper.this.totalArea;
        }
    };

    private AutoResizeHelper(ILayer layer, IConfigRegistry configRegistry) {
        this.layer = layer;
        this.configRegistry = configRegistry;
        this.originalClientAreaProvider = layer.getClientAreaProvider();
        this.calculateTotalArea();
    }

    public static void autoResize(ILayer layer, IConfigRegistry configRegistry) {
        AutoResizeHelper helper = new AutoResizeHelper(layer, configRegistry);
        helper.init();
        try {
            while (helper.resizedOnPrinting) {
                helper.resizedOnPrinting = false;
                helper.calculateTotalArea();
                helper.paintInMemory();
                helper.prevArea = helper.totalArea;
            }
        }
        finally {
            helper.restore();
        }
    }

    protected void paintInMemory() {
        Image tmpImage = new Image((Device)Display.getDefault(), 100, 100);
        GC tempGC = new GC((Drawable)tmpImage);
        try {
            if (this.prevArea != null) {
                Rectangle bottom = new Rectangle(0, this.prevArea.height, this.totalArea.width, this.totalArea.height - this.prevArea.height);
                if (bottom.height > 0) {
                    this.paintLayer(tempGC, bottom);
                }
                Rectangle right = new Rectangle(this.prevArea.width, 0, this.totalArea.width - this.prevArea.width, this.totalArea.height);
                if (right.width > 0) {
                    this.paintLayer(tempGC, right);
                }
            } else {
                this.paintLayer(tempGC, this.totalArea);
            }
        }
        finally {
            tempGC.dispose();
            tmpImage.dispose();
        }
    }

    protected void paintLayer(GC gc, Rectangle printBounds) {
        this.layer.getLayerPainter().paintLayer(this.layer, gc, 0, 0, printBounds, this.configRegistry);
    }

    protected void calculateTotalArea() {
        this.totalArea = new Rectangle(0, 0, this.layer.getWidth(), this.layer.getHeight());
    }

    protected void init() {
        this.layer.addLayerListener(this.resizeListener);
        this.layer.setClientAreaProvider(this.clientAreaProvider);
        this.layer.doCommand(new TurnViewportOffCommand());
        this.layer.doCommand(new PrintEntireGridCommand());
    }

    protected void restore() {
        this.layer.removeLayerListener(this.resizeListener);
        this.layer.setClientAreaProvider(this.originalClientAreaProvider);
        this.layer.doCommand(new TurnViewportOnCommand());
    }
}

