/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.resize.command.RowSizeConfigurationCommand;

public class RowSizeConfigurationCommandHandler
implements ILayerCommandHandler<RowSizeConfigurationCommand> {
    private final DataLayer dataLayer;

    public RowSizeConfigurationCommandHandler(DataLayer dataLayer) {
        this.dataLayer = dataLayer;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, RowSizeConfigurationCommand command) {
        if (command.label == null) {
            if (command.newRowHeight == null) {
                this.dataLayer.setRowPercentageSizing(true);
            } else {
                this.dataLayer.setDefaultRowHeight(command.newRowHeight);
            }
        } else {
            int i = 0;
            while (i < this.dataLayer.getRowCount()) {
                if (this.dataLayer.getConfigLabelsByPosition(0, i).hasLabel(command.label)) {
                    if (command.newRowHeight == null) {
                        this.dataLayer.setRowPercentageSizing(i, true);
                    } else if (command.percentageSizing) {
                        this.dataLayer.setRowHeightPercentageByPosition(i, command.newRowHeight);
                    } else {
                        this.dataLayer.setRowHeightByPosition(i, command.newRowHeight);
                    }
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public Class<RowSizeConfigurationCommand> getCommandClass() {
        return RowSizeConfigurationCommand.class;
    }
}

