/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.resource.ShardResourceHelper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters;
import org.eclipse.papyrus.infra.services.controlmode.commands.AbstractControlCommand;
import org.eclipse.papyrus.infra.services.controlmode.messages.Messages;

public class BasicControlCommand
extends AbstractControlCommand {
    private static final String RESOURCE_ERROR = Messages.getString("BasicControlCommand.resource.error");
    private static final String CONTROL_COMMAND_TITLE = Messages.getString("BasicControlCommand.command.title");

    public BasicControlCommand(ControlModeRequest request) {
        super(CONTROL_COMMAND_TITLE, Collections.singletonList(WorkspaceSynchronizer.getFile((Resource)request.getTargetObject().eResource())), request);
    }

    public boolean canExecute() {
        return super.canExecute() && this.getObjectToControl() != null && !this.getObjectToControl().eIsProxy();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        ModelSet currentResourceSet = this.getRequest().getModelSet();
        Resource resource = currentResourceSet.getResource(this.getNewURI(), false);
        if (resource == null) {
            throw new ExecutionException(RESOURCE_ERROR);
        }
        EObject objectToControl = this.getObjectToControl();
        if (objectToControl != null && objectToControl.eResource() != null) {
            objectToControl.eResource().setModified(true);
        }
        resource.getContents().add((Object)objectToControl);
        if (ControlModeRequestParameters.isCreateShard(this.getRequest())) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (ShardResourceHelper helper = new ShardResourceHelper(objectToControl);){
                helper.setShard(true);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return CommandResult.newOKCommandResult((Object)resource);
    }

    public EObject getObjectToControl() {
        return this.getRequest().getTargetObject();
    }

    public URI getNewURI() {
        return this.getRequest().getNewURI();
    }
}

