/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.ui.creation;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintEngine;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.internal.ui.messages.Messages;
import org.eclipse.papyrus.infra.properties.ui.creation.CreationContext;
import org.eclipse.papyrus.infra.properties.ui.creation.EditionDialog;
import org.eclipse.papyrus.infra.properties.ui.runtime.PropertiesRuntime;
import org.eclipse.papyrus.infra.widgets.creation.IAtomicOperationExecutor;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.swt.widgets.Control;

public class PropertyEditorFactory
implements ReferenceValueFactory {
    public Object createObject(Control widget, Object context) {
        return null;
    }

    protected Object createObject(Control widget, Object context, Object source) {
        if (source == null) {
            return null;
        }
        StructuredSelection selection = new StructuredSelection(source);
        ConstraintEngine<View> constraintEngine = PropertiesRuntime.getConstraintEngine();
        Set views = constraintEngine.getDisplayUnits((Object)selection);
        if (!views.isEmpty()) {
            CreationContext creationContext = this.getCreationContext(context);
            creationContext.pushCreatedElement(source);
            try {
                Object object = this.doEdit(widget, source, views, this.getCreationDialogTitle());
                return object;
            }
            finally {
                creationContext.popCreatedElement(source);
            }
        }
        return source;
    }

    protected CreationContext getCreationContext(Object element) {
        return CreationContext.NULL;
    }

    public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
        return objectsToValidate;
    }

    public boolean canEdit() {
        return true;
    }

    public Object edit(Control widget, Object source) {
        StructuredSelection selection = new StructuredSelection(source);
        ConstraintEngine<View> constraintEngine = PropertiesRuntime.getConstraintEngine();
        Set views = constraintEngine.getDisplayUnits((Object)selection);
        if (!views.isEmpty()) {
            return this.doEdit(widget, source, views, this.getEditionDialogTitle(source));
        }
        return source;
    }

    protected Object doEdit(Control widget, Object source, Set<View> views, String dialogTitle) {
        EditionDialog dialog = new EditionDialog(widget.getShell(), true);
        dialog.setTitle(dialogTitle);
        dialog.setViews(views);
        dialog.setInput(source);
        if (dialog.open() != 0) {
            this.handleEditCancelled(widget, source);
            return null;
        }
        return source;
    }

    protected void handleEditCancelled(Control widget, Object source) {
    }

    public boolean canCreateObject() {
        return false;
    }

    public String getCreationDialogTitle() {
        return Messages.PropertyEditorFactory_CreateANewElement;
    }

    public String getEditionDialogTitle(Object objectToEdit) {
        return "Edit an element";
    }

    public IAtomicOperationExecutor getOperationExecutor(Object context) {
        IAtomicOperationExecutor result = context instanceof IAdaptable ? (IAtomicOperationExecutor)((IAdaptable)context).getAdapter(IAtomicOperationExecutor.class) : (IAtomicOperationExecutor)Platform.getAdapterManager().getAdapter(context, IAtomicOperationExecutor.class);
        if (result == null) {
            result = IAtomicOperationExecutor.DEFAULT;
        }
        return result;
    }
}

