/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class SlotLabelParser
implements ISemanticParser {
    public String getEditString(IAdaptable element, int flags) {
        return this.getPrintString(element, flags);
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return ParserEditStatus.UNEDITABLE_STATUS;
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        String result = "";
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject instanceof Slot) {
            Slot slot = (Slot)eObject;
            result = "<UNDEFINED>";
            if (slot.getDefiningFeature() != null) {
                result = slot.getDefiningFeature().getName();
                if (!slot.getValues().isEmpty()) {
                    String values = "";
                    Iterator iter = slot.getValues().iterator();
                    while (iter.hasNext()) {
                        ValueSpecification currentSpecification = (ValueSpecification)iter.next();
                        String currentValue = currentSpecification.stringValue();
                        if (currentSpecification instanceof InstanceValue && ((InstanceValue)currentSpecification).getInstance() != null) {
                            currentValue = ((InstanceValue)currentSpecification).getInstance().getName();
                        }
                        values = String.valueOf(values) + currentValue;
                        if (!iter.hasNext()) continue;
                        result = String.valueOf(result) + ", ";
                    }
                    result = String.valueOf(result) + ": " + values;
                }
            }
        }
        return result;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getSlot_DefiningFeature().equals(feature);
        }
        return false;
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }

    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        semanticElementsBeingParsed.add(element);
        return semanticElementsBeingParsed;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }
}

