/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.resources;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;

public final class LoadAndSaveOptionsUtils {
    private static final Map<Object, Object> SAVE_OPTIONS = new HashMap<Object, Object>();
    private static final Map<Object, Object> LOAD_OPTIONS;

    static {
        SAVE_OPTIONS.put("URI_HANDLER", (Object)new PapyrusURIHandler());
        SAVE_OPTIONS.put("ENCODING", "UTF-8");
        SAVE_OPTIONS.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        SAVE_OPTIONS.put("LINE_DELIMITER", "");
        SAVE_OPTIONS.put("KEEP_DEFAULT_CONTENT", Boolean.TRUE);
        SAVE_OPTIONS.put("SAVE_TYPE_INFORMATION", Boolean.TRUE);
        SAVE_OPTIONS.put("USE_XMI_TYPE", Boolean.TRUE);
        LOAD_OPTIONS = new HashMap<Object, Object>();
        LOAD_OPTIONS.put("DEFER_ATTACHMENT", Boolean.TRUE);
        LOAD_OPTIONS.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        LOAD_OPTIONS.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
        LOAD_OPTIONS.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        LOAD_OPTIONS.put("USE_PACKAGE_NS_URI_AS_LOCATION", Boolean.FALSE);
        LOAD_OPTIONS.put("URI_HANDLER", (Object)new PapyrusURIHandler());
    }

    private LoadAndSaveOptionsUtils() {
    }

    public static final Map<Object, Object> getLoadOptions() {
        return new HashMap<Object, Object>(LOAD_OPTIONS);
    }

    public static final Map<Object, Object> getSaveOptions() {
        return new HashMap<Object, Object>(SAVE_OPTIONS);
    }

    protected static class PapyrusURIHandler
    extends URIHandlerImpl.PlatformSchemeAware {
        protected PapyrusURIHandler() {
        }

        public URI deresolve(URI uri) {
            if (uri.isPlatformResource()) {
                String platformString = uri.toPlatformString(true);
                String fragment = uri.fragment();
                URI pluginURI = URI.createPlatformPluginURI((String)platformString, (boolean)true);
                pluginURI = pluginURI.appendFragment(fragment);
                return pluginURI;
            }
            return super.deresolve(uri);
        }

        public URI resolve(URI uri) {
            if (uri.isPlatformPlugin()) {
                String platformString = uri.toPlatformString(true);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                if (resource != null) {
                    String fragment = uri.fragment();
                    URI resourceURI = URI.createPlatformResourceURI((String)platformString, (boolean)true);
                    resourceURI = resourceURI.appendFragment(fragment);
                    return resourceURI;
                }
            }
            return super.resolve(uri);
        }
    }
}

