/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.constraints;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.constraints.AbstractConstraint;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.tools.util.ClassLoaderHelper;
import org.eclipse.papyrus.uml.properties.datatype.DataTypeObservableValue;

public class IsDataTypeConstraint
extends AbstractConstraint {
    public static final String DATATYPE_PROPERTY = "datatype";
    private EDataType dataType;

    protected void setDescriptor(ConstraintDescriptor descriptor) {
        String dataTypeClassName = this.getValue(DATATYPE_PROPERTY);
        this.dataType = (EDataType)ClassLoaderHelper.newInstance((String)dataTypeClassName, EDataType.class);
    }

    public boolean match(Object selection) {
        if (this.dataType == null) {
            return false;
        }
        if (selection instanceof DataTypeObservableValue) {
            DataTypeObservableValue observer = (DataTypeObservableValue)selection;
            return observer.getValueType() == this.dataType;
        }
        return false;
    }

    protected boolean equivalent(Constraint constraint) {
        if (constraint == null) {
            return false;
        }
        if (constraint instanceof IsDataTypeConstraint) {
            return ((IsDataTypeConstraint)constraint).dataType == this.dataType;
        }
        return false;
    }
}

