/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.modelresource;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.commands.AddToResourceCommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.internationalization.Activator;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationAnnotationResourceUtils;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationPreferenceModelProviderManager;

public class InternationalizationPreferenceModel
extends EMFLogicalModel
implements IModel {
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.internationalization.InternationalizationPreferenceModel";
    public static final String PROPERTY_PRIVATE_RESOURCE_URI = "privateResourceURI";
    public static final String PROPERTY_SHARED_RESOURCE_URI = "sharedResourceURI";
    public static final String PROPERTY_LEGACY_MODE = "legacyMode";
    public static final String INTERNATIONALIZATION_PREFERENCE_FILE_EXTENSION = "internationalization";
    public static final String NOTATION_FILE_EXTENSION = "notation";
    private InternationalizationPreferenceModelProviderManager providerManager;
    private final PropertyChangeSupport bean = new PropertyChangeSupport((Object)this);
    private Adapter internationalizationPreferenceModelStorageAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (InternationalizationPreferenceModel.this.getResources().contains(msg.getNotifier())) {
                switch (msg.getFeatureID(Resource.class)) {
                    case 2: {
                        InternationalizationPreferenceModel.this.invalidateLegacyMode();
                    }
                }
            }
        }
    };
    private volatile Boolean legacyMode;

    public void init(ModelSet modelSet) {
        super.init(modelSet);
        this.providerManager = new InternationalizationPreferenceModelProviderManager(modelSet);
    }

    public void unload() {
        if (this.providerManager != null) {
            this.providerManager.dispose();
            this.providerManager = null;
        }
        this.getResources().forEach(res -> {
            boolean bl = res.eAdapters().remove((Object)this.internationalizationPreferenceModelStorageAdapter);
        });
        super.unload();
    }

    public boolean isRelatedResource(Resource resource) {
        boolean result = false;
        if (resource != null) {
            result = resource == this.getResource() ? true : resource.getURI().equals(this.getSharedResourceURI()) || resource.getURI().equals(this.getPrivateResourceURI());
        }
        return result;
    }

    public ModelSet getModelManager() {
        return super.getModelManager();
    }

    protected void configureResource(Resource resourceToConfigure) {
        super.configureResource(resourceToConfigure);
        if (resourceToConfigure != null) {
            resourceToConfigure.eAdapters().add((Object)this.internationalizationPreferenceModelStorageAdapter);
        }
    }

    public void loadModel(URI uriWithoutExtension) {
        URI sashModelURI;
        this.resourceURI = sashModelURI = this.getInternationalizationPreferenceModelURI(uriWithoutExtension);
        try {
            super.loadModel(sashModelURI.trimFileExtension());
            this.loadInternationalizationPreference(sashModelURI);
        }
        catch (Exception ex) {
            Resource resource = this.getModelManager().getResource(sashModelURI, false);
            if (resource != null) {
                resource.unload();
                resource.getResourceSet().getResources().remove((Object)resource);
            }
            this.createModel(uriWithoutExtension);
        }
        if (this.resource == null) {
            this.createModel(uriWithoutExtension);
        }
    }

    protected void loadInternationalizationPreference(URI uri) {
        if (this.resource != null && this.resource.getContents() != null && !this.resource.getContents().isEmpty()) {
            boolean useInternationalizationValue = false;
            String languagePreference = null;
            EAnnotation annotation = InternationalizationAnnotationResourceUtils.getInternationalizationAnnotation((Resource)this.resource);
            if (annotation != null) {
                String languageValue;
                String useInternationalizationStringValue = (String)annotation.getDetails().get((Object)"use");
                useInternationalizationValue = Boolean.parseBoolean(useInternationalizationStringValue);
                languagePreference = languageValue = (String)annotation.getDetails().get((Object)"language");
            }
            URI sharedResource = this.getPrivateResourceURI();
            InternationalizationPreferencesUtils.setInternationalizationPreference((URI)sharedResource, (boolean)useInternationalizationValue);
            if (languagePreference != null) {
                InternationalizationPreferencesUtils.setLanguagePreference((URI)sharedResource, (String)languagePreference.toString());
            }
        }
    }

    public void createModel(URI uriWithoutExtension) {
        if (this.isLegacy(uriWithoutExtension)) {
            URI internationalizationPrefURI = this.getInternationalizationPreferenceModelStoreURI(uriWithoutExtension);
            try {
                super.createModel(internationalizationPrefURI.trimFileExtension());
                this.intantiateTemplate(internationalizationPrefURI);
                this.loadInternationalizationPreference(uriWithoutExtension);
            }
            catch (IOException e) {
                Activator.log.error("Failed to initialize workspace private internationalization model", (Throwable)e);
                super.createModel(internationalizationPrefURI.trimFileExtension());
            }
        } else {
            super.createModel(uriWithoutExtension);
        }
    }

    protected void intantiateTemplate(URI internationalizationPrefResourceURI) throws IOException {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("Internationalization");
        annotation.getDetails().put((Object)"use", (Object)Boolean.toString(true));
        annotation.getDetails().put((Object)"language", (Object)Locale.getDefault().toString());
        GMFtoEMFCommandWrapper command = new GMFtoEMFCommandWrapper((ICommand)new AddToResourceCommand(((ModelSet)this.resource.getResourceSet()).getTransactionalEditingDomain(), this.resource, (EObject)annotation));
        command.execute();
    }

    public void setModelURI(URI uriWithoutExtension) {
        URI oldPrivateURI = this.getSharedResourceURI();
        URI oldSharedURI = this.getPrivateResourceURI();
        URI newURI = this.resourceURI != null && this.isLegacy(this.resourceURI.trimFileExtension()) ? this.getLegacyURI(uriWithoutExtension) : this.getInternationalizationPreferenceModelStoreURI(uriWithoutExtension);
        super.setModelURI(newURI.trimFileExtension());
        this.bean.firePropertyChange(PROPERTY_PRIVATE_RESOURCE_URI, oldPrivateURI, this.getSharedResourceURI());
        this.bean.firePropertyChange(PROPERTY_SHARED_RESOURCE_URI, oldSharedURI, this.getPrivateResourceURI());
    }

    protected boolean isLegacy(URI uriWithoutExtension) {
        boolean result = false;
        if (uriWithoutExtension != null) {
            result = Objects.equals(uriWithoutExtension, this.getModelManager().getURIWithoutExtension());
        }
        return result;
    }

    protected URI getInternationalizationPreferenceModelURI(URI uriWithoutExtension) {
        URI legacyURI;
        URIConverter converter = this.getModelManager().getURIConverter();
        if (converter.exists(legacyURI = this.getLegacyURI(uriWithoutExtension), Collections.emptyMap())) {
            try {
                Resource notationResource = this.getModelManager().getResource(legacyURI, true);
                if (InternationalizationAnnotationResourceUtils.getInternationalizationAnnotation((Resource)notationResource) != null) {
                    return legacyURI;
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return this.getInternationalizationPreferenceModelStoreURI(uriWithoutExtension);
    }

    protected URI getLegacyURI(URI uriWithoutExtension) {
        return uriWithoutExtension.appendFileExtension(NOTATION_FILE_EXTENSION);
    }

    protected URI getInternationalizationPreferenceModelStoreURI(URI uriWithoutExtension) {
        URI fullURI = uriWithoutExtension.appendFileExtension(INTERNATIONALIZATION_PREFERENCE_FILE_EXTENSION);
        return this.providerManager.getInternationalizationPreferenceModelProvider(fullURI).getInternationalizationPreferenceModelURI(fullURI);
    }

    protected Map<Object, Object> getSaveOptions() {
        Map saveOptions = super.getSaveOptions();
        saveOptions.put("USE_XMI_TYPE", Boolean.FALSE);
        saveOptions.put("SAVE_TYPE_INFORMATION", Boolean.FALSE);
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public boolean isLegacyMode() {
        if (this.legacyMode == null) {
            this.legacyMode = false;
            URI sharedURI = this.getPrivateResourceURI();
            if (sharedURI != null) {
                for (Resource next : this.getResources()) {
                    if (!sharedURI.equals(next.getURI())) continue;
                    this.legacyMode = InternationalizationAnnotationResourceUtils.getInternationalizationAnnotation((Resource)next) != null;
                    break;
                }
            }
        }
        return this.legacyMode;
    }

    protected void invalidateLegacyMode() {
        boolean oldValue = this.isLegacyMode();
        this.legacyMode = null;
        boolean newValue = this.isLegacyMode();
        if (oldValue != newValue) {
            this.bean.firePropertyChange(PROPERTY_LEGACY_MODE, oldValue, newValue);
        }
    }

    public URI getSharedResourceURI() {
        URI modelURI = this.getModelManager() == null ? null : this.getModelManager().getURIWithoutExtension();
        return modelURI == null ? null : this.getInternationalizationPreferenceModelStoreURI(modelURI);
    }

    public URI getPrivateResourceURI() {
        URI modelURI = this.getModelManager() == null ? null : this.getModelManager().getURIWithoutExtension();
        return modelURI == null ? null : modelURI.appendFileExtension(NOTATION_FILE_EXTENSION);
    }

    protected boolean isRootElement(EObject object) {
        return super.isRootElement(object) && object instanceof EAnnotation && "Internationalization".equals(((EAnnotation)object).getSource());
    }

    protected boolean isSupportedRoot(EObject object) {
        return object instanceof EAnnotation && "Internationalization".equals(((EAnnotation)object).getSource());
    }

    public String getModelFileExtension() {
        if (this.isLegacy(this.resourceURI == null ? this.resourceURI : this.resourceURI.trimFileExtension())) {
            return NOTATION_FILE_EXTENSION;
        }
        return INTERNATIONALIZATION_PREFERENCE_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.bean.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.bean.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.bean.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.bean.removePropertyChangeListener(propertyName, listener);
    }
}

