/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.gmf.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.papyrus.infra.emf.gmf.util.OperationUtils;

public class OperationHistoryDirtyState {
    private static final Map<IUndoContext, OperationHistoryDirtyState> instances = new HashMap<IUndoContext, OperationHistoryDirtyState>();
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final IUndoContext context;
    private final IOperationHistory history;
    private IOperationHistoryListener listener;
    private IUndoableOperation savepoint;
    private boolean forceDirty;

    protected OperationHistoryDirtyState(IUndoContext context, IOperationHistory history) {
        this.context = context;
        this.history = history;
        history.addOperationHistoryListener(this.createOperationHistoryListener());
    }

    OperationHistoryDirtyState(OperationHistoryDirtyState delegate) {
        this.context = delegate.context;
        this.history = delegate.history;
    }

    public static OperationHistoryDirtyState newInstance(IUndoContext context, IOperationHistory history) {
        return OperationHistoryDirtyState.getInstance(context, history, OperationHistoryDirtyState::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OperationHistoryDirtyState getInstance(IUndoContext context, IOperationHistory history, BiFunction<? super IUndoContext, ? super IOperationHistory, ? extends OperationHistoryDirtyState> factory) {
        OperationHistoryDirtyState result;
        Map<IUndoContext, OperationHistoryDirtyState> map = instances;
        synchronized (map) {
            result = instances.get(context);
            if (result == null) {
                result = factory.apply((IUndoContext)context, (IOperationHistory)history);
                instances.put(context, result);
            }
        }
        result.retain();
        return result;
    }

    private IOperationHistoryListener createOperationHistoryListener() {
        this.listener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                switch (event.getEventType()) {
                    case 4: 
                    case 6: 
                    case 9: 
                    case 10: {
                        if (OperationHistoryDirtyState.this.savepoint == null || OperationHistoryDirtyState.this.savepoint.hasContext(OperationHistoryDirtyState.this.context)) break;
                        OperationHistoryDirtyState.this.savepoint = null;
                        break;
                    }
                    case 8: {
                        IUndoableOperation removed = event.getOperation();
                        if (removed == null) break;
                        if (removed == OperationHistoryDirtyState.this.savepoint) {
                            OperationHistoryDirtyState.this.savepoint = null;
                            break;
                        }
                        if (OperationHistoryDirtyState.this.savepoint != null || !removed.hasContext(OperationHistoryDirtyState.this.context) || OperationUtils.isNonDirtying(removed)) break;
                        OperationHistoryDirtyState.this.forceDirty = true;
                    }
                }
            }
        };
        return this.listener;
    }

    private OperationHistoryDirtyState retain() {
        this.refCount.incrementAndGet();
        return this;
    }

    private boolean release() {
        return this.refCount.decrementAndGet() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<IUndoContext, OperationHistoryDirtyState> map = instances;
        synchronized (map) {
            if (this.release()) {
                instances.remove(this.context);
                if (this.listener != null) {
                    this.history.removeOperationHistoryListener(this.listener);
                    this.listener = null;
                }
                this.savepoint = null;
            }
        }
    }

    public boolean isDirty() {
        return this.forceDirty || OperationUtils.isDirty(this.history.getUndoHistory(this.context), this.history.getRedoHistory(this.context), this.savepoint);
    }

    public void saved() {
        this.savepoint = this.history.getUndoOperation(this.context);
        this.forceDirty = false;
    }

    public boolean equals(Object obj) {
        return obj instanceof Delegator ? this.equals(((Delegator)obj).delegate) : super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static class Delegator
    extends OperationHistoryDirtyState {
        private final OperationHistoryDirtyState delegate;

        protected Delegator(IUndoContext context, IOperationHistory history) {
            this(Delegator.newInstance(context, history));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Delegator(OperationHistoryDirtyState delegate) {
            super(delegate);
            this.delegate = delegate;
            Map map = instances;
            synchronized (map) {
                instances.put(delegate.context, this);
            }
        }

        @Override
        public boolean isDirty() {
            return this.delegate.isDirty();
        }

        @Override
        public void dispose() {
            this.delegate.dispose();
        }

        @Override
        public void saved() {
            this.delegate.saved();
        }

        @Override
        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

