/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.editor;

import org.eclipse.papyrus.editor.PapyrusNavigationHistorySynchronizer;
import org.eclipse.papyrus.editor.PapyrusNavigationLocation;
import org.eclipse.papyrus.editor.PapyrusPaletteSynchronizer;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.ui.editor.CoreMultiDiagramEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;

public class PapyrusMultiDiagramEditor
extends CoreMultiDiagramEditor
implements INavigationLocationProvider {
    public static final String EDITOR_ID = "org.eclipse.papyrus.infra.core.papyrusEditor";
    private PapyrusPaletteSynchronizer myPaletteViewSynchronizer;
    private PapyrusNavigationHistorySynchronizer myNavigationHistorySynchronizer;

    protected void activate() {
        super.activate();
        this.myPaletteViewSynchronizer = new PapyrusPaletteSynchronizer(this);
        this.myNavigationHistorySynchronizer = new PapyrusNavigationHistorySynchronizer(this);
        this.getISashWindowsContainer().addPageChangedListener((IPageChangedListener)this.myPaletteViewSynchronizer);
        this.getISashWindowsContainer().addPageChangedListener((IPageChangedListener)this.myNavigationHistorySynchronizer);
    }

    protected void deactivate() {
        if (this.myPaletteViewSynchronizer != null) {
            ISashWindowsContainer sashContainer = this.getISashWindowsContainer();
            if (sashContainer != null && !sashContainer.isDisposed()) {
                sashContainer.removePageChangedListener((IPageChangedListener)this.myPaletteViewSynchronizer);
                sashContainer.removePageChangedListener((IPageChangedListener)this.myNavigationHistorySynchronizer);
            }
            this.myPaletteViewSynchronizer.dispose();
            this.myPaletteViewSynchronizer = null;
        }
        super.deactivate();
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        return new PapyrusNavigationLocation((IEditorPart)this);
    }
}

