/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.op.CreatePatchOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.ActionUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.CommitGraphTableHoverManager;
import org.eclipse.egit.ui.internal.history.GraphContentProvider;
import org.eclipse.egit.ui.internal.history.GraphLabelProvider;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.history.SWTPlotRenderer;
import org.eclipse.egit.ui.internal.history.TableLoader;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.services.IServiceLocator;

class CommitGraphTable {
    private static final String LINESEP = System.lineSeparator();
    private final Composite tableContainer;
    private final TableViewer table;
    private final CommitGraphTableLayout tableLayout;
    private final ColumnLayoutData[] columnLayouts = new ColumnLayoutData[6];
    private final ColumnLayoutData[] baseLayouts = new ColumnLayoutData[6];
    private final ColumnLayoutData[] defaultLayouts = new ColumnLayoutData[6];
    private Clipboard clipboard;
    private final SWTPlotRenderer renderer;
    private final Font nFont;
    private final Font hFont;
    private SWTCommitList allCommits;
    private SWTCommit[] allCommitsArray;
    private int allCommitsLength = 0;
    private HashMap<String, PlotCommit> commitsMap = null;
    private RevFlag highlight;
    private HistoryPageInput input;
    IAction copy;
    private RevCommit commitToShow;
    private final TableLoader tableLoader;
    private boolean trace = GitTraceLocation.HISTORYVIEW.isActive();
    private boolean enableAntialias = true;

    static Font highlightFont() {
        FontData[] hData;
        Font n = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphNormalFont");
        Font h = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphHighlightFont");
        FontData[] nData = n.getFontData();
        if (nData.length != (hData = h.getFontData()).length) {
            return h;
        }
        int i = 0;
        while (i < nData.length) {
            if (!nData[i].equals((Object)hData[i])) {
                return h;
            }
            ++i;
        }
        return UIUtils.getBoldFont("org.eclipse.egit.ui.CommitGraphNormalFont");
    }

    CommitGraphTable(Composite parent, TableLoader loader, ResourceManager resources, boolean canShowEmailAddresses) {
        this(parent, loader, resources, canShowEmailAddresses, false);
    }

    CommitGraphTable(Composite parent, TableLoader loader, ResourceManager resources, boolean canShowEmailAddresses, boolean useColumnPreferences) {
        this.nFont = UIUtils.getFont("org.eclipse.egit.ui.CommitGraphNormalFont");
        this.hFont = CommitGraphTable.highlightFont();
        this.tableLoader = loader;
        this.tableContainer = new Composite(parent, 0);
        final Table rawTable = new Table(this.tableContainer, 268503810);
        rawTable.setHeaderVisible(true);
        rawTable.setLinesVisible(false);
        rawTable.setFont(this.nFont);
        rawTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                if (CommitGraphTable.this.tableLoader != null) {
                    TableItem item = (TableItem)event.item;
                    int index = rawTable.indexOf(item);
                    if (CommitGraphTable.this.trace) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Item " + index);
                    }
                    CommitGraphTable.this.tableLoader.loadItem(index);
                }
            }
        });
        this.tableLayout = new CommitGraphTableLayout();
        this.tableContainer.setLayout((Layout)this.tableLayout);
        this.createColumns(rawTable);
        this.createPaintListener(rawTable);
        System.arraycopy(this.columnLayouts, 0, this.defaultLayouts, 0, this.columnLayouts.length);
        System.arraycopy(this.columnLayouts, 0, this.baseLayouts, 0, this.columnLayouts.length);
        if (useColumnPreferences) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            this.applyColumnPreferences(store, rawTable);
            IPropertyChangeListener prefsChanged = event -> {
                String property = event.getProperty();
                if ("HistoryView_ColumnIdShow".equals(property) || "HistoryView_ColumnAuthorShow".equals(property) || "HistoryView_ColumnAuthorDateShow".equals(property) || "HistoryView_ColumnCommitterShow".equals(property) || "HistoryView_ColumnCommitterDateShow".equals(property)) {
                    rawTable.getDisplay().asyncExec(() -> {
                        if (!rawTable.isDisposed()) {
                            this.applyColumnPreferences(store, rawTable);
                            rawTable.getParent().layout();
                        }
                    });
                }
            };
            store.addPropertyChangeListener(prefsChanged);
            rawTable.addDisposeListener(event -> store.removePropertyChangeListener(prefsChanged));
        }
        rawTable.addListener(11, event -> this.layout(rawTable));
        this.table = new TableViewer(rawTable){

            protected Widget doFindItem(Object element) {
                return element != null ? ((SWTCommit)((Object)element)).widget : null;
            }

            protected void mapElement(Object element, Widget item) {
                if (element == null) {
                    return;
                }
                ((SWTCommit)((Object)element)).widget = item;
            }
        };
        GraphLabelProvider graphLabelProvider = new GraphLabelProvider(canShowEmailAddresses);
        graphLabelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                CommitGraphTable.this.table.refresh();
            }
        });
        this.table.setLabelProvider((IBaseLabelProvider)graphLabelProvider);
        this.table.setContentProvider((IContentProvider)new GraphContentProvider());
        this.renderer = new SWTPlotRenderer(rawTable.getDisplay(), resources);
        this.clipboard = new Clipboard(rawTable.getDisplay());
        rawTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommitGraphTable.this.clipboard.dispose();
                CommitGraphTable.this.allCommitsArray = null;
            }
        });
        this.copy = ActionUtils.createGlobalAction(ActionFactory.COPY, this::doCopy);
        this.copy.setText(UIText.CommitGraphTable_CopyCommitIdLabel);
        this.copy.setImageDescriptor(UIIcons.ELCL16_ID);
        this.table.setUseHashlookup(true);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    CommitGraphTable.this.copy.setEnabled(false);
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                CommitGraphTable.this.commitToShow = (RevCommit)((PlotCommit)iss.getFirstElement());
                CommitGraphTable.this.copy.setEnabled(CommitGraphTable.this.canDoCopy());
            }
        });
        CommitGraphTableHoverManager hoverManager = new CommitGraphTableHoverManager(this.table, this.renderer);
        hoverManager.install((Control)this.table.getTable());
        this.table.getTable().addDisposeListener(e -> hoverManager.dispose());
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance(), FileTransfer.getInstance()};
        this.table.addDragSupport(17, transferTypes, (DragSourceListener)new CommitDragSourceListener());
    }

    CommitGraphTable(Composite parent, final IPageSite site, MenuManager menuMgr, TableLoader loader, ResourceManager resources) {
        this(parent, loader, resources, true, true);
        IAction selectAll = ActionUtils.createGlobalAction(ActionFactory.SELECT_ALL, () -> this.getTableView().getTable().selectAll());
        ActionUtils.setGlobalActions((Control)this.getTable(), this.copy, selectAll);
        this.getTableView().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Parameterization[] parms;
                if (CommitGraphTable.this.input == null || !CommitGraphTable.this.input.isSingleFile()) {
                    return;
                }
                ICommandService srv = CommonUtils.getService((IServiceLocator)site, ICommandService.class);
                IHandlerService hsrv = CommonUtils.getService((IServiceLocator)site, IHandlerService.class);
                Command cmd = srv.getCommand("org.eclipse.egit.ui.history.ShowVersions");
                if (Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_compare_mode")) {
                    try {
                        IParameter parm = cmd.getParameter("org.eclipse.egit.ui.history.CompareMode");
                        parms = new Parameterization[]{new Parameterization(parm, Boolean.TRUE.toString())};
                    }
                    catch (NotDefinedException e) {
                        Activator.handleError(e.getMessage(), e, true);
                        parms = null;
                    }
                } else {
                    parms = null;
                }
                ParameterizedCommand pcmd = new ParameterizedCommand(cmd, parms);
                try {
                    hsrv.executeCommandInContext(pcmd, null, hsrv.getCurrentState());
                }
                catch (Exception e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
        });
        Table c = this.getTable();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(arg_0 -> this.lambda$7((Control)c, menuMgr, arg_0));
        c.setMenu(menuMgr.createContextMenu((Control)c));
    }

    Control getControl() {
        return this.tableContainer;
    }

    Table getTable() {
        return this.table.getTable();
    }

    void selectCommitStored(RevCommit c) {
        this.commitToShow = c;
        this.selectCommit(c);
    }

    void selectCommit(RevCommit c) {
        if (c instanceof PlotCommit) {
            this.table.setSelection((ISelection)new StructuredSelection((Object)c), true);
        } else if (this.commitsMap != null) {
            PlotCommit swtCommit = this.commitsMap.get(c.getId().name());
            if (swtCommit == null && this.tableLoader != null) {
                this.tableLoader.loadCommit(c);
            }
            if (swtCommit != null) {
                this.table.setSelection((ISelection)new StructuredSelection((Object)swtCommit), true);
            }
        }
    }

    void addSelectionChangedListener(ISelectionChangedListener l) {
        this.table.addPostSelectionChangedListener(l);
    }

    void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.table.removePostSelectionChangedListener(l);
    }

    private boolean canDoCopy() {
        return !this.table.getSelection().isEmpty();
    }

    private void doCopy() {
        ISelection s = this.table.getSelection();
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        Iterator itr = iss.iterator();
        StringBuilder r = new StringBuilder();
        while (itr.hasNext()) {
            PlotCommit d = (PlotCommit)itr.next();
            if (r.length() > 0) {
                r.append(LINESEP);
            }
            r.append(d.getId().name());
        }
        if (this.clipboard == null || this.clipboard.isDisposed()) {
            return;
        }
        this.clipboard.setContents(new Object[]{r.toString()}, new Transfer[]{TextTransfer.getInstance()}, 1);
    }

    void setInput(RevFlag hFlag, SWTCommitList list, SWTCommit[] asArray, HistoryPageInput input, boolean keepPosition) {
        int i;
        Table t = this.table.getTable();
        String topCommitName = null;
        if (keepPosition && (i = t.getTopIndex()) >= 0 && i < t.getItemCount() && i < this.allCommitsLength && this.allCommitsArray != null) {
            topCommitName = this.allCommitsArray[i].getId().name();
        }
        this.setHistoryPageInput(input);
        SWTCommitList oldList = this.allCommits;
        this.highlight = hFlag;
        this.allCommits = list;
        int newAllCommitsLength = asArray == null ? 0 : asArray.length;
        int topIndex = -1;
        if (newAllCommitsLength > 0) {
            topIndex = oldList != list || this.allCommitsLength < newAllCommitsLength ? this.initCommitsMap(asArray, topCommitName) : this.findCommit(asArray, topCommitName);
        }
        this.allCommitsArray = asArray;
        this.allCommitsLength = newAllCommitsLength;
        this.table.setInput((Object)asArray);
        if (newAllCommitsLength > 0) {
            if (this.commitToShow != null) {
                this.selectCommit(this.commitToShow);
            }
            if (keepPosition && topIndex >= 0) {
                t.setTopIndex(topIndex);
            }
        } else {
            t.deselectAll();
            this.table.setSelection(this.table.getSelection());
        }
    }

    void setHistoryPageInput(HistoryPageInput input) {
        this.input = input;
    }

    private int initCommitsMap(SWTCommit[] asArray, String topName) {
        int topIndex = -1;
        this.commitsMap = new HashMap();
        SWTCommit[] sWTCommitArray = asArray;
        int n = asArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTCommit commit = sWTCommitArray[n2];
            if (commit != null) {
                String name = commit.getId().name();
                this.commitsMap.put(name, commit);
                if (name.equals(topName)) {
                    topIndex = this.commitsMap.size() - 1;
                }
            }
            ++n2;
        }
        return topIndex;
    }

    private int findCommit(SWTCommit[] asArray, String topName) {
        int index = 0;
        SWTCommit[] sWTCommitArray = asArray;
        int n = asArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            SWTCommit commit = sWTCommitArray[n2];
            if (commit != null && (name = commit.getId().name()).equals(topName)) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    private void createColumns(Table rawTable) {
        TableColumn commitId = new TableColumn(rawTable, 0);
        commitId.setResizable(true);
        commitId.setText(UIText.CommitGraphTable_CommitId);
        int minWidth = CommonUtils.getCommitIdColumnWidth((Control)rawTable, UIText.CommitGraphTable_CommitId);
        this.columnLayouts[0] = new ColumnPixelData(minWidth, false);
        this.tableLayout.setColumnData((Widget)commitId, this.columnLayouts[0]);
        TableColumn graph = new TableColumn(rawTable, 0);
        graph.setResizable(true);
        graph.setText(UIText.CommitGraphTable_messageColumn);
        graph.setWidth(400);
        this.columnLayouts[1] = new ColumnWeightData(20, 200, true);
        this.tableLayout.setColumnData((Widget)graph, this.columnLayouts[1]);
        TableColumn author = new TableColumn(rawTable, 0);
        author.setResizable(true);
        author.setText(UIText.HistoryPage_authorColumn);
        author.setWidth(100);
        this.columnLayouts[2] = new ColumnWeightData(5, 80, true);
        this.tableLayout.setColumnData((Widget)author, this.columnLayouts[2]);
        TableColumn date = new TableColumn(rawTable, 0);
        date.setResizable(true);
        date.setText(UIText.HistoryPage_authorDateColumn);
        date.setWidth(100);
        this.columnLayouts[3] = new ColumnWeightData(5, 80, true);
        this.tableLayout.setColumnData((Widget)date, this.columnLayouts[3]);
        TableColumn committer = new TableColumn(rawTable, 0);
        committer.setResizable(true);
        committer.setText(UIText.CommitGraphTable_Committer);
        committer.setWidth(100);
        this.columnLayouts[4] = new ColumnWeightData(5, 80, true);
        this.tableLayout.setColumnData((Widget)committer, this.columnLayouts[4]);
        TableColumn committerDate = new TableColumn(rawTable, 0);
        committerDate.setResizable(true);
        committerDate.setText(UIText.CommitGraphTable_committerDateColumn);
        committerDate.setWidth(100);
        this.columnLayouts[5] = new ColumnWeightData(5, 80, true);
        this.tableLayout.setColumnData((Widget)committerDate, this.columnLayouts[5]);
    }

    private void createPaintListener(Table rawTable) {
        rawTable.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 1) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        rawTable.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 1) {
                    CommitGraphTable.this.doPaint(event);
                }
            }
        });
    }

    void doPaint(Event event) {
        SWTCommitList.SWTLane lane;
        RevCommit c;
        if (this.enableAntialias) {
            try {
                event.gc.setAntialias(1);
            }
            catch (SWTException e) {
                this.enableAntialias = false;
            }
        }
        if ((c = (RevCommit)((TableItem)event.item).getData()) instanceof SWTCommit && (lane = (SWTCommitList.SWTLane)((SWTCommit)c).getLane()) != null && lane.color.isDisposed()) {
            return;
        }
        if (this.highlight != null && c != null && c.has(this.highlight)) {
            event.gc.setFont(this.hFont);
        } else {
            event.gc.setFont(this.nFont);
        }
        this.renderer.paint(event);
    }

    public TableViewer getTableView() {
        return this.table;
    }

    private void layout(Table rawTable) {
        TableColumn[] columns;
        rawTable.getParent().layout();
        int tableWidth = rawTable.getSize().x;
        int columnsWidth = 0;
        TableColumn[] tableColumnArray = columns = rawTable.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            columnsWidth += col.getWidth();
            ++n2;
        }
        if (columnsWidth > tableWidth) {
            int i = 1;
            while (i < columns.length) {
                if (columns[i].getWidth() != 0) {
                    this.tableLayout.setColumnData((Widget)columns[i], this.baseLayouts[i]);
                }
                ++i;
            }
            rawTable.getParent().layout();
        }
        rawTable.redraw();
    }

    void setVisible(int columnIndex, boolean visible) {
        boolean isVisible;
        Assert.isLegal((columnIndex >= 0 && columnIndex < this.columnLayouts.length ? 1 : 0) != 0);
        if (columnIndex == 1) {
            return;
        }
        Table rawTable = this.table.getTable();
        TableColumn col = rawTable.getColumn(columnIndex);
        boolean bl = isVisible = col.getWidth() > 0;
        if (isVisible != visible) {
            if (isVisible) {
                this.columnLayouts[columnIndex] = this.tableLayout.getLayoutData((Scrollable)rawTable, columnIndex);
                if (this.columnLayouts[columnIndex] == null) {
                    this.columnLayouts[columnIndex] = this.defaultLayouts[columnIndex];
                }
                this.tableLayout.setColumnData((Widget)col, (ColumnLayoutData)new ColumnPixelData(0));
            } else {
                this.tableLayout.setColumnData((Widget)col, this.columnLayouts[columnIndex]);
            }
            rawTable.getParent().layout();
        }
    }

    private void setColumn(TableColumn column, int index, boolean visible) {
        if (visible) {
            this.baseLayouts[index] = this.defaultLayouts[index];
            if (column.getWidth() > 0) {
                return;
            }
            this.tableLayout.setColumnData((Widget)column, this.columnLayouts[index]);
        } else {
            this.baseLayouts[index] = new ColumnPixelData(0);
            this.tableLayout.setColumnData((Widget)column, this.baseLayouts[index]);
        }
    }

    private void applyColumnPreferences(IPreferenceStore store, Table rawTable) {
        this.setColumn(rawTable.getColumn(0), 0, store.getBoolean("HistoryView_ColumnIdShow"));
        this.setColumn(rawTable.getColumn(2), 2, store.getBoolean("HistoryView_ColumnAuthorShow"));
        this.setColumn(rawTable.getColumn(3), 3, store.getBoolean("HistoryView_ColumnAuthorDateShow"));
        this.setColumn(rawTable.getColumn(4), 4, store.getBoolean("HistoryView_ColumnCommitterShow"));
        this.setColumn(rawTable.getColumn(5), 5, store.getBoolean("HistoryView_ColumnCommitterDateShow"));
    }

    private /* synthetic */ void lambda$7(Control control, MenuManager menuManager, IMenuManager manager) {
        control.setFocus();
        menuManager.add((IContributionItem)new Separator("history.group"));
        menuManager.add((IContributionItem)new Separator("additions"));
        if (this.copy.isEnabled()) {
            menuManager.add((IContributionItem)new Separator());
            menuManager.add(this.copy);
        }
    }

    private final class CommitDragSourceListener
    extends DragSourceAdapter {
        private CommitDragSourceListener() {
        }

        public void dragStart(DragSourceEvent event) {
            RevCommit commit = this.getSelectedCommit();
            event.doit = commit != null && commit.getParentCount() == 1;
        }

        public void dragSetData(DragSourceEvent event) {
            boolean isFileTransfer = FileTransfer.getInstance().isSupportedType(event.dataType);
            boolean isTextTransfer = TextTransfer.getInstance().isSupportedType(event.dataType);
            if (isFileTransfer || isTextTransfer) {
                RevCommit commit = this.getSelectedCommit();
                if (commit == null) {
                    return;
                }
                String patchContent = this.createPatch(commit);
                if (isTextTransfer) {
                    event.data = patchContent;
                    return;
                }
                File patchFile = null;
                try {
                    try {
                        patchFile = this.createTempFile(commit);
                        this.writeToFile(patchFile.getAbsolutePath(), patchContent);
                        event.data = new String[]{patchFile.getAbsolutePath()};
                    }
                    catch (IOException e) {
                        Activator.logError(NLS.bind((String)UIText.CommitGraphTable_UnableToWritePatch, (Object)commit.getId().name()), e);
                        if (patchFile != null) {
                            patchFile.deleteOnExit();
                        }
                    }
                }
                finally {
                    if (patchFile != null) {
                        patchFile.deleteOnExit();
                    }
                }
            }
        }

        private File createTempFile(@NonNull RevCommit commit) throws IOException {
            String tmpDir = System.getProperty("java.io.tmpdir");
            String patchName = "egit-patch" + commit.getId().name();
            File patchDir = new File(tmpDir, patchName);
            int counter = 1;
            while (patchDir.exists()) {
                patchDir = new File(tmpDir, String.valueOf(patchName) + "_" + counter);
                ++counter;
            }
            FileUtils.mkdir((File)patchDir);
            patchDir.deleteOnExit();
            String suggestedFileName = CreatePatchOperation.suggestFileName((RevCommit)commit);
            File patchFile = new File(patchDir, suggestedFileName);
            return patchFile;
        }

        private String createPatch(RevCommit commit) {
            Repository repository = CommitGraphTable.this.input.getRepository();
            CreatePatchOperation operation = new CreatePatchOperation(repository, commit);
            operation.setHeaderFormat(CreatePatchOperation.DiffHeaderFormat.EMAIL);
            operation.setContextLines(3);
            try {
                operation.execute(null);
            }
            catch (CoreException e) {
                Activator.logError(NLS.bind((String)UIText.CommitGraphTable_UnableToCreatePatch, (Object)commit.getId().name()), e);
            }
            String patchContent = operation.getPatchContent();
            return patchContent;
        }

        @Nullable
        private RevCommit getSelectedCommit() {
            IStructuredSelection selection = (IStructuredSelection)CommitGraphTable.this.table.getSelection();
            RevCommit commit = (RevCommit)selection.getFirstElement();
            if (commit == null) {
                return null;
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (RevWalk walk = new RevWalk(CommitGraphTable.this.input.getRepository());){
                    return walk.parseCommit((AnyObjectId)commit.getId());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse commit " + commit.getId(), e);
            }
        }

        private void writeToFile(String fileName, String content) throws IOException {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8));){
                output.write(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static class CommitGraphTableLayout
    extends TableColumnLayout {
        private CommitGraphTableLayout() {
        }

        protected ColumnLayoutData getLayoutData(Scrollable table, int columnIndex) {
            return super.getLayoutData(table, columnIndex);
        }
    }
}

