/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.DialogBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramPrintRangeBlock
extends DialogBlock {
    private final DataBindingContext bindings;
    private final PrintOptions options;
    private ListViewer diagramList;
    private List<String> availableDiagrams;

    DiagramPrintRangeBlock(DialogBlock.IDialogUnitConverter dluConverter, DataBindingContext bindings, PrintOptions options, List<String> availableDiagrams) {
        super(dluConverter);
        this.bindings = bindings;
        this.options = options;
        this.availableDiagrams = availableDiagrams;
    }

    @Override
    public Control createContents(Composite parent) {
        Realm realm = this.bindings.getValidationRealm();
        Group result = this.group(parent, DiagramUIPrintingMessages.JPSOptionsDialog_DiagramPrintRange);
        DiagramPrintRangeBlock.layout((Composite)result, 3);
        Button currentDiagramRadio = this.radio((Composite)result, DiagramUIPrintingMessages.JPSOptionsDialog_DiagramPrintCurrent);
        this.layoutSpanHorizontal((Control)currentDiagramRadio, 4);
        Button selectedDiagramsRadio = this.radio((Composite)result, DiagramUIPrintingMessages.JPSOptionsDialog_DiagramPrintSelected);
        this.layoutSpanHorizontal((Control)selectedDiagramsRadio, 4);
        this.diagramList = this.list((Composite)result);
        this.layoutFillHorizontal(this.layoutHeight(this.diagramList.getControl(), 48));
        GridData data = this.getLayoutData(this.diagramList.getControl());
        data.widthHint = 300;
        this.diagramList.getControl().setEnabled(this.options.isDiagramSelection());
        currentDiagramRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent event) {
                DiagramPrintRangeBlock.this.diagramList.getControl().setEnabled(DiagramPrintRangeBlock.this.options.isDiagramSelection());
            }
        });
        selectedDiagramsRadio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent event) {
                DiagramPrintRangeBlock.this.diagramList.getControl().setEnabled(!DiagramPrintRangeBlock.this.options.isDiagramCurrent());
            }
        });
        this.diagramList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event != null) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    DiagramPrintRangeBlock.this.options.setDiagramsToPrint(selection.toList());
                }
            }
        });
        this.diagramList.setContentProvider((IContentProvider)new DiagramContentProvider());
        this.diagramList.setLabelProvider((IBaseLabelProvider)new DiagramLabelProvider());
        this.diagramList.setInput(this.availableDiagrams);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeSelection((Control)currentDiagramRadio), BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_DIAGRAM_CURRENT), null, null);
        this.bindings.bindValue((IObservableValue)SWTObservables.observeSelection((Control)selectedDiagramsRadio), BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_DIAGRAM_SELECTION), null, null);
        return result;
    }

    @Override
    public void dispose() {
    }

    private class DiagramContentProvider
    implements IStructuredContentProvider {
        private DiagramContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return DiagramPrintRangeBlock.this.availableDiagrams.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class DiagramLabelProvider
    extends LabelProvider {
        private DiagramLabelProvider() {
        }

        public String getText(Object element) {
            return (String)element;
        }
    }
}

