/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class MasterDetailsBlock {
    protected DetailsPart detailsPart;
    protected SashForm sashForm;
    static final int DRAGGER_SIZE = 40;

    public void createContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        this.createContent(managedForm, form.getBody());
    }

    public void createContent(IManagedForm managedForm, Composite parent) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.applyLayout(parent);
        this.sashForm = new MDSashForm(parent, 0);
        this.sashForm.setData("form", (Object)managedForm);
        toolkit.adapt((Control)this.sashForm, false, false);
        this.sashForm.setMenu(parent.getMenu());
        this.applyLayoutData(this.sashForm);
        this.createMasterPart(managedForm, (Composite)this.sashForm);
        this.createDetailsPart(managedForm, (Composite)this.sashForm);
        this.hookResizeListener();
        this.createToolBarActions(managedForm);
        form.updateToolBar();
    }

    protected void applyLayoutData(SashForm sashForm) {
        sashForm.setLayoutData((Object)new GridData(1808));
    }

    protected void applyLayout(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
    }

    private void hookResizeListener() {
        Control[] children;
        Listener listener = ((MDSashForm)this.sashForm).listener;
        Control[] controlArray = children = this.sashForm.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (!(element instanceof Sash)) {
                element.addListener(11, listener);
            }
            ++n2;
        }
    }

    protected abstract void createMasterPart(IManagedForm var1, Composite var2);

    protected abstract void registerPages(DetailsPart var1);

    protected abstract void createToolBarActions(IManagedForm var1);

    private void createDetailsPart(IManagedForm mform, Composite parent) {
        this.detailsPart = new DetailsPart(mform, parent, 0);
        mform.addPart(this.detailsPart);
        this.registerPages(this.detailsPart);
    }

    private void onSashPaint(Event e) {
        Sash sash = (Sash)e.widget;
        IManagedForm form = (IManagedForm)sash.getParent().getData("form");
        FormColors colors = form.getToolkit().getColors();
        boolean vertical = (sash.getStyle() & 0x200) != 0;
        GC gc = e.gc;
        Boolean hover = (Boolean)sash.getData("hover");
        gc.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
        gc.setForeground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        Point size = sash.getSize();
        if (vertical) {
            if (hover != null) {
                gc.fillRectangle(0, 0, size.x, size.y);
            }
        } else if (hover != null) {
            gc.fillRectangle(0, 0, size.x, size.y);
        }
    }

    class MDSashForm
    extends SashForm {
        ArrayList<Sash> sashes;
        Listener listener;

        public MDSashForm(Composite parent, int style) {
            super(parent, style);
            this.sashes = new ArrayList();
            this.listener = e -> {
                switch (e.type) {
                    case 6: {
                        e.widget.setData("hover", (Object)Boolean.TRUE);
                        ((Control)e.widget).redraw();
                        break;
                    }
                    case 7: {
                        e.widget.setData("hover", null);
                        ((Control)e.widget).redraw();
                        break;
                    }
                    case 9: {
                        MasterDetailsBlock.this.onSashPaint(e);
                        break;
                    }
                    case 11: {
                        this.hookSashListeners();
                    }
                }
            };
        }

        public void layout(boolean changed) {
            super.layout(changed);
            this.hookSashListeners();
        }

        public void layout(Control[] children) {
            super.layout(children);
            this.hookSashListeners();
        }

        private void hookSashListeners() {
            Control[] children;
            this.purgeSashes();
            Control[] controlArray = children = this.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Sash sash;
                Control element = controlArray[n2];
                if (element instanceof Sash && !this.sashes.contains(sash = (Sash)element)) {
                    sash.addListener(9, this.listener);
                    sash.addListener(6, this.listener);
                    sash.addListener(7, this.listener);
                    this.sashes.add(sash);
                }
                ++n2;
            }
        }

        private void purgeSashes() {
            Iterator<Sash> iter = this.sashes.iterator();
            while (iter.hasNext()) {
                Sash sash = iter.next();
                if (!sash.isDisposed()) continue;
                iter.remove();
            }
        }
    }
}

