/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.evaluator;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.UnitLocation;
import org.eclipse.ocl.examples.debug.vm.VariableFinder;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.evaluator.IStepper;
import org.eclipse.ocl.examples.debug.vm.utils.VMRuntimeException;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;

public interface VMEvaluationEnvironment
extends EvaluationEnvironment.EvaluationEnvironmentExtension {
    public @NonNull VariableFinder createVariableFinder(boolean var1);

    public @NonNull Element getCurrentIP();

    public @NonNull UnitLocation getCurrentLocation();

    public @NonNull VMDebugCore getDebugCore();

    public @NonNull NamedElement getDebuggableElement();

    public int getDepth();

    public long getID();

    public @NonNull NamedElement getOperation();

    public @NonNull Variable getPCVariable();

    public @Nullable VMEvaluationEnvironment getVMParentEvaluationEnvironment();

    public @NonNull VMEvaluationEnvironment getVMRootEvaluationEnvironment();

    public @NonNull Stack<StepperEntry> getStepperStack();

    public boolean isDeferredExecution();

    public void processDeferredTasks();

    public @NonNull Element setCurrentIP(@NonNull Element var1);

    public void throwVMException(@NonNull VMRuntimeException var1);

    public static class StepperEntry {
        public final @NonNull IStepper stepper;
        public final @NonNull Element element;
        private @Nullable Map<TypedElement, Object> partialResults;

        public StepperEntry(@NonNull IStepper stepper, @NonNull Element element) {
            this.stepper = stepper;
            this.element = element;
        }

        public void popFrom(@NonNull VMEvaluationEnvironment evaluationEnvironment) {
            Map<TypedElement, Object> partialResults2 = this.partialResults;
            if (partialResults2 != null) {
                for (TypedElement element : partialResults2.keySet()) {
                    if (element == null) continue;
                    evaluationEnvironment.remove(element);
                }
                partialResults2.clear();
                this.partialResults = null;
            }
        }

        public void pushTo(@NonNull VMEvaluationEnvironment evaluationEnvironment, @NonNull TypedElement element, @Nullable Object value) {
            Map<TypedElement, Object> partialResults2 = this.partialResults;
            if (partialResults2 == null) {
                this.partialResults = partialResults2 = new HashMap<TypedElement, Object>();
            }
            partialResults2.put(element, value);
            evaluationEnvironment.replace(element, value);
        }
    }
}

