/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.protocol;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.lob.CDOLobUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageInfo;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDOListFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisable;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOClassNotFoundException;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.commit.CDOChangeSetDataImpl;
import org.eclipse.emf.cdo.internal.common.commit.FailureCommitInfo;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockAreaImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockChangeInfoImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockOwnerImpl;
import org.eclipse.emf.cdo.internal.common.lock.CDOLockStateImpl;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.CDOIDAndBranchImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public abstract class CDODataInputImpl
extends ExtendedDataInput.Delegating
implements CDODataInput {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDODataInputImpl.class);

    public CDODataInputImpl(ExtendedDataInput delegate) {
        super(delegate);
    }

    @Override
    public int readXInt() throws IOException {
        if (this.isXCompression()) {
            return this.readVarInt();
        }
        return this.readInt();
    }

    @Override
    public long readXLong() throws IOException {
        if (this.isXCompression()) {
            return this.readVarLong();
        }
        return this.readLong();
    }

    @Override
    public CDOPackageUnit readCDOPackageUnit(ResourceSet resourceSet) throws IOException {
        InternalCDOPackageUnit packageUnit = (InternalCDOPackageUnit)CDOModelUtil.createPackageUnit();
        packageUnit.read(this, resourceSet);
        return packageUnit;
    }

    @Override
    public CDOPackageUnit[] readCDOPackageUnits(ResourceSet resourceSet) throws IOException {
        int size = this.readXInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Reading {0} package units", new Object[]{size});
        }
        CDOPackageUnit[] packageUnits = new CDOPackageUnit[size];
        int i = 0;
        while (i < size) {
            packageUnits[i] = this.readCDOPackageUnit(resourceSet);
            ++i;
        }
        return packageUnits;
    }

    @Override
    public CDOPackageUnit.Type readCDOPackageUnitType() throws IOException {
        return CDOPackageUnit.Type.values()[this.readByte()];
    }

    @Override
    public CDOPackageInfo readCDOPackageInfo() throws IOException {
        InternalCDOPackageInfo packageInfo = (InternalCDOPackageInfo)CDOModelUtil.createPackageInfo();
        packageInfo.read(this);
        return packageInfo;
    }

    @Override
    public String readCDOPackageURI() throws IOException {
        return this.getPackageURICompressor().read((ExtendedDataInput)this);
    }

    @Override
    public CDOClassifierRef readCDOClassifierRef() throws IOException {
        return new CDOClassifierRef(this);
    }

    @Override
    public EClassifier readCDOClassifierRefAndResolve() throws IOException {
        CDOClassifierRef classifierRef = this.readCDOClassifierRef();
        EClassifier classifier = classifierRef.resolve(this.getPackageRegistry());
        if (classifier == null) {
            throw new CDOClassNotFoundException(classifierRef.getPackageURI(), classifierRef.getClassifierName());
        }
        return classifier;
    }

    @Override
    public CDOType readCDOType() throws IOException {
        byte typeID = this.readByte();
        return CDOModelUtil.getType(typeID);
    }

    @Override
    public CDOBranch readCDOBranch() throws IOException {
        int branchID = this.readXInt();
        CDOBranch branch = this.getBranchManager().getBranch(branchID);
        if (branch == null) {
            throw new IOException("Branch not found: " + branchID);
        }
        return branch;
    }

    @Override
    public CDOBranchPoint readCDOBranchPoint() throws IOException {
        CDOBranch branch = this.readCDOBranch();
        long timeStamp = this.readXLong();
        return branch.getPoint(timeStamp);
    }

    @Override
    public CDOBranchVersion readCDOBranchVersion() throws IOException {
        CDOBranch branch = this.readCDOBranch();
        int version = this.readXInt();
        return branch.getVersion(version);
    }

    @Override
    public CDOChangeSetData readCDOChangeSetData() throws IOException {
        int size1 = this.readXInt();
        ArrayList<CDOIDAndVersion> newObjects = new ArrayList<CDOIDAndVersion>(size1);
        int i = 0;
        while (i < size1) {
            boolean revision = this.readBoolean();
            CDOIDAndVersion data = revision ? this.readCDORevision() : this.readCDOIDAndVersion();
            newObjects.add(data);
            ++i;
        }
        int size2 = this.readXInt();
        ArrayList<CDORevisionKey> changedObjects = new ArrayList<CDORevisionKey>(size2);
        int i2 = 0;
        while (i2 < size2) {
            boolean delta = this.readBoolean();
            CDORevisionKey data = delta ? this.readCDORevisionDelta() : this.readCDORevisionKey();
            changedObjects.add(data);
            ++i2;
        }
        int size3 = this.readXInt();
        ArrayList<CDOIDAndVersion> detachedObjects = new ArrayList<CDOIDAndVersion>(size3);
        int i3 = 0;
        while (i3 < size3) {
            CDOIDAndVersion data;
            CDOID id = this.readCDOID();
            int version = this.readXInt();
            boolean isCDORevisionKey = this.readBoolean();
            if (isCDORevisionKey) {
                CDOBranch branch = this.readCDOBranch();
                data = CDORevisionUtil.createRevisionKey(id, branch, version);
            } else {
                data = new CDOIDAndVersionImpl(id, version);
            }
            detachedObjects.add(data);
            ++i3;
        }
        return new CDOChangeSetDataImpl(newObjects, changedObjects, detachedObjects);
    }

    @Override
    public CDOCommitData readCDOCommitData() throws IOException {
        InternalCDOPackageRegistry packageRegistry = (InternalCDOPackageRegistry)this.getPackageRegistry();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setPackageRegistry((EPackage.Registry)packageRegistry);
        int size = this.readXInt();
        ArrayList<CDOPackageUnit> newPackageUnits = new ArrayList<CDOPackageUnit>(size);
        int i = 0;
        while (i < size) {
            CDOPackageUnit data = this.readCDOPackageUnit((ResourceSet)resourceSet);
            newPackageUnits.add(data);
            packageRegistry.putPackageUnit((InternalCDOPackageUnit)data);
            ++i;
        }
        CDOChangeSetData data = this.readCDOChangeSetData();
        return CDOCommitInfoUtil.createCommitData(newPackageUnits, data.getNewObjects(), data.getChangedObjects(), data.getDetachedObjects());
    }

    @Override
    public CDOCommitInfo readCDOCommitInfo() throws IOException {
        InternalCDOCommitInfoManager commitInfoManager = (InternalCDOCommitInfoManager)this.getCommitInfoManager();
        long timeStamp = this.readXLong();
        long previousTimeStamp = this.readXLong();
        if (this.readBoolean()) {
            CDOBranch branch = this.readCDOBranch();
            String userID = this.readString();
            String comment = this.readString();
            CDOBranchPoint mergeSource = CDOBranchUtil.readBranchPointOrNull(this);
            CDOCommitData commitData = this.readCDOCommitData();
            return commitInfoManager.createCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, mergeSource, commitData);
        }
        return new FailureCommitInfo(commitInfoManager, timeStamp, previousTimeStamp);
    }

    @Override
    public CDOLockChangeInfo readCDOLockChangeInfo() throws IOException {
        boolean isInvalidateAll = this.readBoolean();
        if (isInvalidateAll) {
            return CDOLockUtil.createLockChangeInfo();
        }
        CDOBranchPoint branchPoint = this.readCDOBranchPoint();
        CDOLockOwner lockOwner = this.readCDOLockOwner();
        CDOLockChangeInfo.Operation operation = (CDOLockChangeInfo.Operation)this.readEnum(CDOLockChangeInfo.Operation.class);
        IRWLockManager.LockType lockType = this.readCDOLockType();
        int n = this.readXInt();
        CDOLockState[] lockStates = new CDOLockState[n];
        int i = 0;
        while (i < n) {
            lockStates[i] = this.readCDOLockState();
            ++i;
        }
        return new CDOLockChangeInfoImpl(branchPoint, lockOwner, lockStates, operation, lockType);
    }

    @Override
    public IDurableLockingManager.LockArea readCDOLockArea() throws IOException {
        String durableLockingID = this.readString();
        CDOBranch branch = this.readCDOBranch();
        long timestamp = this.readXLong();
        String userID = this.readString();
        boolean readOnly = this.readBoolean();
        int nLockStates = this.readXInt();
        Map<CDOID, IDurableLockingManager.LockGrade> locks = CDOIDUtil.createMap();
        int i = 0;
        while (i < nLockStates) {
            CDOID key = this.readCDOID();
            IDurableLockingManager.LockGrade value = (IDurableLockingManager.LockGrade)this.readEnum(IDurableLockingManager.LockGrade.class);
            locks.put(key, value);
            ++i;
        }
        return new CDOLockAreaImpl(durableLockingID, userID, branch.getPoint(timestamp), readOnly, locks);
    }

    @Override
    public CDOLockOwner readCDOLockOwner() throws IOException {
        int session = this.readXInt();
        int view = this.readXInt();
        String lockAreaID = this.readString();
        boolean isDurableView = this.readBoolean();
        return new CDOLockOwnerImpl(session, view, lockAreaID, isDurableView);
    }

    @Override
    public CDOLockState readCDOLockState() throws IOException {
        boolean hasWriteOption;
        CDOLockOwner lockOwner;
        boolean sendingBranchWithID = this.readBoolean();
        Object target = !sendingBranchWithID ? this.readCDOID() : this.readCDOIDAndBranch();
        CDOLockStateImpl lockState = new CDOLockStateImpl(target);
        int nReadLockOwners = this.readXInt();
        int i = 0;
        while (i < nReadLockOwners) {
            lockOwner = this.readCDOLockOwner();
            lockState.addReadLockOwner(lockOwner);
            ++i;
        }
        boolean hasWriteLock = this.readBoolean();
        if (hasWriteLock) {
            lockOwner = this.readCDOLockOwner();
            lockState.setWriteLockOwner(lockOwner);
        }
        if (hasWriteOption = this.readBoolean()) {
            CDOLockOwner lockOwner2 = this.readCDOLockOwner();
            lockState.setWriteOptionOwner(lockOwner2);
        }
        return lockState;
    }

    @Override
    public IRWLockManager.LockType readCDOLockType() throws IOException {
        return (IRWLockManager.LockType)this.readEnum(IRWLockManager.LockType.class);
    }

    @Override
    public CDOID readCDOID() throws IOException {
        return CDOIDUtil.read(this);
    }

    @Override
    public CDOIDReference readCDOIDReference() throws IOException {
        return new CDOIDReference(this);
    }

    @Override
    public CDOIDAndVersion readCDOIDAndVersion() throws IOException {
        CDOID id = this.readCDOID();
        int version = this.readXInt();
        return new CDOIDAndVersionImpl(id, version);
    }

    @Override
    public CDOIDAndBranch readCDOIDAndBranch() throws IOException {
        CDOID id = this.readCDOID();
        CDOBranch branch = this.readCDOBranch();
        return new CDOIDAndBranchImpl(id, branch);
    }

    @Override
    public CDORevisionKey readCDORevisionKey() throws IOException {
        CDOID id = this.readCDOID();
        CDOBranch branch = this.readCDOBranch();
        int version = this.readXInt();
        return CDORevisionUtil.createRevisionKey(id, branch, version);
    }

    @Override
    public CDORevision readCDORevision() throws IOException {
        return this.readCDORevision(true);
    }

    @Override
    public CDORevision readCDORevision(boolean freeze) throws IOException {
        boolean notNull = this.readBoolean();
        if (notNull) {
            InternalCDORevision revision = (InternalCDORevision)this.getRevisionFactory().createRevision(null);
            revision.read(this);
            if (freeze) {
                revision.freeze();
            }
            return revision;
        }
        return null;
    }

    @Override
    public CDORevisable readCDORevisable() throws IOException {
        CDOBranch branch = this.readCDOBranch();
        int version = this.readXInt();
        long timeStamp = this.readXLong();
        long revised = this.readXLong();
        return CDORevisionUtil.createRevisable(branch, version, timeStamp, revised);
    }

    @Override
    public CDOList readCDOList(EClass owner, EStructuralFeature feature) throws IOException {
        int referenceChunk;
        int size = this.readXInt();
        if (size < 0) {
            size = -size;
            referenceChunk = this.readXInt();
            if (TRACER.isEnabled()) {
                TRACER.format("Read feature {0}: size={1}, referenceChunk={2}", new Object[]{feature.getName(), size, referenceChunk});
            }
        } else {
            referenceChunk = size;
            if (TRACER.isEnabled()) {
                TRACER.format("Read feature {0}: size={1}", new Object[]{feature.getName(), size});
            }
        }
        Object value = null;
        CDOType type = null;
        boolean isFeatureMap = FeatureMapUtil.isFeatureMap((EStructuralFeature)feature);
        if (!isFeatureMap) {
            type = CDOModelUtil.getType(feature.getEType());
        }
        InternalCDOList list = (InternalCDOList)this.getListFactory().createList(size, size, referenceChunk);
        if (feature instanceof EReference && list instanceof InternalCDOList.ConfigurableEquality) {
            ((InternalCDOList.ConfigurableEquality)list).setUseEquals(false);
        }
        int j = 0;
        while (j < referenceChunk) {
            if (isFeatureMap) {
                EStructuralFeature innerFeature;
                boolean demandCreated = this.readBoolean();
                if (demandCreated) {
                    EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
                    ePackage.setNsURI(this.readString());
                    EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                    eClass.setName(this.readString());
                    ePackage.getEClassifiers().add((Object)eClass);
                    if (this.readBoolean()) {
                        EReference eReference = EcoreFactory.eINSTANCE.createEReference();
                        eReference.setEType((EClassifier)EcorePackage.Literals.EOBJECT);
                        innerFeature = eReference;
                    } else {
                        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                        eAttribute.setEType((EClassifier)XMLTypePackage.eINSTANCE.getAnySimpleType());
                        innerFeature = eAttribute;
                    }
                    innerFeature.setName(this.readString());
                    innerFeature.setDerived(true);
                    innerFeature.setTransient(true);
                    innerFeature.setVolatile(true);
                    eClass.getEStructuralFeatures().add((Object)innerFeature);
                } else {
                    EClass eClass = (EClass)this.readCDOClassifierRefAndResolve();
                    innerFeature = eClass.getEStructuralFeature(this.readXInt());
                }
                type = CDOModelUtil.getType(innerFeature.getEType());
                value = type.readValue(this);
                value = CDORevisionUtil.createFeatureMapEntry(innerFeature, value);
            } else {
                value = type.readValue(this);
            }
            list.set(j, value);
            if (TRACER.isEnabled()) {
                TRACER.trace("    " + value);
            }
            ++j;
        }
        return list;
    }

    @Override
    public Object readCDOFeatureValue(EStructuralFeature feature) throws IOException {
        CDOType type = CDOModelUtil.getType(feature);
        Object value = type.readValue(this);
        if (value instanceof CDOLob) {
            CDOLob lob = (CDOLob)value;
            CDOLobUtil.setStore(this.getLobStore(), lob);
        }
        return value;
    }

    @Override
    public CDORevisionDelta readCDORevisionDelta() throws IOException {
        return new CDORevisionDeltaImpl(this);
    }

    @Override
    public CDOFeatureDelta readCDOFeatureDelta(EClass owner) throws IOException {
        int typeOrdinal = this.readXInt();
        CDOFeatureDelta.Type type = CDOFeatureDelta.Type.values()[typeOrdinal];
        switch (type) {
            case ADD: {
                return new CDOAddFeatureDeltaImpl(this, owner);
            }
            case SET: {
                return new CDOSetFeatureDeltaImpl(this, owner);
            }
            case LIST: {
                return new CDOListFeatureDeltaImpl(this, owner);
            }
            case MOVE: {
                return new CDOMoveFeatureDeltaImpl(this, owner);
            }
            case CLEAR: {
                return new CDOClearFeatureDeltaImpl(this, owner);
            }
            case REMOVE: {
                return new CDORemoveFeatureDeltaImpl(this, owner);
            }
            case CONTAINER: {
                return new CDOContainerFeatureDeltaImpl(this, owner);
            }
            case UNSET: {
                return new CDOUnsetFeatureDeltaImpl(this, owner);
            }
        }
        throw new IOException(MessageFormat.format(Messages.getString("CDODataInputImpl.5"), typeOrdinal));
    }

    @Override
    public Object readCDORevisionOrPrimitive() throws IOException {
        CDOType type = this.readCDOType();
        return type.readValue(this);
    }

    @Override
    public Object readCDORevisionOrPrimitiveOrClassifier() throws IOException {
        boolean isClassifier = this.readBoolean();
        if (isClassifier) {
            return this.readCDOClassifierRefAndResolve();
        }
        return this.readCDORevisionOrPrimitive();
    }

    protected boolean isXCompression() {
        return false;
    }

    protected StringIO getPackageURICompressor() {
        return StringIO.DIRECT;
    }

    protected abstract CDOBranchManager getBranchManager();

    protected abstract CDOCommitInfoManager getCommitInfoManager();

    protected abstract CDORevisionFactory getRevisionFactory();

    protected abstract CDOListFactory getListFactory();

    protected abstract CDOLobStore getLobStore();

    public static final class Default
    extends CDODataInputImpl {
        public Default(ExtendedDataInput delegate) {
            super(delegate);
        }

        @Override
        protected CDORevisionFactory getRevisionFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CDOPackageRegistry getPackageRegistry() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CDOLobStore getLobStore() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CDOListFactory getListFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CDOCommitInfoManager getCommitInfoManager() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected CDOBranchManager getBranchManager() {
            throw new UnsupportedOperationException();
        }
    }
}

