/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeHelper;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeColumnCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeColumnStrategy;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezePositionCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezePositionStrategy;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeRowCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeRowStrategy;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeSelectionCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.FreezeSelectionStrategy;
import org.eclipse.nebula.widgets.nattable.freeze.command.IFreezeCommand;
import org.eclipse.nebula.widgets.nattable.freeze.command.IFreezeCoordinatesProvider;
import org.eclipse.nebula.widgets.nattable.freeze.command.UnFreezeGridCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class FreezeCommandHandler
extends AbstractLayerCommandHandler<IFreezeCommand> {
    protected final FreezeLayer freezeLayer;
    protected final ViewportLayer viewportLayer;
    protected final SelectionLayer selectionLayer;

    public FreezeCommandHandler(FreezeLayer freezeLayer, ViewportLayer viewportLayer, SelectionLayer selectionLayer) {
        this.freezeLayer = freezeLayer;
        this.viewportLayer = viewportLayer;
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<IFreezeCommand> getCommandClass() {
        return IFreezeCommand.class;
    }

    @Override
    public boolean doCommand(IFreezeCommand command) {
        if (command instanceof FreezeColumnCommand) {
            FreezeColumnCommand freezeColumnCommand = (FreezeColumnCommand)command;
            FreezeColumnStrategy coordinatesProvider = new FreezeColumnStrategy(this.freezeLayer, this.viewportLayer, freezeColumnCommand.getColumnPosition());
            this.handleFreezeCommand(coordinatesProvider, freezeColumnCommand.isToggle(), command.isOverrideFreeze());
            return true;
        }
        if (command instanceof FreezeRowCommand) {
            FreezeRowCommand freezeRowCommand = (FreezeRowCommand)command;
            FreezeRowStrategy coordinatesProvider = new FreezeRowStrategy(this.freezeLayer, this.viewportLayer, freezeRowCommand.getRowPosition());
            this.handleFreezeCommand(coordinatesProvider, freezeRowCommand.isToggle(), command.isOverrideFreeze());
            return true;
        }
        if (command instanceof FreezePositionCommand) {
            FreezePositionCommand freezePositionCommand = (FreezePositionCommand)command;
            FreezePositionStrategy coordinatesProvider = new FreezePositionStrategy(this.freezeLayer, this.viewportLayer, freezePositionCommand.getColumnPosition(), freezePositionCommand.getRowPosition());
            this.handleFreezeCommand(coordinatesProvider, freezePositionCommand.isToggle(), command.isOverrideFreeze());
            return true;
        }
        if (command instanceof FreezeSelectionCommand) {
            FreezeSelectionStrategy coordinatesProvider = new FreezeSelectionStrategy(this.freezeLayer, this.viewportLayer, this.selectionLayer);
            this.handleFreezeCommand(coordinatesProvider, command.isToggle(), command.isOverrideFreeze());
            return true;
        }
        if (command instanceof UnFreezeGridCommand) {
            this.handleUnfreeze();
            return true;
        }
        return false;
    }

    protected void handleFreezeCommand(IFreezeCoordinatesProvider coordinatesProvider, boolean toggle, boolean override) {
        if (!this.freezeLayer.isFrozen() || override) {
            if (this.freezeLayer.isFrozen() && override) {
                FreezeHelper.resetViewport(this.freezeLayer, this.viewportLayer);
            }
            PositionCoordinate topLeftPosition = coordinatesProvider.getTopLeftPosition();
            PositionCoordinate bottomRightPosition = coordinatesProvider.getBottomRightPosition();
            FreezeHelper.freeze(this.freezeLayer, this.viewportLayer, topLeftPosition, bottomRightPosition);
        } else if (toggle) {
            this.handleUnfreeze();
        }
    }

    protected void handleUnfreeze() {
        FreezeHelper.unfreeze(this.freezeLayer, this.viewportLayer);
    }
}

