/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j;

import org.eclipse.net4j.protocol.IProtocol;
import org.eclipse.net4j.protocol.IProtocolProvider;
import org.eclipse.net4j.util.concurrent.NonBlockingLongCounter;
import org.eclipse.net4j.util.container.IManagedContainer;

public abstract class ContainerProtocolProvider
implements IProtocolProvider {
    private static NonBlockingLongCounter counter = new NonBlockingLongCounter();
    private IManagedContainer container;
    private String productGroup;

    protected ContainerProtocolProvider(IManagedContainer container, String productGroup) {
        this.container = container;
        this.productGroup = productGroup;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public String getProductGroup() {
        return this.productGroup;
    }

    @Override
    public IProtocol<?> getProtocol(String type) {
        String description = "protocol-" + counter.increment();
        return (IProtocol)this.container.getElement(this.productGroup, type, description, false);
    }

    public static class Client
    extends ContainerProtocolProvider {
        public Client(IManagedContainer container) {
            super(container, "org.eclipse.net4j.clientProtocols");
        }
    }

    public static class Server
    extends ContainerProtocolProvider {
        public Server(IManagedContainer container) {
            super(container, "org.eclipse.net4j.serverProtocols");
        }
    }
}

