/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.eclipse.net4j.util.concurrent.IWorkSerializer;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.log.OMLogger;

@Deprecated
public class ExecutorWorkSerializer
extends Lifecycle
implements IWorkSerializer {
    private final Queue<Runnable> workQueue = new LinkedList<Runnable>();
    private Executor executor;
    private volatile boolean working;
    private volatile boolean disposed;

    public ExecutorWorkSerializer() {
    }

    public ExecutorWorkSerializer(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.checkInactive();
        this.executor = executor;
    }

    @Override
    public synchronized boolean addWork(Runnable runnable) {
        if (this.disposed) {
            return false;
        }
        if (!this.working && this.isActive()) {
            this.startWork(runnable);
        } else {
            this.workQueue.add(runnable);
        }
        return true;
    }

    @Override
    public synchronized void dispose() {
        LifecycleUtil.deactivate((Object)this, OMLogger.Level.DEBUG);
    }

    @Override
    public String toString() {
        return ExecutorWorkSerializer.class.getSimpleName();
    }

    protected void handleException(Runnable runnable, Throwable ex) {
    }

    protected void noWork() {
    }

    private void startWork(final Runnable runnable) {
        this.working = true;
        if (!this.disposed) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable ex) {
                        try {
                            ExecutorWorkSerializer.this.handleException(runnable, ex);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ExecutorWorkSerializer.this.workDone();
                }
            });
        }
    }

    private synchronized void workDone() {
        Runnable runnable = this.workQueue.poll();
        if (runnable != null) {
            this.startWork(runnable);
        } else {
            this.noWork();
            this.working = false;
        }
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.executor, "executor");
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        this.workDone();
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.disposed = true;
        this.working = false;
        this.workQueue.clear();
        super.doDeactivate();
    }
}

