/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.commit.handler;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;

public class TextCommitInfoLog
implements CDOCommitInfoHandler {
    private PrintStream printStream;

    public TextCommitInfoLog(OutputStream stream) {
        this.printStream = stream instanceof PrintStream ? (PrintStream)stream : new PrintStream(stream);
    }

    @Override
    public void handleCommitInfo(CDOCommitInfo commitInfo) {
        try {
            if (this.printStream != null) {
                this.printStream.println(commitInfo);
                for (CDOPackageUnit packageUnit : commitInfo.getNewPackageUnits()) {
                    this.printStream.println("  P " + packageUnit.getID());
                }
                CDOCommitInfoUtil.dump(this.printStream, commitInfo);
                this.printStream.flush();
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void handleException(Exception ex) {
        OM.LOG.error((Throwable)ex);
    }
}

