/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitHistory;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.net4j.util.collection.GrowingRandomAccessList;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.FinishedEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public class CDOCommitHistoryImpl
extends Container<CDOCommitInfo>
implements CDOCommitHistory {
    private static final CDOCommitInfo[] NO_ELEMENTS = new CDOCommitInfo[0];
    private final CDOCommitHistory.TriggerLoadElement triggerLoadElement = new TriggerLoadElementImpl();
    private final CDOCommitInfoManager manager;
    private final CDOBranch branch;
    private final GrowingRandomAccessList<CDOCommitInfo> commitInfos = new GrowingRandomAccessList(CDOCommitInfo.class, 50);
    private final Object loadLock = new Object();
    private int loadCount = 50;
    private CDOCommitInfo[] elements;
    private boolean appendingTriggerLoadElement;
    private boolean full;
    private boolean loading;

    public CDOCommitHistoryImpl(CDOCommitInfoManager manager, CDOBranch branch) {
        super(true);
        this.manager = manager;
        this.branch = branch;
    }

    @Override
    public final CDOCommitInfoManager getManager() {
        return this.manager;
    }

    @Override
    public final CDOBranch getBranch() {
        return this.branch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getLoadCount() {
        Object object = this.loadLock;
        synchronized (object) {
            return this.loadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setLoadCount(int loadCount) {
        Object object = this.loadLock;
        synchronized (object) {
            this.loadCount = loadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isAppendingTriggerLoadElement() {
        Object object = this.loadLock;
        synchronized (object) {
            return this.appendingTriggerLoadElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setAppendingTriggerLoadElement(boolean appendingTriggerLoadElement) {
        int event = 0;
        Object object = this.loadLock;
        synchronized (object) {
            if (this.appendingTriggerLoadElement != appendingTriggerLoadElement) {
                this.appendingTriggerLoadElement = appendingTriggerLoadElement;
                this.elements = null;
                if (!this.full) {
                    event = appendingTriggerLoadElement ? 1 : 2;
                }
            }
        }
        switch (event) {
            case 1: {
                this.fireElementAddedEvent(this.triggerLoadElement);
                break;
            }
            case 2: {
                this.fireElementRemovedEvent(this.triggerLoadElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final CDOCommitInfo getFirstElement() {
        this.checkActive();
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loading) {
                if (this.elements == null) {
                    return null;
                }
                return this.elements[0];
            }
            if (this.commitInfos.isEmpty()) {
                return null;
            }
            return (CDOCommitInfo)this.commitInfos.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final CDOCommitInfo getLastElement() {
        this.checkActive();
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loading) {
                if (this.elements == null) {
                    return null;
                }
                return this.elements[this.elements.length - 1];
            }
            if (this.commitInfos.isEmpty()) {
                return null;
            }
            return (CDOCommitInfo)this.commitInfos.getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final CDOCommitInfo getElement(int index) {
        this.checkActive();
        Object object = this.loadLock;
        synchronized (object) {
            if (!this.loading) {
                return (CDOCommitInfo)this.commitInfos.get(index);
            }
            if (this.elements == null) {
                return null;
            }
            return this.elements[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CDOCommitInfo[] getElements() {
        this.checkActive();
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loading) {
                if (this.elements == null) {
                    return NO_ELEMENTS;
                }
                return this.elements;
            }
            if (this.elements == null) {
                int size = this.commitInfos.size();
                if (!this.full && this.appendingTriggerLoadElement) {
                    this.elements = (CDOCommitInfo[])this.commitInfos.toArray((Object[])new CDOCommitInfo[size + 1]);
                    this.elements[size] = this.triggerLoadElement;
                } else {
                    this.elements = (CDOCommitInfo[])this.commitInfos.toArray((Object[])new CDOCommitInfo[size]);
                }
            }
            return this.elements;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final int size() {
        this.checkActive();
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loading) {
                if (this.elements == null) {
                    return 0;
                }
                return this.elements.length;
            }
            int size = this.commitInfos.size();
            if (!this.full && this.appendingTriggerLoadElement) {
                ++size;
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isEmpty() {
        this.checkActive();
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loading) {
                if (this.elements == null) {
                    return true;
                }
                if (this.elements.length != 0) return false;
                return true;
            }
            if (this.full) return this.commitInfos.isEmpty();
            if (!this.appendingTriggerLoadElement) return this.commitInfos.isEmpty();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isFull() {
        Object object = this.loadLock;
        synchronized (object) {
            return this.full;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isLoading() {
        Object object = this.loadLock;
        synchronized (object) {
            return this.loading;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void waitWhileLoading(long timeout) {
        long end = System.currentTimeMillis() + timeout;
        Object object = this.loadLock;
        synchronized (object) {
            while (this.loading) {
                try {
                    long remaining = end - System.currentTimeMillis();
                    if (remaining <= 0L) {
                        return;
                    }
                    this.loadLock.wait(remaining);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void handleCommitInfo(CDOCommitInfo commitInfo) {
        Object object = this.loadLock;
        synchronized (object) {
            this.loading = true;
        }
        List<CDOCommitInfo> addedCommitInfos = Collections.emptyList();
        try {
            if (this.addCommitInfo(commitInfo)) {
                addedCommitInfos = Collections.singletonList(commitInfo);
            }
        }
        finally {
            this.finishLoading(addedCommitInfos, null);
        }
    }

    @Override
    public final boolean triggerLoad() {
        return this.triggerLoad(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean triggerLoad(final CDOCommitInfoHandler handler) {
        Object object = this.loadLock;
        synchronized (object) {
            block4: {
                if (!this.full && !this.loading) break block4;
                return false;
            }
            this.loading = true;
            new Thread("CDOCommitHistoryLoader"){

                @Override
                public void run() {
                    ArrayList<CDOCommitInfo> addedCommitInfos = new ArrayList<CDOCommitInfo>();
                    try {
                        try {
                            CDOCommitHistoryImpl.this.loadCommitInfos(CDOCommitHistoryImpl.this.loadCount, addedCommitInfos);
                        }
                        catch (Throwable ex) {
                            OM.LOG.error(ex);
                            CDOCommitHistoryImpl.this.finishLoading(addedCommitInfos, handler);
                        }
                    }
                    finally {
                        CDOCommitHistoryImpl.this.finishLoading(addedCommitInfos, handler);
                    }
                }
            }.start();
        }
        return true;
    }

    protected void loadCommitInfos(int loadCount, final List<CDOCommitInfo> addedCommitInfos) {
        final CDOCommitInfo[] lastCommitInfo = new CDOCommitInfo[]{this.getLastCommitInfo()};
        long timeStamp = 0L;
        int delivered = 0;
        timeStamp = lastCommitInfo[0] == null ? this.manager.getLastCommitOfBranch(this.branch, false) : lastCommitInfo[0].getPreviousTimeStamp();
        if (timeStamp != 0L) {
            CDOCommitInfo commitInfo;
            while ((commitInfo = this.manager.getCommitInfo(timeStamp, false)) != null) {
                if (this.addCommitInfo(commitInfo)) {
                    addedCommitInfos.add(commitInfo);
                    lastCommitInfo[0] = commitInfo;
                    ++delivered;
                }
                if (commitInfo.isInitialCommit()) {
                    this.setFull();
                    break;
                }
                timeStamp = commitInfo.getPreviousTimeStamp();
            }
        }
        if (delivered < loadCount && !this.isFull()) {
            final int[] loaded = new int[1];
            this.manager.getCommitInfos(this.branch, timeStamp, null, null, -loadCount, new CDOCommitInfoHandler(){

                @Override
                public void handleCommitInfo(CDOCommitInfo commitInfo) {
                    loaded[0] = loaded[0] + 1;
                    if (CDOCommitHistoryImpl.this.addCommitInfo(commitInfo)) {
                        addedCommitInfos.add(commitInfo);
                        lastCommitInfo[0] = commitInfo;
                    }
                }
            });
            if (loaded[0] < loadCount) {
                this.setFull();
            } else if (lastCommitInfo[0] != null) {
                long previousTimeStamp = lastCommitInfo[0].getPreviousTimeStamp();
                while ((lastCommitInfo[0] = this.manager.getCommitInfo(previousTimeStamp, false)) != null) {
                    if (this.addCommitInfo(lastCommitInfo[0])) {
                        addedCommitInfos.add(lastCommitInfo[0]);
                    }
                    if (lastCommitInfo[0].isInitialCommit()) {
                        this.setFull();
                        break;
                    }
                    previousTimeStamp = lastCommitInfo[0].getPreviousTimeStamp();
                }
            }
        }
        if (this.appendingTriggerLoadElement && !this.isFull()) {
            addedCommitInfos.add(this.triggerLoadElement);
        }
    }

    protected boolean filterCommitInfo(CDOCommitInfo commitInfo) {
        return this.branch != null && this.branch != commitInfo.getBranch();
    }

    protected final boolean addCommitInfo(CDOCommitInfo commitInfo) {
        this.checkLoading();
        if (commitInfo == null || this.filterCommitInfo(commitInfo)) {
            return false;
        }
        long timeStamp = commitInfo.getTimeStamp();
        if (this.commitInfos.isEmpty() || timeStamp > ((CDOCommitInfo)this.commitInfos.getFirst()).getTimeStamp()) {
            this.commitInfos.addFirst((Object)commitInfo);
        } else if (timeStamp < ((CDOCommitInfo)this.commitInfos.getLast()).getTimeStamp()) {
            this.commitInfos.addLast((Object)commitInfo);
        } else {
            ListIterator it = this.commitInfos.listIterator();
            while (it.hasNext()) {
                CDOCommitInfo current = (CDOCommitInfo)it.next();
                long currentTimeStamp = current.getTimeStamp();
                if (timeStamp == currentTimeStamp) {
                    return false;
                }
                if (timeStamp >= currentTimeStamp) continue;
                it.add(commitInfo);
                break;
            }
        }
        return true;
    }

    protected final void deliverFinish(List<CDOCommitInfo> addedCommitInfos, CDOCommitInfoHandler handler) {
        if (handler instanceof IListener) {
            IListener listener = (IListener)handler;
            listener.notifyEvent((IEvent)new FinishedEvent(addedCommitInfos));
        }
    }

    protected final void setFull() {
        this.full = true;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.manager.addCommitInfoHandler(this);
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        this.triggerLoad();
    }

    protected void doDeactivate() throws Exception {
        this.manager.removeCommitInfoHandler(this);
        super.doDeactivate();
    }

    private void checkLoading() {
        if (!this.loading) {
            throw new IllegalStateException("Not loading");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishLoading(List<CDOCommitInfo> addedCommitInfos, CDOCommitInfoHandler handler) {
        Object object = this.loadLock;
        synchronized (object) {
            this.elements = null;
            this.loading = false;
            this.loadLock.notifyAll();
        }
        if (!addedCommitInfos.isEmpty()) {
            this.fireElementsAddedEvent(addedCommitInfos.toArray(new CDOCommitInfo[addedCommitInfos.size()]));
            if (handler != null) {
                for (CDOCommitInfo commitInfo : addedCommitInfos) {
                    handler.handleCommitInfo(commitInfo);
                }
                this.deliverFinish(addedCommitInfos, handler);
            }
        }
    }

    private CDOCommitInfo getLastCommitInfo() {
        this.checkLoading();
        if (this.commitInfos.isEmpty()) {
            return null;
        }
        return (CDOCommitInfo)this.commitInfos.getLast();
    }

    public static final class Empty
    extends Container<CDOCommitInfo>
    implements CDOCommitHistory {
        public CDOCommitInfo[] getElements() {
            return NO_ELEMENTS;
        }

        @Override
        public void handleCommitInfo(CDOCommitInfo commitInfo) {
        }

        @Override
        public CDOCommitInfoManager getManager() {
            return null;
        }

        @Override
        public CDOBranch getBranch() {
            return null;
        }

        @Override
        public boolean isAppendingTriggerLoadElement() {
            return false;
        }

        @Override
        public void setAppendingTriggerLoadElement(boolean appendingTriggerLoadElement) {
        }

        @Override
        public CDOCommitInfo getFirstElement() {
            return null;
        }

        @Override
        public CDOCommitInfo getLastElement() {
            return null;
        }

        @Override
        public CDOCommitInfo getElement(int index) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public void waitWhileLoading(long timeout) {
        }

        @Override
        public int getLoadCount() {
            return 0;
        }

        @Override
        public void setLoadCount(int loadCount) {
        }

        @Override
        public boolean triggerLoad() {
            return false;
        }

        @Override
        public boolean triggerLoad(CDOCommitInfoHandler handler) {
            return false;
        }

        @Override
        public boolean isFull() {
            return true;
        }
    }

    private final class TriggerLoadElementImpl
    implements CDOCommitHistory.TriggerLoadElement {
        private TriggerLoadElementImpl() {
        }

        @Override
        public CDOCommitHistory getHistory() {
            return CDOCommitHistoryImpl.this;
        }

        @Override
        public CDOCommitInfoManager getCommitInfoManager() {
            return CDOCommitHistoryImpl.this.manager;
        }

        @Override
        public CDOBranch getBranch() {
            return null;
        }

        @Override
        public long getTimeStamp() {
            return 0L;
        }

        @Override
        public long getPreviousTimeStamp() {
            return 0L;
        }

        @Override
        public CDOCommitInfo getPreviousCommitInfo() {
            return null;
        }

        @Override
        public String getUserID() {
            return null;
        }

        @Override
        public String getComment() {
            return "Load more history elements";
        }

        @Override
        public CDOBranchPoint getMergeSource() {
            return null;
        }

        @Override
        public CDOCommitInfo getMergedCommitInfo() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isInitialCommit() {
            return false;
        }

        @Override
        public boolean isCommitDataLoaded() {
            return true;
        }

        @Override
        public List<CDOPackageUnit> getNewPackageUnits() {
            return null;
        }

        @Override
        public List<CDOIDAndVersion> getNewObjects() {
            return null;
        }

        @Override
        public List<CDORevisionKey> getChangedObjects() {
            return null;
        }

        @Override
        public List<CDOIDAndVersion> getDetachedObjects() {
            return null;
        }

        @Override
        public Map<CDOID, CDOChangeKind> getChangeKinds() {
            return null;
        }

        @Override
        public CDOChangeKind getChangeKind(CDOID id) {
            return null;
        }

        @Override
        public void merge(CDOChangeSetData changeSetData) {
        }

        @Override
        public CDOChangeSetData copy() {
            return null;
        }
    }
}

