/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.CommitUtil;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.core.op.RevertCommitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.command.CommitCommandHandler;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.RevertFailureDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RevertHandler
extends CommitCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IRepositoryCommit> repoCommits = this.getCommits(event);
        Repository repo = repoCommits.get(0).getRepository();
        if (repo.isBare()) {
            return null;
        }
        if (repoCommits.stream().anyMatch(c -> repo != c.getRepository())) {
            return null;
        }
        final List commits = repoCommits.stream().map(IRepositoryCommit::getRevCommit).collect(Collectors.toList());
        try {
            if (!CommitUtil.areCommitsInCurrentBranch(commits, (Repository)repo)) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (String)UIText.RevertHandler_Error_Title, (String)UIText.RevertHandler_CommitsNotOnCurrentBranch);
                return null;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.RevertHandler_ErrorCheckingIfCommitsAreOnCurrentBranch, (Throwable)e);
        }
        BasicConfigurationDialog.show(repo);
        final RevertCommitOperation op = new RevertCommitOperation(repo, commits);
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(UIText.RevertHandler_JobName, commits.size())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                block8: {
                    try {
                        try {
                            op.execute(monitor);
                            RevCommit newHead = op.getNewHead();
                            List revertedRefs = op.getRevertedRefs();
                            if (newHead != null) {
                                if (revertedRefs.isEmpty()) {
                                    RevertHandler.showRevertedDialog();
                                }
                                break block8;
                            }
                            RevCommit newestUnmergedCommit = null;
                            for (RevCommit commit : commits) {
                                if (RevertHandler.this.contains(revertedRefs, commit)) continue;
                                newestUnmergedCommit = commit;
                                break;
                            }
                            RevertHandler.showFailureDialog(newestUnmergedCommit, op.getFailingResult());
                        }
                        catch (CoreException e) {
                            Activator.handleError(UIText.RevertOperation_InternalError, e, true);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.REVERT_COMMIT.equals(family) || super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }

    private boolean contains(List<Ref> refs, RevCommit commit) {
        for (Ref ref : refs) {
            ObjectId objectId = ref.getObjectId();
            if (objectId == null || !objectId.equals((AnyObjectId)commit.getId())) continue;
            return true;
        }
        return false;
    }

    private static void showFailureDialog(RevCommit commit, MergeResult result) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> RevertFailureDialog.show(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), commit, result));
    }

    private static void showRevertedDialog() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (String)UIText.RevertHandler_NoRevertTitle, (String)UIText.RevertHandler_AlreadyRevertedMessage));
    }
}

