/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.push.PushJob;
import org.eclipse.egit.ui.internal.push.PushMode;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class PushOperationUI {
    private final Repository repository;
    private final boolean dryRun;
    private final String destinationString;
    private final RemoteConfig config;
    private PushOperationSpecification spec;
    private CredentialsProvider credentialsProvider;
    private PushOperation op;
    private final String remoteName;
    private PushOperationResult expectedResult;
    private boolean showConfigureButton = true;
    @NonNull
    private PushMode pushMode = PushMode.UPSTREAM;

    public PushOperationUI(Repository repository, String remoteName, boolean dryRun) {
        this.repository = repository;
        this.spec = null;
        this.config = null;
        this.remoteName = remoteName;
        this.dryRun = dryRun;
        this.destinationString = NLS.bind((String)"{0} - {1}", (Object)repository.getDirectory().getParentFile().getName(), (Object)remoteName);
    }

    public PushOperationUI(Repository repository, RemoteConfig config, boolean dryRun) {
        this.repository = repository;
        this.spec = null;
        this.config = config;
        this.remoteName = null;
        this.dryRun = dryRun;
        this.destinationString = NLS.bind((String)"{0} - {1}", (Object)repository.getDirectory().getParentFile().getName(), (Object)config.getName());
    }

    public PushOperationUI(Repository repository, PushOperationSpecification spec, boolean dryRun) {
        this.repository = repository;
        this.spec = spec;
        this.config = null;
        this.remoteName = null;
        this.dryRun = dryRun;
        this.destinationString = spec.getURIsNumber() == 1 ? ((URIish)spec.getURIs().iterator().next()).toPrivateString() : NLS.bind((String)UIText.PushOperationUI_MultiRepositoriesDestinationString, (Object)spec.getURIsNumber());
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setExpectedResult(PushOperationResult expectedResult) {
        this.expectedResult = expectedResult;
    }

    public void setShowConfigureButton(boolean showConfigureButton) {
        this.showConfigureButton = showConfigureButton;
    }

    public PushOperationResult execute(IProgressMonitor monitor) throws CoreException {
        this.createPushOperation();
        if (this.credentialsProvider != null) {
            this.op.setCredentialsProvider(this.credentialsProvider);
        } else {
            this.op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        }
        try {
            this.op.run(monitor);
            return this.op.getOperationResult();
        }
        catch (InvocationTargetException e) {
            throw new CoreException(Activator.createErrorStatus(e.getCause().getMessage(), e.getCause()));
        }
    }

    private void createPushOperation() throws CoreException {
        if (this.remoteName != null) {
            this.op = new PushOperation(this.repository, this.remoteName, this.dryRun, GitSettings.getRemoteConnectionTimeout());
            return;
        }
        if (this.spec == null) {
            this.spec = new PushOperationSpecification();
            ArrayList<URIish> urisToPush = new ArrayList<URIish>();
            for (URIish uri : this.config.getPushURIs()) {
                urisToPush.add(uri);
            }
            if (urisToPush.isEmpty() && !this.config.getURIs().isEmpty()) {
                urisToPush.add((URIish)this.config.getURIs().get(0));
            }
            ArrayList pushRefSpecs = new ArrayList();
            pushRefSpecs.addAll(this.config.getPushRefSpecs());
            for (URIish uri : urisToPush) {
                try {
                    Collection remoteRefUpdates = Transport.findRemoteRefUpdatesFor((Repository)this.repository, pushRefSpecs, (Collection)this.config.getFetchRefSpecs());
                    this.spec.addURIRefUpdates(uri, remoteRefUpdates);
                }
                catch (NotSupportedException e) {
                    throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
                }
                catch (IOException e) {
                    throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
                }
            }
        }
        this.op = new PushOperation(this.repository, this.spec, this.dryRun, GitSettings.getRemoteConnectionTimeout());
    }

    public void start() {
        Repository repo = this.repository;
        if (repo == null) {
            return;
        }
        try {
            this.createPushOperation();
        }
        catch (CoreException e) {
            Activator.showErrorStatus(e.getLocalizedMessage(), e.getStatus());
            return;
        }
        if (this.credentialsProvider != null) {
            this.op.setCredentialsProvider(this.credentialsProvider);
        } else {
            this.op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        }
        PushJob job = new PushJob(NLS.bind((String)UIText.PushOperationUI_PushJobName, (Object)this.destinationString), repo, this.op, this.expectedResult, this.destinationString, this.showConfigureButton, this.pushMode);
        job.setUser(true);
        job.schedule();
    }

    public String getDestinationString() {
        return this.destinationString;
    }

    public void setPushMode(@NonNull PushMode mode) {
        this.pushMode = mode;
    }
}

