/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.snap.copy;

import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.copy.CustomDragEditPartsTracker;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;

public class DragEditPartsTrackerEx
extends CustomDragEditPartsTracker {
    public DragEditPartsTrackerEx(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    @Override
    protected Command getCommand() {
        CompoundCommand command;
        if (!this.isMove()) {
            command = new CompoundCommand();
            this.addSourceCommands(false, command);
            if (this.getTargetEditPart() != null) {
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
                if (command.canExecute()) {
                    return command;
                }
            }
        }
        command = new CompoundCommand();
        this.addSourceCommands(true, command);
        return command;
    }

    protected void addSourceCommands(boolean isMove, CompoundCommand command) {
        Request request = this.getTargetRequest();
        if (this.isCloneActive()) {
            List editparts = ToolUtilities.getSelectionWithoutDependants((EditPartViewer)this.getCurrentViewer());
            DuplicateRequest duplicateRequest = new DuplicateRequest();
            duplicateRequest.setEditParts(editparts);
            duplicateRequest.setExtendedData(request.getExtendedData());
            if (request instanceof ChangeBoundsRequest) {
                Point delta = ((ChangeBoundsRequest)request).getMoveDelta();
                MapModeUtil.getMapMode((IFigure)((IGraphicalEditPart)this.getTargetEditPart()).getFigure()).DPtoLP((Translatable)delta);
                duplicateRequest.setOffset(delta);
            }
            command.add(this.getTargetEditPart().getCommand((Request)duplicateRequest));
        } else {
            request.setType((Object)(isMove ? "move" : "drag"));
            for (EditPart editPart : this.getOperationSet()) {
                command.add(editPart.getCommand(request));
            }
        }
        request.setType((Object)"drop");
    }

    @Override
    protected String getCommandName() {
        if (!this.isMove()) {
            return "drop";
        }
        return super.getCommandName();
    }

    @Override
    protected boolean isMove() {
        int i = 0;
        while (i < this.getOperationSet().size()) {
            if (this.getOperationSet().get(i).equals(this.getSourceEditPart())) {
                return super.isMove();
            }
            if (this.getOperationSet().get(i) instanceof GroupEditPart) {
                GroupEditPart currPart = (GroupEditPart)this.getOperationSet().get(i);
                int j = 0;
                while (j < currPart.getChildren().size()) {
                    if (currPart.getChildren().get(j).equals(this.getSourceEditPart())) {
                        return super.isMove();
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    protected void executeCurrentCommand() {
        super.executeCurrentCommand();
        if (this.isActive() && this.getOperationSet().size() > 0 && this.getOperationSet().get(0) instanceof IGraphicalEditPart) {
            IGraphicalEditPart editpart = (IGraphicalEditPart)this.getOperationSet().get(0);
            if (editpart.getFigure() == null || editpart.getFigure().getParent() == null || editpart.getFigure().getParent().getLayoutManager() == null) {
                return;
            }
            editpart.getFigure().getParent().getLayoutManager().layout(editpart.getFigure().getParent());
            this.reveal((EditPart)editpart);
        }
    }

    protected void reveal(EditPart editpart) {
        editpart.getViewer().reveal(editpart);
    }

    @Override
    protected boolean handleDragInProgress() {
        boolean returnValue = super.handleDragInProgress();
        if (this.isInState(4) || this.isInState(32)) {
            this.updateAutoexposeHelper();
        }
        return returnValue;
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.isInState(4) || this.isInState(32)) {
            if (this.getAutoexposeHelper() != null) {
                return Cursors.HAND;
            }
            Control control = this.getCurrentViewer().getControl();
            if (control instanceof FigureCanvas) {
                Viewport viewport = ((FigureCanvas)control).getViewport();
                Rectangle rect = Rectangle.SINGLETON;
                viewport.getClientArea(rect);
                viewport.translateToParent((Translatable)rect);
                viewport.translateToAbsolute((Translatable)rect);
                if (!rect.contains(this.getLocation())) {
                    return this.getDisabledCursor();
                }
            }
        }
        return super.calculateCursor();
    }

    @Override
    protected boolean handleButtonDown(int button) {
        if (button == 1 && this.getSourceEditPart().getParent() instanceof GroupEditPart && this.getSourceEditPart().getParent().getSelected() != 0) {
            this.stateTransition(1, 2);
            return true;
        }
        return super.handleButtonDown(button);
    }

    @Override
    protected boolean handleDoubleClick(int button) {
        if (this.getSourceEditPart().getParent() instanceof GroupEditPart && this.getSourceEditPart().getSelected() == 0) {
            this.performSelection();
            return true;
        }
        return super.handleDoubleClick(button);
    }

    @Override
    protected void performSelection() {
        super.performSelection();
        if (this.getSourceEditPart().getParent() instanceof GroupEditPart && this.getSourceEditPart().getParent().getSelected() != 0) {
            this.getCurrentViewer().deselect(this.getSourceEditPart().getParent());
        }
    }

    @Override
    protected void snapPoint(ChangeBoundsRequest request) {
        Point moveDelta = request.getMoveDelta();
        if (this.getState() == 32) {
            int restrictedDirection = 0;
            if (moveDelta.x > 0) {
                restrictedDirection |= 0x10;
            } else if (moveDelta.x < 0) {
                restrictedDirection |= 8;
            }
            if (moveDelta.y > 0) {
                restrictedDirection |= 4;
            } else if (moveDelta.y < 0) {
                restrictedDirection |= 1;
            }
            request.getExtendedData().put("org.eclipse.gmf.runtime.diagram.ui.RestrictedDirections", restrictedDirection);
        }
        super.snapPoint(request);
    }

    @Override
    protected boolean handleKeyDown(KeyEvent e) {
        IGraphicalEditPart ep;
        if (this.acceptArrowKey(e) && this.isInState(1) && (ep = (IGraphicalEditPart)this.getSourceEditPart()) != null) {
            Point location = ep.getFigure().getBounds().getCenter();
            ep.getFigure().translateToAbsolute((Translatable)location);
            this.placeMouseInViewer(location);
            this.getCurrentInput().setMouseLocation(location.x, location.y);
        }
        return super.handleKeyDown(e);
    }
}

