/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.options;

import org.eclipse.ocl.pivot.messages.PivotMessages;

public interface ProblemHandler {

    public static class Phase
    implements Comparable<Phase> {
        public static Phase LEXER = new Phase(PivotMessages.Phase_Lexer);
        public static Phase PARSER = new Phase(PivotMessages.Phase_Parser);
        public static Phase ANALYZER = new Phase(PivotMessages.Phase_Analyzer);
        public static Phase VALIDATOR = new Phase(PivotMessages.Phase_Validator);
        public static Phase UTILITY = new Phase(PivotMessages.Phase_Utility);
        public static Phase UNPARSER = new Phase(PivotMessages.Phase_Unparser);
        private final String localizedName;

        protected Phase(String lname) {
            this.localizedName = lname;
        }

        @Override
        public final int compareTo(Phase o) {
            return this.localizedName.compareTo(o.localizedName);
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.localizedName == null ? 0 : this.localizedName.hashCode());
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Phase)) {
                return false;
            }
            Phase other = (Phase)obj;
            return !(this.localizedName == null ? other.localizedName != null : !this.localizedName.equals(other.localizedName));
        }

        public String toString() {
            return this.localizedName;
        }
    }

    public static enum Severity {
        OK(PivotMessages.Severity_OK, 0){

            @Override
            public boolean isOK() {
                return true;
            }
        }
        ,
        INFO(PivotMessages.Severity_Info, 1),
        WARNING(PivotMessages.Severity_Warning, 2),
        ERROR(PivotMessages.Severity_Error, 4),
        FATAL(PivotMessages.Severity_Fatal_Error, 4),
        CANCEL(PivotMessages.Severity_Cancel, 8);

        private final int diagnosticSeverity;
        private final String localizedName;

        private Severity(String lname, int sev) {
            this.localizedName = lname;
            this.diagnosticSeverity = sev;
        }

        public int getDiagnosticSeverity() {
            return this.diagnosticSeverity;
        }

        public boolean isOK() {
            return false;
        }

        public String toString() {
            return this.localizedName;
        }
    }
}

